/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaDebugFrame;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfo;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfoAccessor;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabbedDragDropListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class AltaTabDebugPanel
extends JPanel {
    JTabbedPane _tab;
    JLabel _lbl = new JLabel(ResMsgSimul.getString("PAN_EMPTY"));
    boolean _lblIsVisible;
    JPopupMenu _popupMenu;

    public AltaTabDebugPanel() {
        super(new BorderLayout());
        this.add((Component)this._lbl, "Center");
        this._lblIsVisible = true;
        this._tab = new JTabbedPane(1, 1){

            @Override
            public void removeTabAt(int index) {
                super.removeTabAt(index);
                AltaTabDebugPanel.this.switchView();
            }

            @Override
            public void addTab(String title, Component component) {
                super.addTab(title, component);
                AltaTabDebugPanel.this.switchView();
            }

            @Override
            public void addTab(String title, Icon icon, Component component) {
                super.addTab(title, icon, component);
                AltaTabDebugPanel.this.switchView();
            }

            @Override
            public void addTab(String title, Icon icon, Component component, String tip) {
                super.addTab(title, icon, component, tip);
                AltaTabDebugPanel.this.switchView();
            }
        };
        TabbedDragDropListener dragNDrop = new TabbedDragDropListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this._tab, 2, dragNDrop);
        new DropTarget(this._tab, dragNDrop);
        new DropTarget(this._lbl, dragNDrop);
    }

    public void setPopupMenu(JPopupMenu menu) {
        this._popupMenu = menu;
        this._lbl.setComponentPopupMenu(this._popupMenu);
        this._tab.setComponentPopupMenu(this._popupMenu);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._tab.getTabCount() == 0) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize();
    }

    private void switchView() {
        if (this._tab.getTabCount() == 0) {
            if (!this._lblIsVisible) {
                this.remove(this._tab);
                this.add((Component)this._lbl, "Center");
                this._lblIsVisible = true;
                this.revalidate();
                this.repaint();
            }
        } else if (this._lblIsVisible) {
            this.remove(this._lbl);
            this._lblIsVisible = false;
            this.add((Component)this._tab, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public void addTab(TabInfo tabInfo, Component c) {
        String title = tabInfo.getTitle();
        Icon icon = tabInfo.getIcon();
        String tip = tabInfo.getToolTip();
        this._tab.addTab(title, icon, c, tip);
    }

    public void removeTab(Component c) {
        int idx = this._tab.indexOfComponent(c);
        if (idx >= 0) {
            this._tab.removeTabAt(idx);
        }
    }

    public int getTabCount() {
        return this._tab.getTabCount();
    }

    public void setSelectedComponent(Component c) {
        this._tab.setSelectedComponent(c);
    }

    void saveInfo(Map<String, String> saveMap, String prefix) {
        int size = this._tab.getTabCount();
        int cpt = 0;
        for (int i = 0; i < this._tab.getTabCount(); ++i) {
            Component c = this._tab.getComponentAt(i);
            if (c instanceof TabInfoAccessor) {
                TabInfo tinf = ((TabInfoAccessor)((Object)c)).getTabInfo();
                String key = prefix + "." + Integer.toString(cpt++);
                saveMap.put(key, tinf.getCode());
                tinf.saveInfo(saveMap, key);
                continue;
            }
            --size;
        }
        saveMap.put(prefix + ".size", Integer.toString(size));
    }

    void readInfo(Map<String, String> config, String prefix, AltaDebugFrame debugFrame) {
        Integer size = debugFrame.readInteger(config, prefix + ".size");
        if (size == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            String key = prefix + "." + Integer.toString(i);
            String code = config.get(key);
            if (code == null) continue;
            debugFrame.createComponent(config, key, code, this);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test de Drag'n Drop");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem("Il fait beau"));
        popupMenu.add(new JMenuItem("aujourd'hui"));
        popupMenu.add(new JSeparator());
        popupMenu.add(new JMenuItem("Ok"));
        AltaTabDebugPanel _topLeft = new AltaTabDebugPanel();
        TabInfoTextArea tita = new TabInfoTextArea("TopLeft-1");
        _topLeft.addTab(tita, tita.createComponent(null, null, null));
        tita = new TabInfoTextArea("TopLeft-2");
        _topLeft.addTab(tita, tita.createComponent(null, null, null));
        _topLeft._popupMenu = popupMenu;
        AltaTabDebugPanel _topRight = new AltaTabDebugPanel();
        tita = new TabInfoTextArea("TopRight-1");
        _topRight.addTab(tita, tita.createComponent(null, null, null));
        AltaTabDebugPanel _bottomLeft = new AltaTabDebugPanel();
        tita = new TabInfoTextArea("BottomLeft-1");
        _bottomLeft.addTab(tita, tita.createComponent(null, null, null));
        tita = new TabInfoTextArea("BottomLeft-2");
        _bottomLeft.addTab(tita, tita.createComponent(null, null, null));
        AltaTabDebugPanel _bottomRight = new AltaTabDebugPanel();
        _bottomRight._popupMenu = popupMenu;
        JSplitPane top = new JSplitPane(1, _topLeft, _topRight);
        top.setOneTouchExpandable(true);
        top.setResizeWeight(0.5);
        JSplitPane bottom = new JSplitPane(1, _bottomLeft, _bottomRight);
        bottom.setOneTouchExpandable(true);
        bottom.setResizeWeight(0.5);
        JSplitPane root = new JSplitPane(0, top, bottom);
        root.setOneTouchExpandable(true);
        root.setResizeWeight(0.5);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)root, "Center");
        frame.setSize(450, 450);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    static class TabTextArea
    extends JPanel
    implements TabInfoAccessor {
        TabInfoTextArea _tinf;

        TabTextArea(TabInfoTextArea tinf) {
            super(new BorderLayout());
            this.add((Component)new JLabel("title"), "North");
            this.add(new JScrollPane(new JTextArea(10, 30)));
            this._tinf = tinf;
        }

        @Override
        public TabInfo getTabInfo() {
            return this._tinf;
        }
    }

    static class TabInfoTextArea
    extends TabInfo {
        String _title;

        TabInfoTextArea(String title) {
            this._title = title;
        }

        @Override
        public String getCode() {
            return "txt";
        }

        @Override
        public String getTitle() {
            return this._title;
        }

        @Override
        public Component createComponent(CentralizedStepper stepper, Map<String, String> config, String prefix) {
            return new TabTextArea(this);
        }
    }
}

