/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TableModelVariable
extends AbstractTableModel
implements ViewListener {
    public static final int FLOW = 1;
    public static final int STATE = 2;
    private SimStepper _stepper = null;
    private int _type;

    public TableModelVariable(int type) {
        this._type = type == 1 ? 1 : 2;
    }

    protected void setModel(ViewStepper vwStep) {
        this._stepper = vwStep != null && vwStep instanceof SimStepper ? (SimStepper)vwStep : null;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this._stepper == null) {
            return 0;
        }
        return (this._type == 2 ? this._stepper.getViewStates() : this._stepper.getViewFlows()).size();
    }

    @Override
    public Object getValueAt(int arg0, int column) {
        if (this._stepper == null) {
            return null;
        }
        List<ViewVariable> list = this._type == 1 ? this._stepper.getViewFlows() : this._stepper.getViewStates();
        ViewVariable var = list.get(arg0);
        if (var == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return var.getFinalName();
            }
            case 1: {
                return var.getSValue();
            }
        }
        return var;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return this._type == 2 && c == 1;
    }

    @Override
    public void setValueAt(Object item, int arg0, int arg1) {
        if (this._type != 2 || arg1 != 1) {
            throw new IllegalArgumentException("Assert !");
        }
        ViewVariable var = this._stepper.getViewStates().get(arg0);
        this._stepper.setValueOfState(var, (String)item);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgSimul.getString("PAN_STEP_NAME");
            }
            case 1: {
                return ResMsgSimul.getString("PAN_STEP_VAR_VALUE");
            }
        }
        return "<Error>";
    }

    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 5000;
            }
            case 1: {
                return 2500;
            }
        }
        return 1;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            default: 
        }
        return String.class;
    }

    @Override
    public void altaModelChanged(ViewStepper vwStep) {
        this.setModel(vwStep);
    }

    @Override
    public void altaTransitionUpdate(ViewTransition tr) {
    }

    @Override
    public void altaStateUpdate(ViewVariable state) {
        if (this._type == 2) {
            this.fireTableCellUpdated(state.getId() - 1, 1);
        }
    }

    @Override
    public void altaFlowUpdate(ViewVariable flow) {
        if (this._type == 1) {
            this.fireTableCellUpdated(flow.getId() - 1, 1);
        }
    }

    @Override
    public void altaOtherUpdate(int type, Object data) {
    }
}

