/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.seq;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfo;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfoAccessor;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqSet;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqSetModelListener;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqSetModelTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.xml.sax.SAXParseException;

public class TabSequences
extends TabInfo {
    private static Logger _LOG = Logger.getLogger(TabSequences.class.getPackage().getName());

    @Override
    public String getCode() {
        return "Sequences";
    }

    @Override
    public String getTitle() {
        return ResMsgSimul.getString("PAN_TITLE_SEQUENCES");
    }

    @Override
    public Component createComponent(CentralizedStepper stepper, Map<String, String> config, String prefix) {
        return new Content(stepper);
    }

    class Content
    extends JPanel
    implements TabInfoAccessor {
        SeqSetModelTable _model;
        JLabel _pathLoad;
        JLabelChangeModel _modelSize;
        JLabelChangeModel _modelError;
        NumberFormat _formatter;
        JFileChooser _dlg;

        public Content(final CentralizedStepper stepper) {
            super(new BorderLayout());
            this._formatter = null;
            this._model = new SeqSetModelTable();
            JTable table = new JTable(this._model);
            TableColumnModel tabColModel = table.getColumnModel();
            for (int i = 0; i < this._model.getColumnCount(); ++i) {
                tabColModel.getColumn(i).setPreferredWidth(this._model.getColumnWidth(i));
            }
            this.add((Component)new JScrollPane(table), "Center");
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(10));
            class LoadAction
            extends AbstractAction
            implements ViewListener {
                LoadAction(CentralizedStepper acastep) {
                    super(null, ResIcoCore.getImageIcon("BUT_LOAD"));
                    this.putValue("ShortDescription", ResMsgSimul.getString("PAN_SEQSET_ACTION_LOAD"));
                    acastep.addAltaListener(this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (stepper.getSimStepper() != null) {
                        Content.this.loadFile();
                    }
                }

                @Override
                public void altaModelChanged(ViewStepper acastep) {
                    this.setEnabled(acastep != null);
                }

                @Override
                public void altaTransitionUpdate(ViewTransition tr) {
                }

                @Override
                public void altaStateUpdate(ViewVariable state) {
                }

                @Override
                public void altaFlowUpdate(ViewVariable flow) {
                }

                @Override
                public void altaOtherUpdate(int type, Object data) {
                }
            }
            JButton load = new JButton(new LoadAction(stepper));
            load.setBorder(null);
            box.add(load);
            box.add(Box.createHorizontalStrut(10));
            this._pathLoad = new JLabel("<- ........");
            box.add(this._pathLoad);
            box.add(Box.createGlue());
            JButton init = new JButton(stepper.createAction(1));
            init.setBorder(null);
            init.setText(null);
            box.add(init);
            box.add(Box.createHorizontalStrut(10));
            JButton prev = new JButton(stepper.createAction(2));
            prev.setBorder(null);
            prev.setText(null);
            box.add(prev);
            box.add(Box.createHorizontalStrut(10));
            class FireSelectAction
            extends AbstractAction
            implements ListSelectionListener {
                FireSelectAction(JTable connectTable) {
                    super(null, ResIcoSimul.getImageIcon("FIRE_SELECT"));
                    this.putValue("ShortDescription", ResMsgSimul.getString("PAN_SEQSET_ACTION_FIRESELECT"));
                    connectTable.getSelectionModel().addListSelectionListener(this);
                }

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.setEnabled(Content.this._model.isSelectFireable());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Content.this._model.fireSelected();
                }
            }
            FireSelectAction actFireSelect = new FireSelectAction(table);
            actFireSelect.setEnabled(false);
            JButton fireSelect = new JButton(actFireSelect);
            fireSelect.setBorder(null);
            box.add(fireSelect);
            box.add(Box.createHorizontalStrut(10));
            this.add((Component)box, "North");
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(10));
            this._modelSize = new JLabelChangeModel("000 000"){

                @Override
                public void changeModel() {
                    this.refresh();
                }

                @Override
                public void changeState() {
                    this.refresh();
                }

                private void refresh() {
                    if (Content.this._formatter == null) {
                        Content.this._formatter = NumberFormat.getInstance();
                    }
                    this.setText(Content.this._formatter.format(Content.this._model.getCurrentSeqNumber()) + "/" + Content.this._formatter.format(Content.this._model.getSeqNumber()));
                }
            };
            this._model.addViewerModelListener(this._modelSize);
            box.add(this._modelSize);
            box.add(Box.createGlue());
            this._modelError = new JLabelChangeModel("000 000"){

                @Override
                public void changeModel() {
                    this.refresh();
                }

                @Override
                public void changeState() {
                    this.refresh();
                }

                private void refresh() {
                    if (Content.this._formatter == null) {
                        Content.this._formatter = NumberFormat.getInstance();
                    }
                    this.setText(Content.this._formatter.format(Content.this._model.getCurrentSeqErreur()) + "/" + Content.this._formatter.format(Content.this._model.getSeqErreur()));
                }
            };
            this._model.addViewerModelListener(this._modelError);
            box.add(this._modelError);
            this._modelError.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    Content.this.displayUnknowEvents(Content.this._pathLoad.getText());
                }
            });
            box.add(Box.createHorizontalStrut(10));
            this.add((Component)box, "South");
            this._model.connectTable(table);
            stepper.addAltaListener(this._model);
            this._model.altaModelChanged(stepper.getSimStepper());
        }

        private String formatMessage(String mess, String pattern, Object ... arguments) {
            try {
                mess = MessageFormat.format(pattern, arguments);
            }
            catch (Exception mfe) {
                _LOG.log(Level.WARNING, "Exception during create MessageFormat with key  [PAN_SEQSET_SAXEXCEPTION]", mfe);
            }
            return mess;
        }

        private void displayMessage(String mess) {
            JTextArea txt = new JTextArea(10, 40);
            txt.setText(mess);
            txt.setTabSize(4);
            txt.setWrapStyleWord(false);
            txt.setSelectionStart(0);
            txt.setSelectionEnd(0);
            txt.setEditable(false);
            txt.setSelectionColor(new JLabel().getBackground());
            txt.setBackground(new JLabel().getBackground());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), new JScrollPane(txt));
        }

        private void loadFile() {
            if (this._dlg == null) {
                this._dlg = new JFileChooser();
                FileFilterExtention xmlFilter = new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_XML"), ".xml").verifyRead(true);
                this._dlg.addChoosableFileFilter(xmlFilter);
                this._dlg.setFileFilter(xmlFilter);
            }
            if (this._dlg.showOpenDialog(this) != 0) {
                return;
            }
            File file = this._dlg.getSelectedFile();
            SeqSet set = new SeqSet();
            try {
                set.load(file);
            }
            catch (SAXParseException e) {
                String mess = this.formatMessage("SAXParseException during SeqSet file load", ResMsgSimul.getString("PAN_SEQSET_SAXEXCEPTION"), file.getAbsolutePath(), e.getMessage(), e.getLineNumber(), e.getColumnNumber());
                this.displayMessage(mess);
                return;
            }
            this._model.setSeqSet(set);
            this._pathLoad.setText(file.getAbsolutePath());
            this.displayUnknowEvents(this._pathLoad.getText());
        }

        private void displayUnknowEvents(String path) {
            Set<String> uEvts = this._model.getUnknowEvents();
            if (uEvts.size() > 0) {
                TreeSet<String> sUEvts = new TreeSet<String>();
                sUEvts.addAll(uEvts);
                StringBuffer sb = new StringBuffer((sUEvts.size() > 20 ? 20 : sUEvts.size()) * 10);
                int cpt = 0;
                for (String evt : sUEvts) {
                    sb.append("\n\t").append(evt);
                    if (++cpt <= 20) continue;
                    break;
                }
                if (sUEvts.size() > 20) {
                    sb.append("\n\t...");
                }
                String mess = this.formatMessage("Unknow events", ResMsgSimul.getString("PAN_SEQSET_UNKNOW_EVENTS"), path, sb.toString());
                this.displayMessage(mess);
            }
        }

        @Override
        public TabInfo getTabInfo() {
            return TabSequences.this;
        }

        abstract class JLabelChangeModel
        extends JLabel
        implements SeqSetModelListener {
            public JLabelChangeModel(String text) {
                super(text);
            }
        }
    }
}

