/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AltaConfigTableCellRenderer
extends DefaultTableCellRenderer {
    public AltaConfigTableCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(value instanceof AltaConfig)) {
            return this;
        }
        AltaConfig cfg = (AltaConfig)value;
        Map<String, String> inits = cfg.getStates();
        if (inits.isEmpty()) {
            this.setText("");
            this.setToolTipText(null);
        } else {
            String text = null;
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            int i = 0;
            for (Map.Entry<String, String> init : inits.entrySet()) {
                if (i > 0) {
                    sb.append("<br/>");
                }
                if (i == 5) {
                    text = sb.toString() + "...</html>";
                }
                sb.append(init.getKey()).append(" := ").append(init.getValue());
                ++i;
            }
            sb.append("</html>");
            if (text == null) {
                text = sb.toString();
            }
            this.setText(text);
            this.setToolTipText(sb.toString());
        }
        final int height = cfg.getHeigth() * table.getRowHeight();
        if (height != table.getRowHeight(row)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.setRowHeight(row, height);
                }
            });
        }
        return this;
    }
}

