/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class AltaTypeEnum
extends AltaTypeAbstract {
    private List<String> _values;
    private String _define;

    public static String convertInEnumType(String value) {
        String returnValue = new String("");
        char[] arrayValue = value.toCharArray();
        block6: for (int i = 0; i < value.length(); ++i) {
            switch (arrayValue[i]) {
                case ' ': 
                case '{': 
                case '}': {
                    continue block6;
                }
                case ',': {
                    if (returnValue.equals("") || returnValue.toCharArray()[returnValue.length() - 1] == ',' || i == value.length() - 1) continue block6;
                    returnValue = returnValue.concat("" + arrayValue[i]);
                    continue block6;
                }
                default: {
                    if (Character.isLetterOrDigit(arrayValue[i]) || arrayValue[i] == '_') {
                        returnValue = returnValue.concat("" + arrayValue[i]);
                        continue block6;
                    }
                    return null;
                }
            }
        }
        if (returnValue.toCharArray()[returnValue.length() - 1] == ',') {
            returnValue = returnValue.substring(0, returnValue.length() - 1);
        }
        StringTokenizer stoken = new StringTokenizer(returnValue, ",");
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            try {
                Integer.parseInt(token);
                return null;
            }
            catch (NumberFormatException ex) {
                if (UtilOcas.controlName(token) == null) continue;
                return null;
            }
        }
        return returnValue;
    }

    public static List<String> convertInValues(String value) {
        ArrayList<String> values = new ArrayList<String>();
        int position = value.indexOf("{");
        if (position != -1) {
            value = value.substring(position + 1, value.length() - 1);
            StringTokenizer token = new StringTokenizer(value, ",");
            while (token.hasMoreTokens()) {
                value = token.nextToken();
                values.add(value);
            }
        }
        return values;
    }

    public static String toDefine(Collection<String> values) {
        StringBuilder out = new StringBuilder();
        out.append("{");
        if (!values.isEmpty()) {
            Iterator<String> iter = values.iterator();
            while (true) {
                out.append(iter.next());
                if (!iter.hasNext()) break;
                out.append(",");
            }
        }
        out.append("}");
        return out.toString();
    }

    public AltaTypeEnum(String define) {
        this._define = define;
        this._values = AltaTypeEnum.convertInValues(define);
    }

    @Override
    public boolean equivalents(AltaType type) {
        if (type == null) {
            return false;
        }
        if (type == this) {
            return true;
        }
        int size = this._values.size();
        if (type.getValueCount() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            String elt = type.getValueAt(i);
            if (this._values.contains(elt)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this._define;
    }

    @Override
    public AltaTypeEnum getCopy() {
        return new AltaTypeEnum(this._define);
    }

    @Override
    public String getValue() {
        return this._define;
    }

    @Override
    public String getDefaultValue() {
        return this._values.get(0);
    }

    @Override
    public int getValueCount() {
        return this._values.size();
    }

    @Override
    public String getValueAt(int index) {
        return this._values.get(index);
    }

    @Override
    public boolean valueExist(String value) {
        return this._values.contains(value);
    }

    @Override
    public int getValueIndex(Object value) {
        return this._values.indexOf(value);
    }

    public void setValues(Collection<String> enumValues) {
        this._values.clear();
        this._values.addAll(enumValues);
        this._define = AltaTypeEnum.toDefine(enumValues);
    }
}

