/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public abstract class DBType
extends DBWrap
implements AltaType {
    protected static Logger _LOG = Logger.getLogger(DBType.class.getPackage().getName());

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBType(DBFolder dbFolder) {
        super(dbFolder);
    }

    @Override
    public String toLabel() {
        return this._dbFolder.getRefPath();
    }

    public String toString() {
        return this._dbFolder.getRefPath();
    }

    @Override
    public abstract DBType getCopy();

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.TYPE;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("OCAS".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            byte[] ibyte = DAOObjModel.convertFromCompressedByte(istream);
            if (ibyte == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_UNZIP"));
                return false;
            }
            try {
                String buffer = null;
                String encoding = model.getEncoding();
                if (encoding != null && !encoding.isEmpty()) {
                    if (encoding.equals("ISO-8859-1")) {
                        buffer = new String(ibyte, DBObjModel.getOcasCharset());
                    } else if (encoding.equals("UTF-8")) {
                        buffer = new String(ibyte, StandardCharsets.UTF_8);
                    }
                }
                if (buffer == null) {
                    buffer = new String(ibyte);
                }
                this.readFromFile(buffer, cecFactory, logMng);
                return true;
            }
            catch (IOException e) {
                _LOG.log(Level.WARNING, this._dbFolder.getPathUntilSystem(new StringBuilder("Format de donnees incompatible").append(" : ")).toString(), e);
            }
        } else if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            try {
                if ("ZML".equals(format)) {
                    istream = new InflaterInputStream(istream, new Inflater());
                }
                this.readXml(istream, this.createXMLHandler(cecFactory, logMng));
                return true;
            }
            catch (IOException e) {
                _LOG.log(Level.WARNING, this._dbFolder.getPathUntilSystem(new StringBuilder("Format de donnees incompatible").append(" : ")).toString(), e);
            }
        } else {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
            return false;
        }
        return false;
    }

    public void readFromFile(String input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) throws IOException {
        throw new IOException("Not implementated");
    }

    protected SAXExtendedHandler createXMLHandler(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        throw new NullPointerException("Not implementated");
    }

    @Override
    public void writeAltaRicaFlow(Appendable out, String name, AltaFlow.Orientation orientation, boolean expandLink) throws IOException {
        out.append("  ").append(name).append(" : ");
        StringBuilder dbPath = new StringBuilder(64);
        this._dbFolder.getParent().getPathUntilSystem(dbPath);
        out.append(dbPath.substring(1).replace('/', '_'));
        if (orientation != null) {
            out.append(" : ").append(orientation.toAltarica());
        }
        out.append(";\n");
    }

    public void writeAltaRicaDefine(Appendable out) throws IOException {
        out.append("domain ");
        StringBuilder dbPath = new StringBuilder(64);
        this._dbFolder.getParent().getPathUntilSystem(dbPath);
        out.append(dbPath.substring(1).replace('/', '_'));
        out.append(" = ");
    }
}

