/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class DBLinkReaderRaw {
    protected DBFolder _dbFolder;
    DBLogs.DBLogsManager _logManager;
    AltaFileHeader _properties = null;
    DBRecord.LinkType _type;
    List<DBRecordField> _fields;

    public DBLinkReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        this._dbFolder = dbFolder;
        this._logManager = logMng;
        this._fields = new ArrayList<DBRecordField>();
    }

    public AltaFileHeader getProperties() {
        return this._properties;
    }

    public DBRecord.LinkType getType() {
        return this._type;
    }

    public List<DBRecordField> getFields() {
        return this._fields;
    }

    private void addValue(DBRecordField field) {
        for (int i = 0; i < this._fields.size(); ++i) {
            if (!this._fields.get(i).getName().equals(field.getName())) continue;
            this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_XML_TYPE_LINK_FIELD_ALREADY", field.getName()));
            return;
        }
        this._fields.add(field);
    }

    public boolean readRaw(String data, CECFactory cecFactory) throws IOException {
        String line;
        BufferedReader inData = new BufferedReader(new StringReader(data));
        boolean find = false;
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if (line.indexOf("<header") != -1) {
                this._properties = AltaFileHeader.loadFromFile(inData);
            }
            if ((position = (line = line.substring(position + 1)).indexOf(" ")) != -1) {
                String name;
                String field = line.substring(0, position);
                if (!find) {
                    if (!field.equals("type")) continue;
                    name = "";
                    String typeLink = "";
                    if ((position = (line = line.substring(position)).indexOf("name=")) != -1) {
                        field = line.substring(position);
                        name = CoreUtil.searchString(field);
                    }
                    if ((position = line.indexOf("link=")) != -1) {
                        field = line.substring(position);
                        typeLink = CoreUtil.searchString(field);
                    }
                    if (name.equals("")) continue;
                    if (!typeLink.equals("")) {
                        int id = Integer.parseInt(typeLink);
                        this._type = DBRecord.LinkType.get(id);
                    }
                    find = true;
                    continue;
                }
                if (!field.equals("field")) continue;
                name = "";
                String type = "";
                DBRecordField.Direction direction = null;
                String crossField = "";
                position = line.indexOf("name=");
                if (position != -1) {
                    field = line.substring(position);
                    name = CoreUtil.searchString(field);
                }
                if ((position = line.indexOf("type=")) != -1) {
                    field = line.substring(position);
                    type = CoreUtil.searchString(field);
                }
                if ((position = line.indexOf("direction=")) != -1) {
                    field = line.substring(position);
                    direction = DBRecordField.Direction.valueOf(CoreUtil.searchString(field).toUpperCase());
                }
                if ((position = line.indexOf("cross=")) != -1) {
                    field = line.substring(position);
                    crossField = CoreUtil.searchString(field);
                }
                if ((position = line.indexOf("idExternLaetitia=")) != -1) {
                    field = line.substring(position);
                    CoreUtil.searchString(field);
                }
                if (name.equals("") || type.equals("")) continue;
                AltaType typeField = AltaTypeParser.getType(type, cecFactory);
                if (typeField == null) {
                    this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_TYPE_FIELD", name, type));
                    typeField = AltaTypeBool.getInstance();
                }
                DBRecordField altaField = new DBRecordField(name, typeField);
                this.addValue(altaField);
                if (direction != null) {
                    altaField.setDirection(direction);
                }
                if (crossField.equals("")) continue;
                altaField.setCrossField(crossField);
                continue;
            }
            if (line.indexOf("/type") != 0) continue;
            break;
        }
        return true;
    }
}

