/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.modellaw.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.list.ArrayListModel;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.gui.LawPanel;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DBModelLawFrameEdit
extends DBWrapFrameEdit {
    private static final Logger _LOG = Logger.getLogger(DBModelLawFrameEdit.class.getPackage().getName());
    JComboBox _ctrlApplication;
    JComboBox _ctrlAuthor;
    JComboBox _ctrlSubstantiation;
    LawPanel _ctrlLaw;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_EVENTS_MODEL");
    }

    @Override
    public DBModelLaw getDBWrap() {
        return (DBModelLaw)super.getDBWrap();
    }

    public DBModelLawFrameEdit(DBModelLaw dbEvent, CeciliaAppl appl) {
        super(dbEvent.getCopy(), appl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.pack();
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._ctrlLaw.isModified();
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        this._ctrlLaw.setModified(value);
    }

    @Override
    public boolean verifyData() {
        if (this._ctrlApplication.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("MSG_ERR_VALUE_SELECT_FIELD", ResMsgVoc.getString("VOC_APPLICATION")), ResMsgVoc.getString("VOC_ERROR"), 0);
            this._ctrlApplication.requestFocus();
            return false;
        }
        if (this._ctrlAuthor.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("MSG_ERR_VALUE_SELECT_FIELD", ResMsgVoc.getString("VOC_AUTHOR")), ResMsgVoc.getString("VOC_ERROR"), 0);
            this._ctrlAuthor.requestFocus();
            return false;
        }
        if (!this._ctrlLaw.validateParams(null)) {
            return false;
        }
        if (!this.verifyDescription()) {
            return false;
        }
        return super.verifyData();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        this.getDBWrap().setApplication((DBFolder)this._ctrlApplication.getSelectedItem());
        this.getDBWrap().setAuthor((DBFolder)this._ctrlAuthor.getSelectedItem());
        DBFolder dbSubst = (DBFolder)this._ctrlSubstantiation.getSelectedItem();
        if (dbSubst == null || dbSubst.getID() == -1L) {
            this.getDBWrap().setSubstantiation(null);
        } else {
            this.getDBWrap().setSubstantiation(dbSubst);
        }
        this.getDBWrap().setLaw(this._ctrlLaw.getLaw());
        if (!this.doSave()) {
            return false;
        }
        this._ctrlPath.setText(this.getDBFolder().getRefPath());
        this._ctrlName.setText(this.getDBFolder().getParent().getName());
        return true;
    }

    @Override
    protected void refreshControl() {
        super.refreshControl();
        this._ctrlApplication.setSelectedItem(this.getDBWrap().getApplication());
        this._ctrlAuthor.setSelectedItem(this.getDBWrap().getAuthor());
        this._ctrlSubstantiation.setSelectedItem(this.getDBWrap().getSubstantiation());
        this._ctrlLaw.setLaw(this.getDBWrap().getLaw());
    }

    private Component createCenterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createTitlePanel(this.createDefinitionCtrl(), ResMsgVoc.getString("VOC_DEFINITION")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createDescriptionCtrl(), ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createLawCtrl(), ResMsgVoc.getString("VOC_LAW")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return result;
    }

    private ComboBoxModel createListModel(String rootKey, boolean bDelItem) {
        ArrayListModel<DBFolder> model = new ArrayListModel<DBFolder>();
        List<DBFolder> list = null;
        DAOFolder daoFolder = this.getApplication().getDAOFactory().createFolderDAO();
        DBFolder dbRoot = daoFolder.getRootID(rootKey);
        if (dbRoot != null && (list = dbRoot.getChildren()) == null) {
            list = daoFolder.findChildren(dbRoot);
        }
        if (list == null) {
            _LOG.severe("Pas de noeud enfant trouv\u00e9 pour la racine : " + rootKey);
            list = new ArrayList<DBFolder>();
        }
        if (bDelItem) {
            ArrayList<DBFolder> tmp = new ArrayList<DBFolder>(list.size() + 2);
            tmp.add(new DBFolder(-1L).setName("     "));
            tmp.addAll(list);
            list = tmp;
        }
        model.setList(list);
        return model;
    }

    private Collection<DBRelation> getWorkingRelation() {
        Law law;
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        DBFolder srcFolder = this.getDBFolder();
        String srcType = "WORKING";
        DBFolder dbFolder = null;
        dbFolder = (DBFolder)this._ctrlApplication.getSelectedItem();
        if (dbFolder != null) {
            relations.add(new DBRelation(srcFolder, srcType, dbFolder, "FRB_APPL"));
        }
        if ((dbFolder = (DBFolder)this._ctrlAuthor.getSelectedItem()) != null) {
            relations.add(new DBRelation(srcFolder, srcType, dbFolder, "FRB_AUTHOR"));
        }
        if ((dbFolder = (DBFolder)this._ctrlSubstantiation.getSelectedItem()) != null && dbFolder.getID() != -1L) {
            relations.add(new DBRelation(srcFolder, srcType, dbFolder, "FRB_SUBST"));
        }
        if ((law = this._ctrlLaw.getLaw()) != null) {
            law.addRelation(srcFolder, srcType, relations);
        }
        return relations;
    }

    private JComboBox createComboBox(ComboBoxModel model) {
        JComboBox result = new JComboBox(model);
        result.setEditable(false);
        result.setRenderer(new FolderRenderer().setDisplayIcon(false).setDisplayPath(false));
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBModelLawFrameEdit.this.setModified(true);
                DBModelLawFrameEdit.this.getDBWrap().updateDependTimeUpdt(DBModelLawFrameEdit.this.getApplication().getDAOFactory(), DBModelLawFrameEdit.this.getWorkingRelation());
            }
        });
        return result;
    }

    private Component createDefinitionCtrl() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlApplication = this.createComboBox(this.createListModel("BTP_APPLICATIONS", false));
        this._ctrlAuthor = this.createComboBox(this.createListModel("BTP_AUTHORS", false));
        this._ctrlSubstantiation = this.createComboBox(this.createListModel("BTP_SUBSTANTIATIONS", true));
        int posY = 0;
        result.add(this.createPathCtrl(true), new GridBagConstraints(0, posY, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_APPLICATION")), new GridBagConstraints(0, ++posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        result.add((Component)this._ctrlApplication, new GridBagConstraints(1, posY, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_AUTHOR")), new GridBagConstraints(0, ++posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        result.add((Component)this._ctrlAuthor, new GridBagConstraints(1, posY, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        result.add((Component)new JLabel(ResMsgVoc.getString("VOC_SUBSTANTIATION")), new GridBagConstraints(2, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        result.add((Component)this._ctrlSubstantiation, new GridBagConstraints(3, posY, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return result;
    }

    @Override
    protected Component createDescriptionCtrl() {
        if (this._ctrlDescription == null) {
            this._ctrlDescription = new JTextArea(5, 40);
        }
        return super.createDescriptionCtrl();
    }

    private Component createLawCtrl() {
        CECFactory cecFactory = this.getApplication().getDAOFactory();
        this._ctrlLaw = new LawPanel(cecFactory.getLawManager(), this.getApplication());
        this._ctrlLaw.setPreferredSize(new Dimension(200, 150));
        this._ctrlLaw.addDependsListener(new DependsListener(){

            @Override
            public void changeDepends() {
                DBModelLawFrameEdit.this.getDBWrap().updateDependTimeUpdt(DBModelLawFrameEdit.this.getApplication().getDAOFactory(), DBModelLawFrameEdit.this.getWorkingRelation());
            }
        });
        return this._ctrlLaw;
    }
}

