/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project;

import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import java.io.IOException;

public class CriticityCriterion {
    String _name = "";
    double _probability = 0.0;
    int _order = 0;
    double _lsr_latent = Double.NaN;
    double _lsr_evident = Double.NaN;

    public CriticityCriterion getCopy() {
        CriticityCriterion dest = new CriticityCriterion().setName(this._name);
        dest.setProbability(this._probability).setOrder(this._order);
        dest.setLSRLatent(this._lsr_latent).setLSREvident(this._lsr_evident);
        return dest;
    }

    public String getName() {
        return this._name;
    }

    public CriticityCriterion setName(String value) {
        this._name = value;
        return this;
    }

    public double getProbability() {
        return this._probability;
    }

    public CriticityCriterion setProbability(double value) {
        this._probability = value;
        return this;
    }

    public int getOrder() {
        return this._order;
    }

    public CriticityCriterion setOrder(int value) {
        this._order = value;
        return this;
    }

    public double getLSRLatent() {
        return this._lsr_latent;
    }

    public CriticityCriterion setLSRLatent(double value) {
        this._lsr_latent = value;
        return this;
    }

    public double getLSREvident() {
        return this._lsr_evident;
    }

    public CriticityCriterion setLSREvident(double value) {
        this._lsr_evident = value;
        return this;
    }

    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.params.criticities.compute.item");
        DBObjectXmlUtility.appendXML(out.append(" name='"), this._name).append("'");
        out.append(" probability='").append(Double.toString(this._probability)).append("'");
        out.append(" order='").append(Integer.toString(this._order)).append("'");
        if (!Double.isNaN(this._lsr_latent)) {
            out.append(" latent='").append(Double.toString(this._lsr_latent)).append("'");
        }
        if (!Double.isNaN(this._lsr_evident)) {
            out.append(" evident='").append(Double.toString(this._lsr_evident)).append("'");
        }
        out.append("/>\n");
    }
}

