/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.ParamHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.io.DBProjectXmlConstants;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBProjectHandlerXml
extends SAXWrapHandler
implements DBProjectXmlConstants {
    CECFactory _cecFactory;
    Map<DBAttrib, AverageAttributeDriver> _avgAttributeDrivers;
    Map<String, CriticityCriterion> _criticityCriterium;
    boolean _bReadAverage;
    DBAttrib _currentAttribute;
    List<AverageAttributeCriterion> _currentCriteriums;
    DBProjectAACHandlerXML _childAAC;
    boolean _bReadCriticity;

    public Collection<AverageAttributeDriver> getAAD() {
        return this._avgAttributeDrivers.values();
    }

    public Collection<CriticityCriterion> getCC() {
        return this._criticityCriterium.values();
    }

    public DBProjectHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, CECFactory cecFactory) {
        super(logMng, locator);
        this._cecFactory = cecFactory;
        this._bReadCriticity = false;
        this._bReadAverage = false;
        this._currentAttribute = null;
        this._currentCriteriums = null;
        this._avgAttributeDrivers = new LinkedHashMap<DBAttrib, AverageAttributeDriver>();
        this._criticityCriterium = new LinkedHashMap<String, CriticityCriterion>();
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!"cec.project".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.project"), this.getLocator()));
            }
        } else if (this._childAAC != null) {
            this._childAAC.startAction(key, attrs, startAction);
        } else if ("cec.params.average.compute".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "ATTRIBUTES", false);
            this._bReadAverage = true;
            this._currentAttribute = null;
            if (dbFolder != null) {
                if (dbFolder.getFamily() != DBFolder.Family.ATTRIBUTE) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"cec.params.average.compute", DBFolder.Family.ATTRIBUTE}), this.getLocator()));
                } else {
                    DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                    if (dbWrap != null) {
                        if (dbWrap instanceof DBAttrib) {
                            this._currentAttribute = (DBAttrib)dbWrap;
                        } else {
                            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"cec.params.average.compute", DBFolder.Family.ATTRIBUTE}), this.getLocator()));
                        }
                        if (this._avgAttributeDrivers.get(this._currentAttribute) != null) {
                            this.getLogManager().addLog(DBLogs.DBLevel.WARNING, "Il y a d\u00e9j\u00e0 une matrice des risques moyens avec cet attribut: " + this._currentAttribute.getRefPath());
                        }
                        this._currentCriteriums = new ArrayList<AverageAttributeCriterion>();
                    }
                }
            }
        } else if ("cec.params.average.compute.item".equals(key)) {
            if (!this._bReadAverage) {
                this.errorElementUnknown(key);
            } else if (this._currentAttribute != null) {
                this._childAAC = new DBProjectAACHandlerXML(this.getLogManager(), this.getLocator(), this._cecFactory, this._cecFactory.getLawManager().getParameterManager());
                this._childAAC.startAction(key, attrs, true);
            }
        } else if ("cec.params.criticities.compute".equals(key)) {
            this._bReadCriticity = true;
        } else if ("cec.params.criticities.compute.item".equals(key)) {
            if (!this._bReadCriticity) {
                this.errorElementUnknown(key);
            } else {
                String name = this.readName(key, "name", attrs);
                double proba = this.readDouble(key, "probability", attrs, false, 0.0);
                int order = this.readPositiveInteger(key, "order", attrs, false, 0);
                double latent = this.readDouble(key, "latent", attrs, true, Double.NaN);
                double evident = this.readDouble(key, "evident", attrs, true, Double.NaN);
                CriticityCriterion cc = new CriticityCriterion().setName(name);
                cc.setProbability(proba).setOrder(order).setLSREvident(evident).setLSRLatent(latent);
                if (this._criticityCriterium.put(name, cc) != null) {
                    this.getLogManager().addLog(DBLogs.DBLevel.WARNING, "Il y a d\u00e9j\u00e0 une criticity de nom: " + name);
                }
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childAAC != null) {
            boolean result = this._childAAC.endAction(key, attrs, txt);
            if (result) {
                AverageAttributeCriterion.ProbabilityChoice choice = null;
                String attr = attrs.get("choice");
                if (attr == null || attr.isEmpty()) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "choice"), this.getLocator()));
                }
                if ((choice = (AverageAttributeCriterion.ProbabilityChoice)DBProjectHandlerXml.valueOfEnum(AverageAttributeCriterion.ProbabilityChoice.class, (String)attr.toUpperCase())) == null) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "choice", attr), this.getLocator()));
                }
                AttrCriterion criterion = null;
                AttrCriterion.Operator op = null;
                String attr2 = attrs.get("op");
                if (attr2 == null || attr2.isEmpty()) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "op"), this.getLocator()));
                }
                if ((op = (AttrCriterion.Operator)DBProjectHandlerXml.valueOfEnum(AttrCriterion.Operator.class, (String)attr2.toUpperCase())) == null) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "op", attr2), this.getLocator()));
                }
                String data = null;
                data = attrs.get("data");
                if (data == null || data.isEmpty()) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "data"), this.getLocator()));
                }
                criterion = new AttrCriterion(this._currentAttribute, op, data);
                AverageAttributeCriterion aac = new AverageAttributeCriterion(criterion, choice, this._childAAC._param);
                this._currentCriteriums.add(aac);
                this._childAAC = null;
            }
            return false;
        }
        if ("cec.params.average.compute".equals(key)) {
            this._bReadAverage = false;
            this._avgAttributeDrivers.put(this._currentAttribute, new AverageAttributeDriver(this._currentAttribute, this._currentCriteriums));
            this._currentAttribute = null;
            this._currentCriteriums = null;
        } else if ("cec.params.criticities.compute".equals(key)) {
            this._bReadCriticity = false;
        }
        return "cec.project".equals(key);
    }

    class DBProjectAACHandlerXML
    extends ParamHandlerXml
    implements DBProjectXmlConstants {
        Param _param;

        protected DBProjectAACHandlerXML(DBLogs.DBLogsManager logMng, Locator locator, CECFactory cecFactory, LawManager lawManager) {
            super(logMng, locator, cecFactory, lawManager);
        }

        @Override
        public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
            if (!startAction) {
                super.startAction(key, attrs, startAction);
            }
        }

        public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
            if (this._childHandler != null) {
                boolean result = this._childHandler.endAction(key, attrs, txt);
                if (result) {
                    this.manageChildEndAction(key);
                    this._childHandler = null;
                }
                return false;
            }
            return "cec.params.average.compute.item".equals(key);
        }

        @Override
        protected TypeParam getCurrentType() {
            return TypeParam.DELAY;
        }

        @Override
        protected void manageCreateParam(Param param) {
            this._param = param;
        }

        @Override
        protected Param createDefaultParam() {
            return null;
        }

        @Override
        protected String getOwnerObject() {
            return DBProjectHandlerXml.this._currentAttribute.getRefPath();
        }
    }
}

