/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict;

import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareDiffText;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import java.util.List;

public interface CompareResult {
    public static final int IDX_DATA1 = 0;
    public static final int IDX_DATA2 = 1;

    public String getName();

    public String getCategory();

    public boolean withDiff();

    public String getData(int var1);

    public String getResultInfo();

    public boolean isObjectPresent(int var1);

    default public String getResultDetailled(int idx) {
        return this.getData(idx);
    }

    default public List<CompareDiffText.Diff> initListDiff() {
        String data1 = this.getData(0);
        String data2 = this.getData(1);
        return CompareDiffText.startDiff(data1, data2);
    }

    default public String getResultDetailledForText(int idx) {
        List<CompareDiffText.Diff> diffs = this.getListDiff();
        if (diffs == null) {
            String txt = this.getResultDetailled(idx);
            return txt != null ? CompareUtils.convertToHtmlText(txt) : txt;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (CompareDiffText.Diff diff : diffs) {
            switch (diff.getType()) {
                case EQUALS: {
                    sb.append(CompareUtils.convertToHtmlText(diff.getText()));
                    break;
                }
                case REMOVED: 
                case ADDED: {
                    boolean write;
                    boolean bl = write = idx == 0 && diff.getType() == CompareDiffText.DiffType.REMOVED || idx == 1 && diff.getType() == CompareDiffText.DiffType.ADDED;
                    if (!write) break;
                    sb.append("<b style=\"color:#d50000\">");
                    sb.append(CompareUtils.convertToHtmlText(diff.getText()));
                    sb.append("</b>");
                }
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    public List<CompareDiffText.Diff> getListDiff();
}

