/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class DBComparaisonsPanel
extends JPanel {
    private DBComparaisons _compare;
    private JTree _tree;
    private JPanel _wrapDetailPanel1;
    private JPanel _wrapDetailPanel2;
    private ComparisonType _displayMode = ComparisonType.ALL;
    public static int PRIO_MAX = 3;
    public static int PRIO_MISSING_OTHER = PRIO_MAX - 1;
    public static int PRIO_IDENTICAL = PRIO_MISSING_OTHER - 1;

    private DBComparaisonsPanel() {
        super(new GridBagLayout());
        this.make();
    }

    public void setComparisons(DBComparaisons compare, String nameWrap1, String nameWrap2) {
        this._wrapDetailPanel1.setBorder(BorderFactory.createTitledBorder(nameWrap1));
        this._wrapDetailPanel2.setBorder(BorderFactory.createTitledBorder(nameWrap2));
        this._compare = compare;
        this._tree.setModel(DBComparaisonsPanel.constructConflictTreeModel(this._compare, this._displayMode));
        if (this._tree.getRowCount() > 0) {
            this._tree.setSelectionRow(1);
        } else {
            this._tree.setSelectionRow(0);
        }
    }

    private void make() {
        JComboBox<ComparisonType> filterCB = new JComboBox<ComparisonType>(ComparisonType.values());
        filterCB.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isObjSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isObjSelected, cellHasFocus);
                if (!(value instanceof ComparisonType)) {
                    return this;
                }
                ComparisonType mode = (ComparisonType)((Object)value);
                this.setText(mode.getDisplayRessource());
                this.setForeground(mode.getColor());
                return this;
            }
        });
        this._tree = new JTree(new DefaultTreeModel(null));
        this._tree.setCellRenderer(new ConflictTreeRenderer());
        this._tree.getSelectionModel().setSelectionMode(1);
        this._wrapDetailPanel1 = new JPanel(new BorderLayout());
        this._wrapDetailPanel1.setPreferredSize(new Dimension(100, 250));
        JTextPane wrapDetail1 = new JTextPane();
        wrapDetail1.setContentType("text/html");
        wrapDetail1.setEditable(false);
        this._wrapDetailPanel1.add(new JScrollPane(wrapDetail1));
        this._wrapDetailPanel2 = new JPanel(new BorderLayout());
        this._wrapDetailPanel2.setPreferredSize(new Dimension(100, 250));
        JTextPane wrapDetail2 = new JTextPane();
        wrapDetail2.setContentType("text/html");
        wrapDetail2.setEditable(false);
        this._wrapDetailPanel2.add(new JScrollPane(wrapDetail2));
        this._tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
            this.setDiffsOnTextArea(node, wrapDetail1, wrapDetail2);
        });
        filterCB.addActionListener(e -> {
            ComparisonType selectedMode = (ComparisonType)((Object)((Object)filterCB.getSelectedItem()));
            if (this._displayMode == selectedMode) {
                return;
            }
            this._displayMode = selectedMode;
            wrapDetail1.setText("");
            wrapDetail2.setText("");
            this._tree.setModel(DBComparaisonsPanel.constructConflictTreeModel(this._compare, this._displayMode));
        });
        JPanel wrapsPanel = new JPanel(new GridLayout(1, 2));
        wrapsPanel.add(this._wrapDetailPanel1);
        wrapsPanel.add(this._wrapDetailPanel2);
        JScrollPane jsPane = new JScrollPane(this._tree);
        jsPane.setPreferredSize(new Dimension(600, 150));
        JSplitPane pane = new JSplitPane(0, jsPane, wrapsPanel);
        pane.setResizeWeight(0.6);
        int y = 0;
        this.add(filterCB, new GridBagConstraints(0, y++, 1, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)pane, new GridBagConstraints(0, y++, 1, 1, 100.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setDiffsOnTextArea(DefaultMutableTreeNode node, JTextPane wrapDetail1, JTextPane wrapDetail2) {
        Object userObj;
        CompareResult result = null;
        if (node != null && (userObj = node.getUserObject()) instanceof CompareResult) {
            result = (CompareResult)userObj;
        }
        String txt1 = "";
        if (result != null) {
            txt1 = result.getResultDetailledForText(0);
        }
        wrapDetail1.setText(txt1);
        String txt2 = "";
        if (result != null) {
            txt2 = result.getResultDetailledForText(1);
        }
        wrapDetail2.setText(txt2);
    }

    public static final DefaultTreeModel constructConflictTreeModel(DBComparaisons comparaisons, ComparisonType displayMode) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(ResMsgVoc.getString("VOC_COMPARISON"));
        HashMap<String, DefaultMutableTreeNode> intermediatesNodes = new HashMap<String, DefaultMutableTreeNode>();
        for (int i = 0; i < comparaisons.getNbrConflicts(); ++i) {
            DefaultMutableTreeNode parent;
            CompareResult rslt = comparaisons.getConflictAt(i);
            String category = rslt.getCategory();
            boolean withDiff = rslt.withDiff();
            boolean included = false;
            switch (displayMode) {
                case ALL: {
                    included = true;
                    break;
                }
                case DIFFERENCE: {
                    included = withDiff;
                    break;
                }
                case IDENTICAL: {
                    included = !withDiff;
                    break;
                }
                case ONLY_LEFT: {
                    included = withDiff && !rslt.isObjectPresent(1);
                    break;
                }
                case ONLY_RIGHT: {
                    boolean bl = included = withDiff && !rslt.isObjectPresent(0);
                }
            }
            if (!included) continue;
            if (category == null) {
                parent = root;
            } else if (!intermediatesNodes.containsKey(category)) {
                parent = new DefaultMutableTreeNode(category);
                intermediatesNodes.put(category, parent);
            } else {
                parent = (DefaultMutableTreeNode)intermediatesNodes.get(category);
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(rslt);
            parent.add(node);
            node.setParent(parent);
        }
        for (DefaultMutableTreeNode node : intermediatesNodes.values()) {
            root.add(node);
            node.setParent(root);
        }
        return new DefaultTreeModel(root);
    }

    protected static String getTitle(String nameWrap1, String nameWrap2) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResMsgVoc.getString("VOC_COMPARISON"));
        sb.append(" - ");
        sb.append(nameWrap1);
        sb.append("/");
        sb.append(nameWrap2);
        return sb.toString();
    }

    public static class DBComparaisonsDlg
    extends JDialogCecilia {
        private DBComparaisonsPanel _panel;

        public DBComparaisonsDlg(Window window) {
            super(window, true);
            this.setIconImage(ResIcoCore.getImageIcon("COMPARISON_FRAME").getImage());
            this._panel = new DBComparaisonsPanel();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this._panel, "Center");
            this.getContentPane().add((Component)this.createButPanelClose(), "South");
            this.init();
            this.pack();
            this.setLocationRelativeTo(window);
        }

        public void setComparisons(DBComparaisons compare, String nameWrap1, String nameWrap2) {
            this.setTitle(DBComparaisonsPanel.getTitle(nameWrap1, nameWrap2));
            this._panel.setComparisons(compare, nameWrap1, nameWrap2);
        }
    }

    public static class DBComparaisonsFrame
    extends CInternalFrame {
        private DBComparaisonsPanel _panel;

        public DBComparaisonsFrame() {
            super(ResIcoCore.getImageIcon("COMPARISON_FRAME"), "");
            this.setFrameIcon(ResIcoCore.getImageIcon("COMPARISON_FRAME"));
            this._panel = new DBComparaisonsPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)this._panel, "Center");
            this.pack();
        }

        public void setComparisons(DBComparaisons compare, String nameWrap1, String nameWrap2) {
            this.setTitle(DBComparaisonsPanel.getTitle(nameWrap1, nameWrap2));
            this._panel.setComparisons(compare, nameWrap1, nameWrap2);
        }
    }

    private static final class ConflictTreeRenderer
    extends DefaultTreeCellRenderer {
        private ConflictTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocusRdr) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, this.hasFocus);
            if (value == null) {
                return this;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.isRoot()) {
                this.setIcon(null);
                return this;
            }
            Object userObj = node.getUserObject();
            if (userObj instanceof String) {
                ComparisonType typeFolder = ComparisonType.IDENTICAL;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    CompareResult rsltChild = (CompareResult)child.getUserObject();
                    ComparisonType type = ComparisonType.getComparisonType(rsltChild);
                    if (type.getPrio() == PRIO_MAX) {
                        typeFolder = type;
                        break;
                    }
                    if (type.getPrio() == PRIO_MISSING_OTHER) {
                        if (typeFolder.getPrio() == PRIO_MISSING_OTHER && type != typeFolder) {
                            typeFolder = ComparisonType.DIFFERENCE;
                            break;
                        }
                        typeFolder = type;
                        continue;
                    }
                    typeFolder = type;
                }
                this.setForeground(typeFolder.getColor());
            } else if (userObj instanceof CompareResult) {
                CompareResult result = (CompareResult)userObj;
                this.setText(result.getName());
                this.setIcon(null);
                this.setForeground(ComparisonType.getComparisonType(result).getColor());
            }
            return this;
        }
    }

    private static enum ComparisonType {
        ALL("DLG_COMPARISONS_DISPLAY_ALL", Color.BLACK, 0),
        DIFFERENCE("DLG_COMPARISONS_DISPLAY_ONLY_ERRORS", Color.RED, PRIO_MAX),
        IDENTICAL("DLG_COMPARISONS_DISPLAY_ONLY_IDENTICAL", Color.GREEN, PRIO_IDENTICAL),
        ONLY_LEFT("DLG_COMPARISONS_DISPLAY_ONLY_LEFT", Color.BLUE, PRIO_MISSING_OTHER),
        ONLY_RIGHT("DLG_COMPARISONS_DISPLAY_ONLY_RIGHT", Color.GRAY, PRIO_MISSING_OTHER);

        private final String _ress;
        private Color _color;
        private final int _prio;

        private ComparisonType(String keyRess, Color color, int prio) {
            this._ress = ResMsgObj.getString(keyRess);
            this._color = color;
            this._prio = prio;
        }

        public String getDisplayRessource() {
            return this._ress;
        }

        public Color getColor() {
            return this._color;
        }

        public int getPrio() {
            return this._prio;
        }

        public static ComparisonType getComparisonType(CompareResult result) {
            boolean withDiff = result.withDiff();
            if (withDiff && !result.isObjectPresent(1)) {
                return ONLY_LEFT;
            }
            if (withDiff && !result.isObjectPresent(0)) {
                return ONLY_RIGHT;
            }
            if (withDiff) {
                return DIFFERENCE;
            }
            return IDENTICAL;
        }
    }
}

