/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CCmdFolder;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DBWrapCmdSaveAs
extends CCmdFolder {
    private static Logger _LOG = Logger.getLogger(DBWrapCmdSaveAs.class.getPackage().getName());
    DBInternalFrame _frame;
    DBFolder[] _dbPrepare;
    DBFolder _srcVersionFolder;
    CECFactory _daoFactory;
    DAOFolder _daoFolder;

    public DBWrapCmdSaveAs(CeciliaAppl appl, DBInternalFrame frame, DBFolder[] dbPrepare, DBFolder srcVersionFolder) {
        super(appl, frame, srcVersionFolder);
        this._frame = frame;
        this._dbPrepare = dbPrepare;
        this._srcVersionFolder = srcVersionFolder;
        this._daoFactory = appl.getDAOFactory();
    }

    protected String getTitle() {
        return ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_SAVE_AS");
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected boolean prepareDo() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void firstDo() {
        try {
            this._daoFactory.beginTransaction(true);
            boolean bWithError = false;
            DBFolder dbCreate = null;
            try {
                boolean withModel;
                _LOG.finest("CmdSaveAs-Phase2A: Begin Copy");
                boolean bl = withModel = this._dbPrepare.length == 2;
                if (withModel) {
                    this.doPaste(this._srcVersionFolder.getParent(), this._dbPrepare[0]);
                    this.doPaste(this._srcVersionFolder, this._dbPrepare[1]);
                } else {
                    this.doPaste(this._srcVersionFolder, this._dbPrepare[0]);
                }
                DBFolder folderToCreate = this._dbPrepare[0];
                dbCreate = this._daoFactory.createFolderDAO().create(folderToCreate);
                if (dbCreate == null) {
                    bWithError = true;
                } else {
                    DBFolder dbVersionCreate;
                    if (dbCreate.getChildren() == null && withModel) {
                        this._daoFactory.createFolderDAO().findChildren(dbCreate);
                    }
                    DBFolder dBFolder = dbVersionCreate = withModel ? dbCreate.getChildren().get(0) : dbCreate;
                    if (!this._daoFactory.createObjectDAO().lock(dbVersionCreate.getObject(), this.getAppl().getDBSession())) {
                        bWithError = true;
                    } else {
                        DBFolder oldFolder = this._frame.getDBWrap().getDBFolder();
                        boolean oldEditable = !this._frame.isReadOnly();
                        this._frame.getDBWrap().setFolder(dbVersionCreate);
                        this._frame.setEditable(true);
                        try {
                            if (this._srcVersionFolder.isFreeze()) {
                                DBLogs.Log freezeLog = null;
                                for (DBLogs.Log log : this._frame.getDBWrap().getLogs().getLogs(DBLogs.DBLevel.INFO)) {
                                    if (Math.abs(this._srcVersionFolder.getDateModify().getTime() - log.getCreate().getTime()) > 60000L || !log.getMessage().startsWith("Freeze") && !log.getMessage().startsWith("Fige")) continue;
                                    freezeLog = log;
                                    break;
                                }
                                if (freezeLog != null) {
                                    this._frame.getDBWrap().getLogs().changeLog(freezeLog, DBLogs.DBLevel.FINEST);
                                    Thread.sleep(100L);
                                }
                            }
                            this._frame.getDBWrap().getLogs().addLog(new Date(), this.getAppl().getDBUser().getLogin(), DBLogs.DBLevel.FINEST, ResMsgCore.msgFormat("MSG_LOG_SAVEAS", this._srcVersionFolder.getRefPath()));
                            if (!this._frame.save()) {
                                bWithError = true;
                            } else {
                                OpenFolder oldOpenFolder = this.getAppl().getOpenFolders().getOpenFolder(oldFolder);
                                oldOpenFolder.removeFrame(this._frame);
                                oldOpenFolder.setMasterFrame(null);
                                this.getAppl().getOpenFolders().removeOpenFolder(oldFolder);
                                this.getAppl().getOpenFolders().addOpenFolder(new OpenFolder(dbVersionCreate).setAccess(this._frame));
                                if (oldFolder.getObject().isLocked()) {
                                    DBSession dbSession = oldFolder.getObject().getLockedSession();
                                    if (dbSession != null && dbSession.equals(this.getAppl().getDBSession())) {
                                        this.getAppl().getDAOFactory().createObjectDAO().unlock(oldFolder.getObject(), this.getAppl().getDBSession());
                                    }
                                    this.getAppl().getDAOFactory().createRelationDAO().updateRelations(oldFolder, "WORKING", Collections.EMPTY_LIST);
                                }
                            }
                        }
                        finally {
                            if (bWithError) {
                                this._frame.getDBWrap().setFolder(oldFolder);
                                this._frame.setEditable(oldEditable);
                            }
                        }
                    }
                }
                if (bWithError) {
                    this._daoFactory.abortTransaction();
                } else {
                    this._daoFactory.endTransaction();
                }
                _LOG.finest("CmdSaveAs-Phase2A: End Copy");
            }
            catch (Throwable th) {
                _LOG.log(Level.INFO, "CmdSaveAs-Phase2A (Throwable)", th);
                this._daoFactory.abortTransaction();
                bWithError = true;
            }
            if (bWithError) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._frame), ResMsgObj.msgFormat("MSG_FOL_ERR_CREATE", new Object[0]), this.getTitle(), 0);
            } else {
                dbCreate.setMustBeUpdated(true);
                this.getAppl().refreshDAOFolder(true);
                SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this.getAppl().getTopWindow().getFolders().getTree(dbCreate.getFamily()), dbCreate));
            }
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Realise-SaveAs | Processus de transition", e);
        }
    }

    private void doPaste(DBFolder srcFolder, DBFolder dstFolder) {
        Collection<DBRelation> srcRelations;
        dstFolder.setDescription(srcFolder.getDescription());
        dstFolder.setDateCreate(new Date());
        dstFolder.setDateModify(new Date());
        dstFolder.setFlags(srcFolder.getFlags());
        DBObject srcObject = srcFolder.getObject();
        if (srcObject != null) {
            this.createObject(srcFolder, dstFolder, srcObject, true);
        }
        if ((srcRelations = this._daoFactory.createRelationDAO().getDestinationRelations(srcFolder)).size() > 0) {
            ArrayList<DBRelation> dstRelations = new ArrayList<DBRelation>(srcRelations.size());
            for (DBRelation srcRelation : srcRelations) {
                DBRelation dstRelation = new DBRelation(dstFolder, srcRelation.getTypeSource(), srcRelation.getDestination(), srcRelation.getTypeDestination());
                dstRelations.add(dstRelation);
            }
            dstFolder.setRelations(dstRelations);
        }
    }

    private boolean createObject(DBFolder srcFolder, DBFolder dstFolder, DBObject srcObject, boolean withoutID) {
        boolean result = false;
        DBObject dstObject = new DBObject();
        dstObject.setFlags(srcObject.getFlags());
        dstObject.unsetBinFlag(2);
        for (DBObjProperty srcObjProp : srcObject.getProperties()) {
            DBObjProperty dstObjProp = new DBObjProperty(srcObjProp);
            dstObjProp.setID(-1L);
            dstObject.addProperty(dstObjProp);
        }
        DBObjProperty dbProperty = dstObject.getProperty("object.creator");
        if (dbProperty != null) {
            dbProperty.setValue(this.getAppl().getDBUser().getLogin());
        } else {
            dbProperty = new DBObjProperty().setName("object.creator").setType("String").setValue(this.getAppl().getDBUser().getLogin());
            dstObject.addProperty(dbProperty);
        }
        dbProperty = dstObject.getProperty("object.release");
        if (dbProperty != null) {
            dbProperty.setValue("0");
        } else {
            dbProperty = new DBObjProperty().setName("object.release").setType("Long").setValue("0");
            dstObject.addProperty(dbProperty);
        }
        for (DBObjModel srcObjMod : srcObject.getModels()) {
            String dbFormat = srcObjMod.getFormat();
            if (!withoutID && (dbFormat.equals("XML") || dbFormat.equals("ZML"))) {
                result = true;
                continue;
            }
            DBObjModel dstObjMod = new DBObjModel(srcObjMod);
            dstObjMod.setID(-1L);
            dstObjMod.setStreamToSave(this._daoFactory.createObjModelDAO().getBinaryStream(srcObjMod));
            dstObject.addModel(dstObjMod);
        }
        dstFolder.setObject(dstObject);
        return result;
    }
}

