/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.io.GenerateExport;
import com.dassault.cecilia.io.xml6.PerformExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractCmdExport
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(AbstractCmdExport.class.getPackage().getName());
    protected DBUser _dbUser;
    protected DBFolder _srcFolder;
    protected Collection<DBFolder> _selFolders;

    public AbstractCmdExport(CeciliaAppl appl, Component owner, Collection<DBFolder> selFolders, DBUser user) {
        super((CAppl)appl, owner);
        this._selFolders = selFolders;
        if (this._selFolders.size() > 0) {
            this._srcFolder = this._selFolders.iterator().next();
        }
        this._dbUser = user;
    }

    @Override
    protected String getTitle() {
        return ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_EXPORT");
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    protected boolean recupForExport(DBFolder dbFolder) {
        return true;
    }

    protected void recupAllFolderObject(Collection<DBFolder> folders, Set<DBFolder> recups, Set<DBFolder> treats, DAOFolder daoFolder) {
        for (DBFolder dbFolder : folders) {
            if (treats.contains(dbFolder)) continue;
            treats.add(dbFolder);
            if (!this.recupForExport(dbFolder)) continue;
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            this.recupAllFolderObject(children, recups, treats, daoFolder);
            if (dbFolder.getObject() != null) {
                DBAccess.Right right = daoFolder.getAccessRight(dbFolder, this._dbUser);
                if (right == DBAccess.Right.NONE || right == DBAccess.Right.INTEGRATE) {
                    this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ACCESS_NO", dbFolder.getRefPath()));
                    continue;
                }
                if (!dbFolder.isFreeze() && dbFolder.isLocked()) {
                    DBSession dbSession = dbFolder.getObject().getLockedSession();
                    this.addError(dbFolder, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
                    continue;
                }
                if (!dbFolder.isVersion()) continue;
                recups.add(dbFolder);
                continue;
            }
            if (!dbFolder.isVersion()) continue;
            switch (dbFolder.getFamily()) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    recups.add(dbFolder);
                }
            }
        }
    }

    @Override
    protected boolean prepareDo() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void firstDo() {
        assert (this._selFolders != null && !this._selFolders.isEmpty());
        HashSet<DBFolder> treatsRecup = new HashSet<DBFolder>();
        Set<DBFolder> foldersToExport = new LinkedHashSet<DBFolder>();
        this.recupAllFolderObject(this._selFolders, foldersToExport, treatsRecup, this.getAppl().getDAOFactory().createFolderDAO());
        if (this.withError()) {
            _LOG.finest("CmdExport-Phase1: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(this.getErrors());
            return;
        }
        if (foldersToExport.size() == 0) {
            _LOG.finest("CmdExport-Phase1: Pas de donnees a exporter");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgObj.getString("MSG_EXPORT_EMPTY"), this.getAppl().getTitle(), 1);
            return;
        }
        GenerateExport generate = new GenerateExport(this.getAppl().getDAOFactory(), this._dbUser);
        for (DBFolder dbFolder : foldersToExport) {
            generate.prepare(dbFolder, dbFolder, null);
        }
        if (generate.withError()) {
            _LOG.finest("CmdExport-Phase2: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(generate.getErrors());
            return;
        }
        foldersToExport = generate.getDepends();
        DAOObject daoObject = this.getAppl().getDAOFactory().createObjectDAO();
        DBSession dbSession = this.getAppl().getDBSession();
        ArrayList<DBFolder> foldersLocked = new ArrayList<DBFolder>(foldersToExport.size());
        try {
            DBFolder dbFolderErrorLock = null;
            for (DBFolder dbFolder : foldersToExport) {
                if (dbFolder.getObject() == null || dbFolder.isFreeze()) continue;
                if (daoObject.lock(dbFolder.getObject(), dbSession)) {
                    foldersLocked.add(dbFolder);
                    continue;
                }
                dbFolderErrorLock = dbFolder;
                break;
            }
            if (dbFolderErrorLock != null) {
                this.addError(dbFolderErrorLock, ResMsgCore.getString("MSG_FOL_DONT_LOCK"));
            } else {
                File file;
                JFileChooser dlg = new JFileChooser();
                FileFilter altFilter = this.createFileFilter();
                dlg.addChoosableFileFilter(altFilter);
                dlg.setFileFilter(altFilter);
                dlg.setCurrentDirectory(new File(PlugableUtility.getStrOpt(this.getAppl().getPlugable(), "plugable.option.path", ".")));
                if (dlg.showSaveDialog(this.getAppl().getTopWindow()) == 0 && (file = dlg.getSelectedFile()) != null) {
                    this.getAppl().getPlugable().setOption("plugable.option.path", file.getParent());
                    file = FileFilterExtention.addDefaultExtention(dlg);
                    if (!file.exists() || 0 == JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.msgFormat("FILE_MSG_EXIST_FRM", file), this.getAppl().getTitle(), 0)) {
                        this.doExport(foldersToExport, file);
                    }
                }
            }
        }
        finally {
            for (DBFolder dbFolder : foldersLocked) {
                if (dbFolder.getObject() == null || daoObject.unlock(dbFolder.getObject(), dbSession)) continue;
                this.addError(dbFolder, ResMsgCore.getString("MSG_FOL_DONT_UNLOCK"));
            }
        }
        if (this.withWarnning()) {
            _LOG.finest("CmdExport-Phase3: Il y a eu un probleme => affichage de(s) erreur(s)");
            this.displayErrors(this.getErrors());
        }
    }

    protected FileFilter createFileFilter() {
        return new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_XML"), ".xml").verifyWrite(true);
    }

    protected void doExport(Set<DBFolder> foldersToExport, File file) {
        PerformExportXML6 doExport = new PerformExportXML6(this.getAppl().getDAOFactory(), foldersToExport);
        PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(GeneralIOPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralIOPreferencies) {
            GeneralIOPreferencies gpref = (GeneralIOPreferencies)opts;
            doExport.setExportLogs(gpref.getExportLogs());
            doExport.setExportAccess(gpref.getExportAccess());
            doExport.setZipLimit(gpref.getExportZipLimit());
        }
        try {
            doExport.exportTo(file);
        }
        catch (IOException ioe) {
            this.addError(this._srcFolder, ResMsgCore.msgFormat("MSG_EXC_IOE", file.getAbsolutePath(), ioe.getMessage()));
        }
    }
}

