/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51AttrHandler
extends AbstractSA51Handler
implements SA51Constant {
    private AttrType _attrType;
    private String _comments;
    private DBFolder _attrFolder;
    private DAOObject _dao;
    private boolean _freeze;
    private SA51Utils.Pair _attributeWithVersion;
    private List<String> _argEnum = new ArrayList<String>();
    public static Map<String, AttrType> ATTR_TYPES = new LinkedHashMap<String, AttrType>();

    public SA51AttrHandler(SA51Handler handler) {
        super(handler);
        this._attrFolder = this.getCeciFactory().createFolderDAO().getRootID("ATTRIBUTES").findChild("Default");
        if (this._attrFolder == null) {
            this._attrFolder = this.createNewFolder("Default", DBFolder.createFlagsFolder(DBFolder.Family.ATTRIBUTE, (short)0, (short)0), true, this.getCeciFactory().createFolderDAO().getRootID("ATTRIBUTES"));
        }
        this._dao = this.getCeciFactory().createObjectDAO();
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if ("ATTRIBUTE".equals(name)) {
            this._attributeWithVersion = SA51Utils.createVarWithVer(this.getAttribute(attrs, "NAME"));
            if (this._attributeWithVersion == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", name, "NAME", this.getAttribute(attrs, "NAME")), this.getLocator()));
            }
            this._comments = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
            this._freeze = Boolean.parseBoolean(this.getAttribute(attrs, "FREEZE"));
        }
        if (ATTR_TYPES.containsKey(name)) {
            this._attrType = ATTR_TYPES.get(name);
            if (this._attrType.equals((Object)AttrType.ENUM)) {
                this._argEnum.add(this.getAttribute(attrs, "VALUE"));
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if ("ATTRIBUTE".equals(name)) {
            if (this._attributeWithVersion == null) {
                return false;
            }
            DBFolder folderAttr = this._attrFolder.findChild(this._attributeWithVersion.getName());
            if (folderAttr == null) {
                String attributeName = this.getValidName(this._attributeWithVersion.getName(), DBFolder.Family.ATTRIBUTE, name, "NAME");
                folderAttr = this.createNewFolder(attributeName, DBFolder.createFlagsModel(DBFolder.Family.ATTRIBUTE, (short)0, (short)0), true, this._attrFolder);
            }
            DBFolder folderVers = this.createNewFolder(this._attributeWithVersion.getVersion(), DBFolder.createFlagsVersion(DBFolder.Family.ATTRIBUTE, (short)0, (short)0), true, this._comments == null || this._comments.isEmpty() ? null : this._comments, folderAttr);
            DBAttrib dbAttr = new DBAttrib(folderVers);
            dbAttr.setType(this._attrType);
            if (this._attrType.equals((Object)AttrType.ENUM)) {
                dbAttr.setEnums(this._argEnum);
            }
            for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
                dbAttr.getLogs().addLog(log);
            }
            this.addDefaultLog(dbAttr);
            DBObject obj = new DBObject(folderVers.getID()).setFolder(folderVers);
            obj.setBinFlag(this._freeze ? 2 : 0);
            folderVers.setObject(obj);
            DBObjModel dbObjModel = dbAttr.writeDBObjModel(false);
            obj.addModel(new DBObjModelBytes(dbObjModel));
            DBObjModel dbObjLogs = dbAttr.writeDBObjLogs(false);
            obj.addModel(new DBObjModelBytes(dbObjLogs));
            this._dao.putWrap(obj, dbAttr.getCopy());
            if (this._attrType.equals((Object)AttrType.ENUM)) {
                this._argEnum.clear();
            }
            this.getLinker().addNewObject(this._attributeWithVersion.getName() + this._attributeWithVersion.getVersion(), SA51Handler.TypeObject.ATTRIBUTE, folderVers);
            return false;
        }
        return "ATTRIBUTE_LIST".equals(name);
    }

    static {
        ATTR_TYPES.put("ALIAS", AttrType.ALIAS);
        ATTR_TYPES.put("ENUMERATION", AttrType.ENUM);
        ATTR_TYPES.put("STRING", AttrType.STRING);
        ATTR_TYPES.put("NUMBER", AttrType.NUMBER);
    }
}

