/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51LawHandler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.util.Date;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51BTPHandler
extends AbstractSA51Handler
implements SAXActionHandler,
SA51Constant {
    private DBFolder _currentFolder = this._btpFolder = this.getCeciFactory().createFolderDAO().getRootID("LAW_MODELS");
    private DBFolder _btpFolder;
    private SA51LawHandler _lawHandler;
    private SA51Utils.Pair _p;
    private boolean _isInEventModel = false;
    private Law _law;
    private String _appName;
    private String _appComment;
    private String _authorName;
    private String _commentAuthor;
    private String _substantationName;
    private String _substantationDate;
    private String _substantationComment;
    private String _commentVers;

    public SA51BTPHandler(SA51Handler handler) {
        super(handler);
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._lawHandler != null) {
            this._lawHandler.startAction(name, attrs, startAction);
        } else if (BTP_TAGS.contains(name)) {
            DBFolder newFolder;
            this._currentFolder = newFolder = this.createNewFolder(null, DBFolder.createFlagsFolder(DBFolder.Family.BTP_MODEL, (short)0, (short)0), false, this._currentFolder);
        } else if ("EVENT_MODEL".equals(name)) {
            this._isInEventModel = true;
        } else if ("IDENTIFICATION_BTP".equals(name)) {
            String varname = this.getValidName(this.getAttribute(attrs, "NAME"), DBFolder.Family.BTP_MODEL, name, "NAME");
            String comment = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
            if (this._isInEventModel) {
                DBFolder modelFolder = this._currentFolder.findChild(varname);
                if (modelFolder == null) {
                    modelFolder = this.createNewFolder(varname, DBFolder.createFlagsModel(DBFolder.Family.BTP_MODEL, (short)0, (short)0), false, this._currentFolder);
                }
                this._currentFolder = modelFolder;
                this._commentVers = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
                String varvers = this.getAttribute(attrs, "VERSION");
                if (varvers == null) {
                    varvers = "1";
                }
                String buffer = varname + "/" + varvers;
                this._p = SA51Utils.createVarWithVer(buffer);
                if (this._p == null) {
                    this.error(new SAXParseException(ResMsgSA51.msgFormat("MSG_ERR_BTP_IDENTIFICATION", buffer), this.getLocator()));
                }
            } else {
                this._currentFolder.setName(varname);
                this._currentFolder.setDescription(comment);
            }
            Date updateTime = SA51Utils.convertDate(this.getAttribute(attrs, "UPDATE_DATE"));
            this._currentFolder.setDateModify(updateTime);
            Date creationTime = SA51Utils.convertDate(this.getAttribute(attrs, "CREATION_DATE"));
            this._currentFolder.setDateCreate(creationTime);
        } else if (SA51Utils.INDEX_LAWS.containsKey(name)) {
            this._lawHandler = new SA51LawHandler(name, this.getHandler());
            this._lawHandler.startAction(name, attrs, true);
        } else if ("APPLICATION".equals(name)) {
            this._appName = this.getAttribute(attrs, "NAME");
            this._appComment = this.getAttribute(attrs, "COMMENT");
        } else if ("AUTHOR".equals(name)) {
            this._authorName = this.getAttribute(attrs, "NAME");
            this._commentAuthor = this.getAttribute(attrs, "COMMENT");
            if (this._commentAuthor != null && this._commentAuthor.length() > 1023) {
                this.warning(new SAXParseException(ResMsgSA51.msgFormat("MSG_WARNING_COMMENT_TOO_LONG", this._commentAuthor), this.getLocator()));
                this._commentAuthor = this._commentAuthor.substring(0, 1023);
            }
        } else if ("SUBSTANTIATION".equals(name)) {
            this._substantationName = this.getAttribute(attrs, "NAME");
            this._substantationComment = this.getAttribute(attrs, "COMMENT");
            this._substantationDate = this.convertDateSubsToFormat(this.getAttribute(attrs, "DATE"));
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._lawHandler != null && this._lawHandler.endAction(name, attrs, txt)) {
            this._law = this._lawHandler.getLaw();
            Law modifier = this._lawHandler.getModifier();
            if (modifier != null) {
                this._law.setModifierLaw(modifier.getCopy());
            }
            this._lawHandler = null;
        } else if ("AUTHOR".contains(name) && !this._isInEventModel) {
            this.createNewFolderBTP("BTP_AUTHORS", this._authorName, DBFolder.Family.BTP_AUTHOR, this._commentAuthor);
            this._authorName = null;
        } else if ("SUBSTANTIATION".contains(name) && !this._isInEventModel) {
            DBFolder mySub = this.createNewFolderBTP("BTP_SUBSTANTIATIONS", this._substantationName, DBFolder.Family.BTP_SUBSTANTIATION, this._substantationComment);
            DBLogs logs = new DBLogs();
            logs.addLog(this.getHandler().getCurrentDate(), this.getLogin(), DBLogs.DBLevel.FINE, ResMsgSA51.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getHandler().getFilePathForLog()));
            DBObject obj = new DBObject(mySub.getID()).setFolder(mySub);
            SA51Utils.addLogsToObj(obj, logs);
            mySub.setObject(obj);
            SA51Utils.createProperty(obj, this._substantationDate, "btp.substantiation.date");
            this._substantationName = null;
        } else if ("APPLICATION".contains(name) && !this._isInEventModel) {
            this.createNewFolderBTP("BTP_APPLICATIONS", this._appName, DBFolder.Family.BTP_APPLICATION, this._appComment);
        } else if ("EVENT_MODEL".contains(name)) {
            DBFolder foldApp;
            DBFolder myApp;
            DBFolder foldAuthor;
            DBFolder myAuthor;
            DBFolder foldSubs;
            DBFolder folderVersion = this.createNewFolder(this._p.getVersion(), -1, SA51BTPHandler.getLastUpdateDate(), SA51BTPHandler.getLastUpdateDate(), this._commentVers == null || this._commentVers.isEmpty() ? null : this._commentVers, this._currentFolder);
            DBFolder mySubs = null;
            if (this._substantationName != null && !this._substantationName.isEmpty() && (mySubs = (foldSubs = this.getCeciFactory().createFolderDAO().getRootID("BTP_SUBSTANTIATIONS")).findChild(this._substantationName)) == null) {
                mySubs = this.createNewFolderBTP("BTP_SUBSTANTIATIONS", this._substantationName, DBFolder.Family.BTP_SUBSTANTIATION, this._substantationComment);
            }
            if ((myAuthor = (foldAuthor = this.getCeciFactory().createFolderDAO().getRootID("BTP_AUTHORS")).findChild(this._authorName)) == null) {
                myAuthor = this.createNewFolderBTP("BTP_AUTHORS", this._authorName, DBFolder.Family.BTP_AUTHOR, this._commentAuthor);
            }
            if ((myApp = (foldApp = this.getCeciFactory().createFolderDAO().getRootID("BTP_APPLICATIONS")).findChild(this._appName)) == null) {
                myApp = this.createNewFolderBTP("BTP_APPLICATIONS", this._appName, DBFolder.Family.BTP_APPLICATION, this._appComment);
            }
            DBModelLaw dbLaw = new DBModelLaw(folderVersion);
            dbLaw.setLaw(this._law);
            dbLaw.setAuthor(myAuthor);
            dbLaw.setApplication(myApp);
            for (DBLogs.Log log : this.getLogs().getLogs(DBLogs.DBLevel.FINEST)) {
                dbLaw.getLogs().addLog(log);
            }
            this.addDefaultLog(dbLaw);
            if (mySubs != null) {
                dbLaw.setSubstantiation(mySubs);
            }
            DBObject object = new DBObject(folderVersion.getID()).setFolder(folderVersion);
            SA51Utils.createProperty(object, this._authorName, "object.creator");
            folderVersion.setObject(object);
            folderVersion.setFlags(DBFolder.createFlagsVersion(DBFolder.Family.BTP_MODEL, (short)0, (short)0));
            DBObjModel dbObjModel = dbLaw.writeDBObjModel(false);
            object.addModel(new DBObjModelBytes(dbObjModel));
            DBObjModel dbObjLogs = dbLaw.writeDBObjLogs(false);
            object.addModel(new DBObjModelBytes(dbObjLogs));
            this.getCeciFactory().createObjectDAO().putWrap(object, dbLaw);
            this._isInEventModel = false;
            this._currentFolder = this._currentFolder.getParent();
            this.getLinker().addNewObject(SA51Utils.getFullPath(folderVersion, "LAW_MODELS"), SA51Handler.TypeObject.BTP, folderVersion);
        } else if (BTP_TAGS.contains(name)) {
            this._currentFolder = this._currentFolder.getParent();
        } else if ("BTP".equals(name)) {
            return true;
        }
        return false;
    }

    private final DBFolder createNewFolderBTP(String parentFolderName, String nameFolder, DBFolder.Family family, String comment) {
        DBFolder parentFolder = this.getCeciFactory().createFolderDAO().getRootID(parentFolderName);
        DBFolder myFolder = parentFolder.findChild(nameFolder);
        if (myFolder == null) {
            myFolder = this.createNewFolder(nameFolder, DBFolder.createFlagsVersion(family, (short)0, (short)0), SA51BTPHandler.getLastUpdateDate(), SA51BTPHandler.getLastUpdateDate(), comment, parentFolder);
        }
        return myFolder;
    }

    private final String convertDateSubsToFormat(String dateFormatUnallow) {
        String date = dateFormatUnallow;
        String month = date.substring(date.indexOf(45) + 1, date.lastIndexOf(45));
        String numericalMonth = SA51Utils.INDEX_DATES.get(month);
        StringBuilder sb = new StringBuilder();
        sb.append(date.substring(0, date.indexOf(45))).append('/').append(numericalMonth).append('/').append(date.substring(date.lastIndexOf(45) + 1, date.length()));
        return sb.toString();
    }
}

