/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.io.ftp10.FtpConstant;
import com.dassault.cecilia.io.ftp10.FtpException;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.util.Date;

public class FtpDatesReader
implements FtpConstant {
    private final Table _table;
    private Date _creationDate;
    private Date _updateDate;

    public FtpDatesReader(Database base) throws IOException {
        this._table = base.getSystemTable(this.getIDTable());
    }

    public final Date getCreationDate() {
        return this._creationDate;
    }

    public final Date getUpdateDate() {
        return this._updateDate;
    }

    protected void readTable() throws FtpException {
        for (Row row : this._table) {
            String name = row.getString("Name");
            if (name == null) {
                return;
            }
            if (!name.equals("Common Cause Failures") && !name.equals("Events") && !name.equals("Gates") && !name.equals("Generic Models")) continue;
            Date dateCreate = row.getDate("DateCreate");
            Date dateUpdate = row.getDate("DateUpdate");
            if (dateCreate != null && (this._creationDate == null || dateCreate.before(this._creationDate))) {
                this._creationDate = dateCreate;
            }
            if (dateUpdate == null || this._updateDate != null && !dateUpdate.after(this._updateDate)) continue;
            this._updateDate = dateUpdate;
        }
    }

    protected String getIDTable() {
        return "MSysObjects";
    }
}

