/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.io.ftp10.FtpAbsTableReader;
import com.dassault.cecilia.io.ftp10.FtpException;
import com.dassault.cecilia.io.ftp10.FtpHandler;
import com.dassault.cecilia.io.ftp10.ResMsgFtp;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class FtpGateTableReader
extends FtpAbsTableReader {
    private final Map<FTVariable, DBLogs> _mapVarToLogs;
    private final Map<String, FTVariable> _mapNameToEvents;
    private final Map<String, FTVariable> _mapNameToGates;
    private final Set<FTVariable> _declaredGates;
    private final Set<FTVariable> _declaredChildren;
    private final DBFolder _systemFolder;
    private int _cptRename;

    public FtpGateTableReader(FtpHandler handler, DBFolder root, Database base, Map<String, FTVariable> mapNameToEvents, Map<FTVariable, DBLogs> mapVarToLogs) throws IOException {
        super(handler, base);
        this._mapNameToEvents = mapNameToEvents;
        this._mapNameToGates = new LinkedHashMap<String, FTVariable>();
        this._declaredChildren = new LinkedHashSet<FTVariable>();
        this._declaredGates = new LinkedHashSet<FTVariable>();
        this._systemFolder = root != null ? this.configureRoot(root) : this.createSystemFolder();
        this._mapVarToLogs = new LinkedHashMap<FTVariable, DBLogs>();
        this._mapVarToLogs.putAll(mapVarToLogs);
    }

    @Override
    protected void readLine(Row row) throws FtpException {
        String messWarn;
        String newName;
        String name = row.getString("Name");
        if (name == null) {
            return;
        }
        FTVariable var = null;
        name = newName = this.getValidName(name, DBFolder.Family.PROJECT);
        this.checkConflict(name);
        if (this._mapNameToGates.containsKey(name)) {
            var = this._mapNameToGates.get(name);
        } else {
            var = new FTVariable();
            var.setName(name);
        }
        String descr = this.getValidDesc(row.getString("Description"), name);
        if (this._mapNameToEvents.containsKey(name)) {
            String newName2 = name + "_gate" + this._cptRename++;
            messWarn = ResMsgFtp.msgFormat("FTP_WARN_GATE_SAME_ID_EVENT", name, newName2);
            this.displayMessage(Level.WARNING, this.createMessWithLocator(messWarn));
            this.addLog(DBLogs.DBLevel.WARNING, messWarn);
            var.setName(newName2);
        }
        var.setLabel(descr == null ? "" : descr);
        String type = row.getString("Type");
        if (type.equals("TRANSFER")) {
            messWarn = ResMsgFtp.msgFormat("FTP_WARN_GATE_TRANSFER_NOT_HANDLED", name);
            this.addLog(DBLogs.DBLevel.WARNING, messWarn);
            this.displayMessage(Level.WARNING, this.createMessWithLocator(messWarn));
            FTEvent event = new FTEvent();
            var.setEvent(event);
            event.setVariable(var);
            event.setOccurrence(this.getFactory().getLawManager().createLaw(-1));
        } else {
            FTDefinition.Type gateType = this.getTypeByName(name, row.getString("Type"));
            Set<FTVariable> children = this.getChildren(row, name);
            if (children.isEmpty()) {
                FTEvent event = new FTEvent();
                var.setEvent(event);
                event.setVariable(var);
                event.setOccurrence(this.getFactory().getLawManager().createLaw(-1));
                String warnMess = ResMsgFtp.msgFormat("FTP_WARN_GATE_NO_CHILDREN", name);
                this.addLog(DBLogs.DBLevel.WARNING, warnMess);
                this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
            } else {
                FTDefinition ftDef = new FTDefinition(gateType, children);
                if (gateType == FTDefinition.Type.KOFN) {
                    Number number = (Number)row.get((Object)"Vote Number");
                    ftDef.setAtLeast(number.intValue());
                }
                var.setDefinition(ftDef);
                this._declaredChildren.addAll(children);
                this._declaredGates.add(var);
            }
        }
        if (!this._mapNameToGates.containsKey(name)) {
            this._mapNameToGates.put(name, var);
        }
        this._mapVarToLogs.put(var, this.getLogs().getCopy());
    }

    public final void generateRoots() {
        this._declaredGates.removeAll(this._declaredChildren);
        for (FTVariable var : this._declaredGates) {
            var.setRoot(true);
            String folderModelTreeName = var.getName();
            String description = null;
            DBFolder folderModelTree = this.createNewDBFolder(this._systemFolder, folderModelTreeName, description, DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)2, (short)0));
            DBFolder folderVersTree = this.createNewDBFolder(folderModelTree, "1.0", null, DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, (short)2, (short)0));
            FTEquation ftEqu = new FTEquation(folderVersTree);
            DBLogs logs = new DBLogs();
            ftEqu.setVariables(this.getAllVariablesFromRoot(var, logs), new DBLogs.DefaultManager(this.getLogin(), logs), false);
            for (DBLogs.Log log : logs.getLogs(DBLogs.DBLevel.ERROR)) {
                if (log.getLevel() == DBLogs.DBLevel.ERROR) {
                    this.displayMessage(Level.SEVERE, log.getMessage());
                }
                this.displayMessage(Level.WARNING, log.getMessage());
            }
            this.addObjectFromFolder(folderVersTree, ftEqu, logs, ResMsgFtp.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getFilePathForLog()));
        }
    }

    @Override
    public String getIDTable() {
        return "Gates";
    }

    private final Set<FTVariable> getChildren(Row row, String gateName) throws FtpException {
        LinkedHashSet<FTVariable> children = new LinkedHashSet<FTVariable>();
        if (row.getString("Input  0 Type and Name") != null) {
            this.createChildrenFT10(row, children, gateName);
        } else {
            this.createChildrenFT8(row, children, gateName);
        }
        return children;
    }

    private final void createChildrenFT10(Row row, Set<FTVariable> children, String gateName) throws FtpException {
        for (int i = 0; i < ALL_FIELDS_GATES_FT10.size(); ++i) {
            String childName = row.getString((String)ALL_FIELDS_GATES_FT10.get(i));
            if (childName == null || childName.isEmpty()) {
                return;
            }
            boolean isEvent = childName.charAt(0) == 'E';
            childName = childName.substring(2, childName.length());
            FTVariable var = null;
            if (isEvent && (var = this._mapNameToEvents.get(childName)) == null) {
                var = this._mapNameToEvents.get(DBFactory.convertName(childName, DBFolder.Family.PROJECT));
            }
            if (var == null) {
                var = this._mapNameToGates.get(childName);
            }
            if (var == null) {
                var = this._mapNameToGates.get(DBFactory.convertName(childName, DBFolder.Family.PROJECT));
            }
            if (var == null) {
                String newName = this.getValidName(childName, DBFolder.Family.PROJECT);
                var = new FTVariable().setName(newName);
                var.setDefinition(new FTDefinition(null, new ArrayList()));
                this._mapNameToGates.put(childName, var);
            }
            children.add(var);
        }
    }

    private final void createChildrenFT8(Row row, Set<FTVariable> children, String gateName) {
        String childGateName;
        FTVariable var;
        String eventName;
        int i;
        for (i = 0; i < ALL_EVENTS_PARAMS_FT8.size() && (eventName = row.getString((String)ALL_EVENTS_PARAMS_FT8.get(i))) != null && !eventName.isEmpty(); ++i) {
            var = this._mapNameToEvents.get(eventName);
            if (var == null) {
                var = new FTVariable().setName(eventName);
                FTEvent event = new FTEvent();
                var.setEvent(event);
                event.setVariable(var);
                event.setOccurrence(this.getFactory().getLawManager().createLaw(-1));
                this._mapNameToEvents.put(eventName, var);
                String warnMess = ResMsgFtp.msgFormat("FTP_WARN_AUTOGENERATED_EVENT", gateName, eventName);
                this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
                this.addLog(DBLogs.DBLevel.WARNING, warnMess);
            }
            children.add(var);
        }
        for (i = 0; i < ALL_GATES_PARAMS_FT8.size() && (childGateName = row.getString((String)ALL_GATES_PARAMS_FT8.get(i))) != null && !childGateName.isEmpty(); ++i) {
            var = this._mapNameToGates.get(childGateName);
            if (var == null) {
                var = new FTVariable().setName(childGateName);
                var.setDefinition(new FTDefinition(null, new ArrayList()));
                this._mapNameToGates.put(childGateName, var);
            }
            children.add(var);
        }
    }

    private final FTDefinition.Type getTypeByName(String nameGate, String typeStr) {
        switch (typeStr) {
            case "NOT": {
                return FTDefinition.Type.NOT;
            }
            case "AND": {
                return FTDefinition.Type.AND;
            }
            case "OR": {
                return FTDefinition.Type.OR;
            }
            case "XOR": {
                return FTDefinition.Type.XOR;
            }
            case "VOTE": {
                return FTDefinition.Type.KOFN;
            }
            case "TRANSFER": {
                return null;
            }
        }
        String warnMess = ResMsgFtp.msgFormat("FTP_WARN_GATE_TYPE_UNKNOWN", typeStr, nameGate);
        this.displayMessage(Level.SEVERE, this.createMessWithLocator(warnMess));
        this.addLog(DBLogs.DBLevel.WARNING, warnMess);
        return FTDefinition.Type.OR;
    }

    private final DBFolder configureRoot(DBFolder folder) {
        DBFolder rootProject = this.getFactory().createFolderDAO().getRootID("PROJECTS");
        DBFolder projectFolder = folder.getParent();
        this.linkDBFolder(rootProject, projectFolder);
        return folder;
    }

    private final DBFolder createSystemFolder() {
        DBFolder rootProject = this.getFactory().createFolderDAO().getRootID("PROJECTS");
        DBFolder projectFtpFolder = this.createNewDBFolder(rootProject, "FTProject", null, DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)8, (short)0));
        DBProject project = new DBProject(projectFtpFolder);
        this.addObjectFromFolder(projectFtpFolder, project, new DBLogs(), ResMsgFtp.msgFormat("MSG_LOG_CREATE_FOR_FILE", this.getFilePathForLog()));
        DBFolder systemFtpFolder = this.createNewDBFolder(projectFtpFolder, "FTSystem", null, DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)0, (short)0));
        return systemFtpFolder;
    }

    private final Collection<FTVariable> getAllVariablesFromRoot(FTVariable root, DBLogs logs) {
        LinkedHashSet<FTVariable> set = new LinkedHashSet<FTVariable>();
        this.getAllVariablesFromRoot_rec(null, root, logs, set);
        return set;
    }

    private final void getAllVariablesFromRoot_rec(String parentName, FTVariable var, DBLogs logs, Set<FTVariable> set) {
        FTDefinition ftDef;
        if (set.contains(var)) {
            return;
        }
        DBLogs logsFromVar = this._mapVarToLogs.get(var);
        if (logsFromVar != null) {
            for (DBLogs.Log log : logsFromVar.getLogs(DBLogs.DBLevel.FINEST)) {
                logs.addLog(log);
            }
        }
        if ((ftDef = var.getDefinition()) != null) {
            if (ftDef.getType() == null) {
                var.setDefinition(null);
                FTEvent event = new FTEvent();
                event.setVariable(var);
                var.setEvent(event);
                event.setOccurrence(this.getFactory().getLawManager().createLaw(-1));
                var.setLabel("AutoGenerated Event");
                String warnMess = ResMsgFtp.msgFormat("FTP_WARN_AUTOGENERATED_EVENT", parentName, var.getName());
                this.displayMessage(Level.WARNING, this.createMessWithLocator(warnMess));
                logs.addLog(this.getCurrentDate(), this.getLogin(), DBLogs.DBLevel.WARNING, warnMess);
            } else {
                for (FTVariableAbstract child : ftDef.getArgs()) {
                    if (!(child instanceof FTVariable)) continue;
                    FTVariable childVar = (FTVariable)child;
                    this.getAllVariablesFromRoot_rec(var.getName(), childVar, logs, set);
                }
            }
        }
        set.add(var);
    }
}

