/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ftp10;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.io.ftp10.FtpAbsTableReader;
import com.dassault.cecilia.io.ftp10.FtpException;
import com.dassault.cecilia.io.ftp10.FtpHandler;
import com.dassault.cecilia.io.ftp10.ResMsgFtp;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Row;
import java.io.IOException;
import java.util.logging.Level;

public class FtpGenericModelTableReader
extends FtpAbsTableReader {
    public FtpGenericModelTableReader(FtpHandler handler, Database base) throws IOException {
        super(handler, base);
    }

    @Override
    public void readLine(Row row) throws FtpException {
        String name = row.getString("Name");
        if (name == null) {
            return;
        }
        String category = row.getString("Category");
        String description = this.getValidDesc(row.getString("Description"), name);
        StringBuilder sb = new StringBuilder();
        if (category != null && category.equals("Parameter")) {
            String parameterType = row.getString("Parameter Type");
            sb.append(ResMsgFtp.msgFormat("FTP_PARAMETER_TYPE", parameterType)).append('\n');
            String newName = this.getValidName(name, DBFolder.Family.PARAMETER);
            if (!newName.equals(name)) {
                sb.append(ResMsgFtp.msgFormat("FTP_ORIGINAL_NAME", name)).append("\n");
            }
            name = newName;
            this.checkConflict(name);
            if (!description.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(description).append('\n');
            }
            DBFolder modelFolder = this.createNewDBFolder(this.getFTPParamsFolder(), name, sb.toString(), DBFolder.createFlagsModel(DBFolder.Family.PARAMETER, (short)0, (short)0));
            DBFolder versFolder = this.createNewDBFolder(modelFolder, "1", sb.toString(), DBFolder.createFlagsVersion(DBFolder.Family.PARAMETER, (short)0, (short)0));
            DBParam dbParam = new DBParam(versFolder);
            TypeParam typeParam = this.getParamByValue(name, parameterType);
            dbParam.setType(typeParam);
            Double param0 = row.getDouble("Parameter 0");
            Double param1 = row.getDouble("Parameter 1");
            Param paramValue = this.createLawDistrib(row.getString("Distribution 0"), typeParam, new ParamValue(typeParam, param0), param1);
            if (paramValue == null) {
                paramValue = new ParamValue(typeParam, param0);
            }
            dbParam.setValue(paramValue);
            this.addObjectFromFolder(versFolder, dbParam, this.getLogs(), ResMsgFtp.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getFilePathForLog()));
        } else {
            String modelType = row.getString("Model Type");
            if (modelType == null) {
                modelType = row.getString("Type");
            }
            sb.append(ResMsgFtp.msgFormat("FTP_MODEL_TYPE", modelType)).append('\n');
            String newName = this.getValidName(name, DBFolder.Family.BTP_MODEL);
            if (!newName.equals(name)) {
                sb.append(ResMsgFtp.msgFormat("FTP_ORIGINAL_NAME", name)).append("\n");
            }
            name = newName;
            this.checkConflict(name);
            if (!description.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(description).append('\n');
            }
            DBFolder modelBTPFolder = this.createNewDBFolder(this.getFTPModelsFolder(), name, sb.toString(), DBFolder.createFlagsModel(DBFolder.Family.BTP_MODEL, (short)0, (short)0));
            DBFolder versBTPFolder = this.createNewDBFolder(modelBTPFolder, "1", sb.toString(), DBFolder.createFlagsVersion(DBFolder.Family.BTP_MODEL, (short)0, (short)0));
            DBModelLaw modelLaw = new DBModelLaw(versBTPFolder);
            Law law = this.createLaw(name, row);
            modelLaw.setLaw(law);
            this.addObjectFromFolder(versBTPFolder, modelLaw, this.getLogs(), ResMsgFtp.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getFilePathForLog()));
        }
    }

    private DBFolder getFTPParamsFolder() {
        DBFolder parameterRoot = this.getFactory().createFolderDAO().getRootID("LAW_PARAMETERS");
        DBFolder ftpParamsFolder = parameterRoot.findChild("FTParameters");
        if (ftpParamsFolder == null) {
            ftpParamsFolder = this.createNewDBFolder(parameterRoot, "FTParameters", ResMsgFtp.getString("FTP_PARAMETER_FOLDER_DESCRIPTION"), DBFolder.createFlagsFolder(DBFolder.Family.PARAMETER, (short)0, (short)0));
        }
        return ftpParamsFolder;
    }

    private DBFolder getFTPModelsFolder() {
        DBFolder modelsRoot;
        DBFolder tmpFolder = modelsRoot = this.getFactory().createFolderDAO().getRootID("LAW_MODELS");
        for (String nameFolder : FT_MODELLAWS_ID) {
            DBFolder newFolder = tmpFolder.findChild(nameFolder);
            if (newFolder == null) {
                newFolder = this.createNewDBFolder(tmpFolder, nameFolder, ResMsgFtp.getString("FTP_MODEL_LAW_FOLDER_DESCRIPTION"), DBFolder.createFlagsFolder(DBFolder.Family.BTP_MODEL, (short)0, (short)0));
            }
            tmpFolder = newFolder;
        }
        return tmpFolder;
    }

    @Override
    public String getIDTable() {
        return "Generic Models";
    }

    private final TypeParam getParamByValue(String paramName, String value) {
        switch (value) {
            case "Failure Rate": {
                return TypeParam.RATE;
            }
            case "Inspection Interval": 
            case "Time at Risk": {
                return TypeParam.DELAY;
            }
        }
        this.displayMessage(Level.WARNING, ResMsgFtp.msgFormat("FTP_WARN_UNKNOWN_TYPE_PARAM", paramName, value));
        return TypeParam.RATE;
    }

    @Override
    protected final double getParamAt(Row row, int idx) {
        switch (idx) {
            case 0: {
                return row.getDouble("Parameter 0");
            }
            case 1: {
                return row.getDouble("Parameter 1");
            }
            case 2: {
                return row.getDouble("Parameter 2");
            }
            case 3: {
                return row.getDouble("Parameter 3");
            }
            case 4: {
                return row.getDouble("Parameter 4");
            }
            case 5: {
                return row.getDouble("Parameter 5");
            }
        }
        return Double.NaN;
    }

    @Override
    protected String getModelDistribution(Row row, int idx) {
        if (idx == 0) {
            return row.getString("Distribution 0");
        }
        if (idx == 1) {
            return row.getString("Distribution 1");
        }
        return row.getString("Distribution 2");
    }

    @Override
    protected String getLawValue(Row row) {
        return row.getString("Type");
    }
}

