/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.DAOTools;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.io.AbstractCmdImport;
import com.dassault.cecilia.io.imports.CmdImportRealise;
import com.dassault.cecilia.io.imports.MapImport;
import com.dassault.cecilia.io.imports.gui.DlgImportAbstract;
import com.dassault.cecilia.io.imports.gui.DlgImportTable;
import com.dassault.cecilia.io.imports.gui.DlgImportTree;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractCmdImportPrepare
extends AbstractCmdImport {
    private static Logger _LOG = Logger.getLogger(AbstractCmdImportPrepare.class.getPackage().getName());
    public static final String PROP_IMPORT_DLG_WITH_TABLE = "cecilia.import.DialogWithTable";

    public AbstractCmdImportPrepare(CeciliaAppl appl, JFrame owner) {
        super(appl, owner);
    }

    @Override
    protected FileFilterExtention createFileFilter() {
        return new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_XML"), ".xml");
    }

    protected DAOTools createDAOTools(DAOFactory daoFactory) {
        return new DAOTools(daoFactory);
    }

    @Override
    protected void firstDo() {
        DAOTools doaTools;
        _LOG.finer("readfile(" + this._importFiles[0].getAbsolutePath() + ")");
        DAOFactory daoFactory = this.readFile(this._importFiles[0]);
        if (daoFactory == null) {
            return;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            DemoLimitedFactory demoFactory = new DemoLimitedFactory(this.getAppl(), daoFactory);
            try {
                demoFactory.verifyBaseLimitsCounter(true);
                demoFactory.verifyBaseLimitsModel();
            }
            catch (DemoLimitedException e) {
                _LOG.info("DemoLimited " + e.toString());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractCmdImportPrepare.this.displayErrorDemo();
                    }
                });
                return;
            }
        }
        if (!(doaTools = this.createDAOTools(daoFactory)).verify()) {
            doaTools.appendFatalError(null, ResMsgCore.getString("MSG_ERR_DAOTOOL_FATAL"));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractCmdImportPrepare.this.displayErrors(doaTools.getErrors(), false);
                }
            });
            return;
        }
        if (!doaTools.getErrors().isEmpty() && !this.displayErrors(doaTools.getErrors(), true)) {
            return;
        }
        final MapImport mapImport = new MapImport(daoFactory, this.getAppl().getDAOFactory(), this.getAppl().getDBSession());
        final DlgImportAbstract dlg = Boolean.getBoolean(PROP_IMPORT_DLG_WITH_TABLE) ? new DlgImportTable((Window)this._ctrlOwner, mapImport) : new DlgImportTree((Window)this._ctrlOwner, mapImport);
        dlg.setTitle(ResMsgVoc.getString("VOC_IMPORT") + " - " + this._importFiles[0].getAbsolutePath());
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this._ctrlOwner));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    return;
                }
                if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
                    try {
                        DemoLimits importLimits = new DemoLimits();
                        mapImport.countCreateModel(importLimits);
                        ((DemoLimitedFactory)AbstractCmdImportPrepare.this.getAppl().getDAOFactory()).verifyAppendLimits(importLimits);
                    }
                    catch (DemoLimitedException e) {
                        if (_LOG.isLoggable(Level.FINEST) && AbstractCmdImportPrepare.this.getAppl().isDebugMode()) {
                            _LOG.log(Level.FINEST, "DemoLimited " + e.toString(), e);
                        } else {
                            _LOG.info("DemoLimited " + e.toString());
                        }
                        AbstractCmdImportPrepare.this.displayErrorDemo();
                        return;
                    }
                }
                CmdImportRealise cmd = new CmdImportRealise(AbstractCmdImportPrepare.this.getAppl(), AbstractCmdImportPrepare.this._ctrlOwner, mapImport);
                cmd.realiseDo();
            }
        });
    }

    protected abstract DAOFactory readFile(File var1);

    private boolean displayErrors(List<GeneralError<DBFolder>> errors, final boolean onlyWarning) {
        JFrame win = this._ctrlOwner;
        DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(win){

            @Override
            protected TableCellRenderer getSourceRenderer() {
                return new FolderRenderer().setDisplayPath(true);
            }

            @Override
            protected Component createSouthComponent() {
                if (onlyWarning) {
                    return this.createButPanel(false);
                }
                return this.createButPanelClose(false);
            }

            @Override
            protected boolean verifyParameters() {
                return true;
            }
        };
        dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_IMPORT") + " - " + this._importFiles[0].getAbsolutePath());
        dlg.setErrors(errors);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this._ctrlOwner));
        dlg.setVisible(true);
        return dlg.getResult();
    }

    private void displayErrorDemo() {
        String title = ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_IMPORT") + " - " + this._importFiles[0].getAbsolutePath();
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.getString("DEMO_ERROR_IMPORT"), title, 0);
    }
}

