/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeModel;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.io.ftp10.FtpHandler;
import com.dassault.cecilia.io.imports.AbstractCmdImportPrepare;
import com.dassault.cecilia.io.imports.ParserTypeProject;
import com.dassault.cecilia.io.imports.gui.DlgChooseRootImport;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.gui.CFoldersPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;

public class CmdImportPrepareFtp
extends AbstractCmdImportPrepare {
    private DBFolder _systemRoot;

    public CmdImportPrepareFtp(CeciliaAppl appl, JFrame owner) {
        super(appl, owner);
    }

    @Override
    protected DAOFactory readFile(File file) {
        FtpHandler handler = new FtpHandler(this.getAppl(), file, this._systemRoot);
        boolean withoutError = handler.readFile();
        return withoutError ? handler.getFactory() : null;
    }

    @Override
    protected FileFilterExtention createFileFilter() {
        return new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_MDB"), ".mdb");
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_FTP");
    }

    @Override
    protected boolean prepareDo() {
        if (!super.prepareDo()) {
            return false;
        }
        List<DBFolder> systemFolder = this.checkForSystems();
        DBFolder root = null;
        if (systemFolder == null || systemFolder.isEmpty()) {
            this._systemRoot = null;
        } else if (systemFolder.size() == 1) {
            root = systemFolder.get(0);
        } else {
            DBFolderVirtualTreeModel.DBFolderVirtualTreeNode selectNode;
            Object lastPath;
            DlgChooseRootImport dlg = new DlgChooseRootImport(this.getAppl(), ParserTypeProject.TypeOfImport.TREE);
            CFoldersPanel foldersGUI = this.getAppl().getTopWindow().getFolders();
            DBFolderTreeActivable folderGUI = foldersGUI.getSelectedTree();
            if (folderGUI != null && folderGUI == foldersGUI.getTree(DBFolder.Family.PROJECT) && folderGUI.getSelectionCount() == 1 && (lastPath = folderGUI.getSelectionPath().getLastPathComponent()) != null && lastPath instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode && ((selectNode = (DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)lastPath).getFamilyFlag() == 2 || selectNode.getFamilyFlag() == 0)) {
                DBFolder folder = selectNode.getSource();
                if (folder.isModel()) {
                    folder = folder.getParent();
                }
                if (!folder.isReadOnly() && folder.getDepthUntilSystem() == folder.getFamily().getDepthFolder()) {
                    dlg.setSelectedDBFolder(folder);
                }
            }
            dlg.openWindow(this.getAppl().getTopWindow());
            if (!dlg.getResult()) {
                return false;
            }
            root = dlg.getSelectedDBFolder();
        }
        if (root != null) {
            root = new DBFolder(root);
            DBFolder folderParent = new DBFolder(root.getParent());
            root.setChildren(null).setParent(folderParent).setUserFlag((short)1);
            root.setID(-1000L - root.getID());
            folderParent.setChildren(new ArrayList<DBFolder>(Arrays.asList(root))).setParent(null).setUserFlag((short)1);
            folderParent.setID(-1000L - folderParent.getID());
            this._systemRoot = root;
        }
        return true;
    }

    private List<DBFolder> checkForSystems() {
        DAOFolder daoFolder = this.getAppl().getDAOFactory().createFolderDAO();
        DBFolder rootFolder = daoFolder.getRootID("PROJECTS");
        List<DBFolder> projectFolders = rootFolder.getChildren();
        if (projectFolders == null) {
            projectFolders = daoFolder.findChildren(rootFolder);
        }
        if (projectFolders == null || projectFolders.isEmpty()) {
            return null;
        }
        ArrayList<DBFolder> systemFolders = new ArrayList<DBFolder>();
        for (DBFolder projectFolder : projectFolders) {
            List<DBFolder> childrenFolder = projectFolder.getChildren();
            if (childrenFolder == null) {
                childrenFolder = daoFolder.findChildren(projectFolder);
            }
            if (childrenFolder == null) continue;
            systemFolders.addAll(childrenFolder);
        }
        return systemFolders;
    }
}

