/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoreUtil {
    private static Logger _LOG = Logger.getLogger(CoreUtil.class.getPackage().getName());
    public static Pattern PATTERN_VERSION = Pattern.compile("([0-9]+)\\.([0-9]+)(\\.([0-9]+))?(.*)");

    public static void main(String[] args) {
        System.out.println("cmp(3.2.beta 7, 4.0.7) => " + CoreUtil.controlImportVersion("3.2.beta 7", "4.0.7"));
        System.out.println("cmp(5.0.7, 5.0.8) => " + CoreUtil.controlImportVersion("5.0.7", "5.0.8"));
        System.out.println("cmp(5.1.2, 5.2.0) => " + CoreUtil.controlImportVersion("5.1.2", "5.2.0"));
        System.out.println("cmp(5.2.0, 5.1.2) => " + CoreUtil.controlImportVersion("5.2.0", "5.1.2"));
        System.out.println("cmp(4.3.0, 5.1.0) => " + CoreUtil.controlImportVersion("4.3.0", "5.1.0"));
        System.out.println("cmp(5.1.0, 4.3.0) => " + CoreUtil.controlImportVersion("5.1.0", "4.3.0"));
        System.out.println("cmp(5.0.7-Beta2, 5.0.8) => " + CoreUtil.controlImportVersion("5.0.7-Beta2", "5.0.8"));
        System.out.println("cmp(5.0.7, 5.0.8-Beta2) => " + CoreUtil.controlImportVersion("5.0.7", "5.0.8-Beta2"));
        System.out.println("cmp(5.0.7-Beta2, 5.0.7) => " + CoreUtil.controlImportVersion("5.0.7-Beta2", "5.0.7"));
        System.out.println("cmp(5.0.7, 5.0.7-Beta2) => " + CoreUtil.controlImportVersion("5.0.7", "5.0.7-Beta2"));
        System.out.println("cmp(5.0.8, 5.0.10) => " + CoreUtil.controlImportVersion("5.0.8", "5.0.10"));
        System.out.println("cmp(4.3.0, 5.1.x.RC) => " + CoreUtil.controlImportVersion("4.3.0", "5.1.x.RC"));
        System.out.println("cmp(5.1.x.RC, 5.1.6) => " + CoreUtil.controlImportVersion("5.1.x.RC", "5.1.6"));
    }

    public static boolean controlImportVersion(String importVersion) {
        String softwareVersion = "6.0.0";
        return CoreUtil.controlImportVersion(importVersion, softwareVersion);
    }

    public static boolean controlImportVersion(String importVersion, String softwareVersion) {
        if (importVersion.equals("3.2.beta 7")) {
            importVersion = "3.2 beta 7";
        } else if (importVersion.equals("5.1.x.RC")) {
            importVersion = "5.1.5";
        }
        importVersion = importVersion.trim();
        softwareVersion = softwareVersion.trim();
        Matcher importMatcher = PATTERN_VERSION.matcher(importVersion);
        if (!importMatcher.matches()) {
            System.err.println("Controle Version - format unknown : " + importVersion);
            return false;
        }
        Matcher softwareMatcher = PATTERN_VERSION.matcher(softwareVersion);
        if (!softwareMatcher.matches()) {
            System.err.println("Controle Version - format unknown : " + softwareVersion);
            return false;
        }
        boolean importVersionBeta = importMatcher.group(5).length() > 0;
        boolean softwareVersionBeta = softwareMatcher.group(5).length() > 0;
        for (int i = 0; i < 3; ++i) {
            int iSV;
            int idx = i == 2 ? i + 2 : i + 1;
            String sIV = importMatcher.group(idx);
            String sSV = softwareMatcher.group(idx);
            if (sIV == null || sIV.length() == 0 || sSV == null || sSV.length() == 0) {
                if (i != 2) {
                    _LOG.warning("Import control with version invalid:" + importVersion + ", " + softwareVersion);
                }
                return importVersionBeta || !softwareVersionBeta;
            }
            int iIV = Integer.parseInt(sIV);
            if (iIV > (iSV = Integer.parseInt(sSV))) {
                return false;
            }
            if (iIV >= iSV) continue;
            return true;
        }
        return importVersionBeta || !softwareVersionBeta;
    }

    public static String searchString(String chaine) {
        int index;
        char[] ptr = chaine.toCharArray();
        int debut = -1;
        int fin = -1;
        for (index = 0; index < ptr.length && debut == -1; ++index) {
            if (ptr[index] != '\"') continue;
            debut = index + 1;
        }
        if (index < ptr.length) {
            while (index < ptr.length && fin == -1) {
                if (ptr[index] == '\"') {
                    fin = index;
                }
                ++index;
            }
        }
        if (debut != -1 && fin != -1) {
            return chaine.substring(debut, fin);
        }
        return "";
    }

    public static String searchString(String chaine, String search) {
        int position = chaine.indexOf(search);
        if (position != -1) {
            return CoreUtil.searchString(chaine.substring(position));
        }
        return "";
    }

    public static int searchValue(String chaine) {
        int index;
        char[] ptr = chaine.toCharArray();
        int debut = -1;
        int fin = -1;
        for (index = 0; index < ptr.length; ++index) {
            if (!CoreUtil.isNumber(ptr[index])) continue;
            debut = index++;
            break;
        }
        fin = debut;
        if (index < ptr.length) {
            while (index < ptr.length) {
                if (!CoreUtil.isNumber(ptr[index])) {
                    fin = index;
                    break;
                }
                ++index;
            }
        }
        if (debut != -1 && fin != -1) {
            try {
                int value = debut == fin ? Integer.parseInt(chaine.substring(debut)) : Integer.parseInt(chaine.substring(debut, fin));
                return value;
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    public static boolean isNumber(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }
}

