/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.ocas51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.io.ocas51.AbstractOcas51Handler;
import com.dassault.cecilia.io.ocas51.OCas51Handler;
import com.dassault.cecilia.io.ocas51.ResMsgOcas51;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OCas51AttributeHandler
extends AbstractOcas51Handler {
    private DBFolder _attrDefaultFolder;
    private AttrType _type;
    private List<String> _argEnumAttr;
    private String _name;
    private String _version;
    private String _comment;
    private Date _creationDate;
    private Date _updateDate;
    private String _ownerStr;
    private String _releaseStr;
    private String _idExternLaeticia;
    private boolean _isFrozen;
    private static final Map<String, AttrType> MAP_ATTRNAME_TO_ATTRTYPE = new LinkedHashMap<String, AttrType>();

    public OCas51AttributeHandler(OCas51Handler handler, CECFactory factory) {
        super(handler, factory);
        DBFolder dbParent = this.getCECFactory().createFolderDAO().getRootID("ATTRIBUTES");
        DBFolder dbDefault = dbParent.findChild("Default");
        if (dbDefault == null) {
            dbDefault = this.createNewFolder("Default", DBFolder.createFlagsFolder(DBFolder.Family.ATTRIBUTE, (short)0, (short)0), true, dbParent);
        }
        this._attrDefaultFolder = dbDefault;
        if (this._attrDefaultFolder == null) {
            throw new NullPointerException();
        }
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        switch (name) {
            case "DEFINE_ATTRIBUTE": {
                this._type = MAP_ATTRNAME_TO_ATTRTYPE.get(this.getStrFromAttributes(attrs, "TYPE", true));
                if (this._type != AttrType.ENUM) break;
                String enumValues = this.getStrFromAttributes(attrs, "DOMAIN", true);
                this._argEnumAttr = Arrays.asList(enumValues.split(","));
                break;
            }
            case "IDENTIFICATION": {
                String nameAttr = this.getStrFromAttributes(attrs, "NAME", true);
                if (!nameAttr.contains("/")) {
                    this.error(new SAXParseException(ResMsgOcas51.msgFormat("MSG_ERROR_FORMAT_ATTRPARAM", ResMsgOcas51.getString("MSG_ATTRIBUTE"), nameAttr), this.getHandler().getLocator()));
                }
                this._name = this.getValidName(nameAttr.substring(0, nameAttr.lastIndexOf(47)), DBFolder.Family.ATTRIBUTE, name, "NAME");
                this._version = this.checkValidVers(nameAttr.substring(nameAttr.lastIndexOf(47) + 1, nameAttr.length()), name, "NAME");
                this._comment = this.getValidDesc(this.getStrFromAttributes(attrs, "COMMENT", false), true);
                this._idExternLaeticia = this.getStrFromAttributes(attrs, "IDEXTERN_LAETITIA", false);
                this._isFrozen = this.getBooleanFromAttributes(attrs, "FREEZE", true);
                this._creationDate = this.getDateFromAttributes(attrs, "CREATION_DATE", true);
                this._updateDate = this.getDateFromAttributes(attrs, "UPDATE_DATE", true);
                assert (this._version.equals(this.getStrFromAttributes(attrs, "VERSION", false)));
                break;
            }
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        switch (name) {
            case "DEFINE_ATTRIBUTE": {
                assert (this._type != null && this._name != null && this._version != null && (this._type != AttrType.ENUM || this._argEnumAttr != null && !this._argEnumAttr.isEmpty()));
                DBFolder attrNameFolder = this._attrDefaultFolder.findChild(this._name);
                if (attrNameFolder == null) {
                    attrNameFolder = this.createNewFolder(this._name, DBFolder.createFlagsModel(DBFolder.Family.ATTRIBUTE, (short)0, (short)0), true, this._attrDefaultFolder);
                }
                assert (attrNameFolder.findChild(this._version) == null);
                DBFolder attrVersFolder = this.createNewFolder(this._version, DBFolder.createFlagsVersion(DBFolder.Family.ATTRIBUTE, (short)0, (short)0), this._creationDate != null ? this._creationDate : this.getLastUpdateDate(), this._updateDate != null ? this._updateDate : this.getLastUpdateDate(), this._comment, attrNameFolder);
                DBAttrib attribute = new DBAttrib(null);
                attribute.setType(this._type);
                if (this._type == AttrType.ENUM) {
                    attribute.setEnums(this._argEnumAttr);
                }
                this.addObjectFromFolder(attrVersFolder, attribute, this._releaseStr, this._ownerStr, this._idExternLaeticia, this._isFrozen);
                return true;
            }
        }
        return false;
    }

    static {
        MAP_ATTRNAME_TO_ATTRTYPE.put("enum", AttrType.ENUM);
        MAP_ATTRNAME_TO_ATTRTYPE.put("string", AttrType.STRING);
        MAP_ATTRNAME_TO_ATTRTYPE.put("number", AttrType.NUMBER);
        MAP_ATTRNAME_TO_ATTRTYPE.put("alias", AttrType.ALIAS);
    }
}

