/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.table.LeftDotTableCellRenderer;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.dbobj.general.conflict.DBConflictChoice;
import com.dassault.cecilia.dbobj.general.conflict.DBConflictsChoiceDlg;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.io.trees.CmdImportTreeAbstract;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.CaftaHandler;
import com.dassault.cecilia.io.trees.cafta.CaftaImportUtility;
import com.dassault.cecilia.io.trees.cafta.gui.DlgCaftaChooseConflict;
import com.dassault.cecilia.io.trees.cafta.gui.DlgCaftaFilesChooser;
import com.dassault.cecilia.io.trees.cafta.gui.DlgCaftaShowErrors;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;

public class CmdImportCafta
extends CmdImportTreeAbstract {
    private static Logger _LOG = Logger.getLogger(CmdImportCafta.class.getPackage().getName());
    private final String _login = this.getAppl().getDBUser().getLogin();
    public String _nameTree;

    public CmdImportCafta(CeciliaAppl appl, DBFolderTreeEditable owner, DBFolder systemFolder) {
        super(appl, owner, systemFolder);
    }

    @Override
    protected boolean prepareDo() {
        if (!this.verifyLimitNbrTree(1)) {
            return false;
        }
        DlgCaftaFilesChooser dlg = new DlgCaftaFilesChooser(this.getAppl());
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return false;
        }
        String basicEventFilePath = dlg.getBasicEventsFilePath();
        String gatesFilePath = dlg.getGatesFilePath();
        String gatesDescFilePath = dlg.getGatesDescrFilesPath();
        this._nameTree = dlg.getNameTree();
        boolean withGatesDescr = gatesDescFilePath != null && !gatesDescFilePath.isEmpty();
        this._importFiles = new File[withGatesDescr ? 3 : 2];
        this._importFiles[0] = new File(basicEventFilePath);
        this._importFiles[1] = new File(gatesFilePath);
        if (gatesDescFilePath != null && !gatesDescFilePath.isEmpty()) {
            this._importFiles[2] = new File(gatesDescFilePath);
        }
        return true;
    }

    @Override
    protected void doDisplayErrors(List<GeneralError<File>> errors) {
        super.doDisplayErrors(errors);
    }

    @Override
    protected void firstDo() {
        assert (this._importFiles != null || this._importFiles.length != 0);
        try {
            CECFactory factory = this.getAppl().getDAOFactory();
            CaftaHandler caftaHandler = new CaftaHandler(factory, this._importFiles, this._login);
            boolean error = !caftaHandler.treatment(this._errors);
            List<FTEquation> listEquation = caftaHandler.getListFTEquation();
            if (!error && listEquation != null && listEquation.size() > 1) {
                if (!this.verifyLimitNbrTree(listEquation.size())) {
                    return;
                }
                this.addError(null, MsgType.INFO, ResMsgObj.msgFormat("CAFTA_INFO_NUMBER_TREE_IMPORTED", listEquation.size()));
            }
            if (this.withWarnning()) {
                DlgCaftaShowErrors dlg = new DlgCaftaShowErrors((Window)this.getAppl().getTopWindow());
                dlg.setErrors(this._errors);
                dlg.setTitle(ResMsgObj.getString("CAFTA_ERROR_TITLE"));
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    return;
                }
                if (error) {
                    return;
                }
            }
            this._errors.clear();
            if (listEquation == null) {
                return;
            }
            Date dateFiles = caftaHandler.getDate();
            LinkedHashMap<String, DBConflict> map = new LinkedHashMap<String, DBConflict>();
            if (listEquation.size() == 1) {
                String nameTree = this._nameTree;
                if (nameTree == null || nameTree.trim().isEmpty()) {
                    nameTree = listEquation.get(0).getTopEvent().getName();
                }
                if (this._dstFolder.findChild(nameTree) != null) {
                    DlgCaftaChooseConflict conflictChoice = new DlgCaftaChooseConflict(this.getAppl(), nameTree);
                    conflictChoice.setVisible(true);
                    if (!conflictChoice.getResult() || conflictChoice.getDBConflict() == DBConflict.NOTIMPORT) {
                        return;
                    }
                    map.put(this._nameTree, conflictChoice.getDBConflict());
                }
            } else {
                String value = PlugableUtility.getStrOpt(this.getAppl().getPlugable(), GeneralIOPreferencies.PREF_IMPORT_DAG_CONFLICT, "");
                DBConflict dbConflict = DBConflict.readFrom(value, DBConflict.NOTIMPORT);
                ArrayList<DBConflictChoice> filesWithConflict = new ArrayList<DBConflictChoice>();
                for (FTEquation equation : listEquation) {
                    String root = equation.getTopEvent().getName();
                    if (this._dstFolder.findChild(root) == null) continue;
                    DBConflictChoice conflict = new DBConflictChoice(root);
                    conflict.setConflict(dbConflict);
                    filesWithConflict.add(conflict);
                }
                if (!filesWithConflict.isEmpty()) {
                    Window win = JOptionCecilia.getWindowOf(this._ctrlOwner);
                    DBConflictsChoiceDlg<String> dlg = new DBConflictsChoiceDlg<String>((Component)win, filesWithConflict){

                        @Override
                        protected String getNameOfItem() {
                            return ResMsgVoc.getString("VOC_TREE");
                        }

                        @Override
                        protected TableCellRenderer getRendererOfItem() {
                            return new LeftDotTableCellRenderer();
                        }
                    };
                    dlg.setVisible(true);
                    if (!dlg.getResult()) {
                        return;
                    }
                    for (DBConflictChoice conflict : filesWithConflict) {
                        map.put((String)conflict.getItem(), conflict.getConfict());
                    }
                }
            }
            ArrayList<DBFolder> dbVersions = new ArrayList<DBFolder>(listEquation.size());
            for (FTEquation equation : listEquation) {
                DBConflict conflict;
                String nameTree;
                if (listEquation.size() == 1) {
                    nameTree = this._nameTree;
                    if (nameTree == null || nameTree.trim().isEmpty()) {
                        nameTree = equation.getTopEvent().getName();
                    }
                } else {
                    nameTree = equation.getTopEvent().getName();
                }
                if ((conflict = (DBConflict)((Object)map.get(nameTree))) == DBConflict.NOTIMPORT) continue;
                CaftaImportUtility importUtility = new CaftaImportUtility(factory, this.getAppl().getDBUser(), this._dstFolder, nameTree, this.getFile(), equation, dateFiles, conflict);
                importUtility.setErrorMsgs(this._errors);
                DBFolder dbVersion = importUtility.doImportFile();
                dbVersions.add(dbVersion);
            }
            this.finishDo(dbVersions);
        }
        catch (Exception exception) {
            CaftaException error = null;
            if (exception instanceof CaftaException) {
                error = (CaftaException)exception;
            } else if (exception instanceof NullPointerException) {
                error = new CaftaException(null, ResMsgObj.getString("CAFTA_NULL_EXCEPTION"), exception, -1);
            } else if (exception instanceof Exception) {
                error = new CaftaException(null, exception, -1);
            }
            _LOG.log(Level.SEVERE, error.displayMessage());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOwner), error.displayMessage(), ResMsgObj.getString("CAFTA_ERROR_TITLE"), 0);
        }
    }

    private final File getFile() {
        File basicEventsFile = this._importFiles[0];
        File gateFile = this._importFiles[1];
        File gateDescr = null;
        if (this._importFiles.length > 2) {
            gateDescr = this._importFiles[2];
        }
        if (basicEventsFile.getParent() != null && !basicEventsFile.getParent().isEmpty() && basicEventsFile.getParent().equals(gateFile.getParent()) && (gateDescr == null || basicEventsFile.getParent().equals(gateDescr.getParent()))) {
            return basicEventsFile.getParentFile();
        }
        return gateFile;
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_CAFTA");
    }

    @Override
    protected FileFilterExtention createFileFilter() {
        return null;
    }
}

