/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.arborarb;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.lib.util.io.BasicLexer;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class FormatArbConvert {
    CECFactory _cecFactory;
    DBLogs.DBLogsManager _logMng;
    Map<String, FTVariable> _mapDictionary;
    String _arborID;
    String _phaseName;
    double _phaseTime = 1.0;
    String _treeName;
    String _treeProject;
    String _treeSystem;
    private static final String BEGIN_NODE = "#:tclass:trait-event:#";
    private long _autoGenName = 0L;

    public FormatArbConvert(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        this._cecFactory = cecFactory;
        this._logMng = logMng;
        this._mapDictionary = new LinkedHashMap<String, FTVariable>();
    }

    public boolean read(Reader reader) {
        BasicLexer lex = new BasicLexer(reader);
        boolean result = this.read(lex);
        if (!result) {
            int i;
            int line = lex.getLine();
            StringBuffer sb = new StringBuffer(256);
            for (i = 0; i < 32; ++i) {
                lex.ungetChar();
            }
            sb.append("[");
            for (i = 0; i < 32; ++i) {
                sb.append(lex.readChar());
            }
            sb.append("]<.>[");
            for (i = 0; i < 32; ++i) {
                sb.append(lex.readChar());
            }
            sb.append("]");
            this._logMng.addLog(DBLogs.DBLevel.ERROR, "[" + line + "] Syntax error at: " + sb.toString());
        } else {
            FTVariable ftVar = this._mapDictionary.get(this._treeName);
            if (ftVar == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Top Event not found: " + this._treeName);
            } else {
                ftVar.setRoot(true);
            }
        }
        return result && !this._logMng.withLogs(DBLogs.DBLevel.WARNING);
    }

    public String getNameTree() {
        return this._treeName;
    }

    public String getNameSystem() {
        return this._treeSystem;
    }

    public String getNameProject() {
        return this._treeProject;
    }

    public double getMissionTime() {
        return this._phaseTime * 3600.0;
    }

    public Collection<FTVariable> getVariables() {
        return this._mapDictionary.values();
    }

    private String readNextString(BasicLexer lex) {
        int car = lex.readNextChar();
        StringBuffer result = new StringBuffer(64);
        if (car != 34) {
            return null;
        }
        do {
            if ((car = lex.readChar()) == 0) {
                return null;
            }
            if (car == 34) {
                car = lex.readChar();
                if (car == 34) {
                    result.append((char)car);
                    car = 32;
                    continue;
                }
                lex.ungetChar();
                car = 34;
                continue;
            }
            result.append((char)car);
        } while (car != 34);
        return result.toString();
    }

    private String readNextIdentify(BasicLexer lex) {
        char car = lex.readNextChar();
        StringBuffer result = new StringBuffer(64);
        if (car == '|') {
            result.append(car);
            do {
                car = lex.readChar();
                result.append(car);
            } while (car != '|' && car != '\u0000');
            if (result.length() < 2) {
                return null;
            }
            if (result.length() == 2) {
                return "";
            }
            return result.toString();
        }
        boolean first = false;
        while (car >= 'A' && car <= 'Z' || car >= '0' && car <= '9' || first && (car == '_' || car == '-' || car == '+')) {
            first = true;
            result.append(car);
            car = lex.readChar();
        }
        lex.ungetChar();
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private boolean readUntil(BasicLexer lex, String key) {
        int posKey = 0;
        int lenKey = key.length();
        char carKey = key.charAt(posKey);
        char car = lex.readChar();
        while (car != '\u0000') {
            if (carKey == car) {
                if (++posKey == lenKey) {
                    return true;
                }
                carKey = key.charAt(posKey);
            } else if (posKey != 0) {
                carKey = key.charAt(++posKey);
            }
            car = lex.readChar();
        }
        return false;
    }

    private boolean readNode(BasicLexer lex) {
        char nextCar = lex.readNextChar();
        if (nextCar == '\u0000') {
            return true;
        }
        lex.ungetChar();
        if (!this.readUntil(lex, BEGIN_NODE)) {
            return false;
        }
        if (lex.readNextChar() != '[') {
            return false;
        }
        String name = this.readNextIdentify(lex);
        if (name == null) {
            return false;
        }
        String comment = this.readNextString(lex);
        if (comment == null) {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        while ((nextCar = lex.readNextChar()) != ')') {
            if (nextCar == '\u0000') {
                return false;
            }
            lex.ungetChar();
            this.readNextIdentify(lex);
        }
        FTDefinition.Type type = null;
        nextCar = lex.readNextChar();
        if (nextCar == '(') {
            if (lex.readNextChar() != ')') {
                return false;
            }
        } else if (nextCar >= 'a' && nextCar <= 'z') {
            lex.ungetChar();
            String op = lex.readNextIdentify(false);
            if ("ou".equals(op)) {
                type = FTDefinition.Type.OR;
            } else if ("et".equals(op)) {
                type = FTDefinition.Type.AND;
            } else if ("non".equals(op)) {
                type = FTDefinition.Type.NOT;
            } else if ("non-et".equals(op)) {
                type = FTDefinition.Type.NAND;
            } else if ("non-ou".equals(op)) {
                type = FTDefinition.Type.NOR;
            } else if ("different".equals(op)) {
                type = FTDefinition.Type.XOR;
            } else if ("egal".equals(op)) {
                type = FTDefinition.Type.NXOR;
            }
            if (type == null) {
                return false;
            }
        } else {
            return false;
        }
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<Boolean> negs = new ArrayList<Boolean>();
        if (lex.readNextChar() != '(') {
            return false;
        }
        while ((nextCar = lex.readNextChar()) != ')') {
            if (nextCar == '\u0000') {
                return false;
            }
            if (nextCar == '-') {
                negs.add(true);
            } else {
                lex.ungetChar();
                negs.add(false);
            }
            String arg = this.readNextIdentify(lex);
            if (arg == null) {
                return false;
            }
            args.add(arg);
        }
        double value = Double.NaN;
        nextCar = lex.readNextChar();
        if (nextCar == '(') {
            if (lex.readNextChar() != ')') {
                return false;
            }
        } else {
            lex.ungetChar();
            value = lex.readNextNumber();
            if (Double.isNaN(value)) {
                return false;
            }
        }
        if ((nextCar = lex.readNextChar()) == '(') {
            if (lex.readNextChar() != ')') {
                return false;
            }
        } else {
            lex.ungetChar();
            if (Double.isNaN(lex.readNextNumber())) {
                return false;
            }
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!this.readUntil(lex, ")")) {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!this.readUntil(lex, ")")) {
            return false;
        }
        double periodicity = Double.NaN;
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (lex.readNextChar() != ')') {
            lex.ungetChar();
            periodicity = lex.readNextNumber();
            if (Double.isNaN(periodicity)) {
                return false;
            }
            if (!this.readUntil(lex, ")")) {
                return false;
            }
        }
        double exposition = Double.NaN;
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (lex.readNextChar() != ')') {
            lex.ungetChar();
            exposition = lex.readNextNumber();
            if (Double.isNaN(exposition)) {
                return false;
            }
            if (!this.readUntil(lex, ")")) {
                return false;
            }
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!this.readUntil(lex, ")")) {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!this.readUntil(lex, ")")) {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!this.readUntil(lex, ")")) {
            return false;
        }
        if (lex.readNextChar() != ']') {
            return false;
        }
        if (type != null) {
            if (args.size() == 0) {
                return false;
            }
            if (negs.size() != args.size()) {
                return false;
            }
            if (!Double.isNaN(periodicity)) {
                return false;
            }
            if (!Double.isNaN(exposition)) {
                return false;
            }
        } else if (args.size() != 0) {
            return false;
        }
        FTVariable ftVar = this.findOrCreateVariable(name);
        ftVar.setLabel(comment);
        if (type != null) {
            ArrayList<FTVariable> children = new ArrayList<FTVariable>();
            int nbrArgs = args.size();
            for (int i = 0; i < nbrArgs; ++i) {
                FTVariable ftChild = this.findOrCreateVariable((String)args.get(i));
                if (((Boolean)negs.get(i)).booleanValue()) {
                    FTVariable ftNeg = this.findOrCreateVariable(this.getGeneratedName());
                    ftNeg.setDefinition(new FTDefinition(FTDefinition.Type.NOT, ftChild));
                    ftChild = ftNeg;
                }
                children.add(ftChild);
            }
            ftVar.setDefinition(new FTDefinition(type, children));
        } else {
            FTEvent ftEvent = new FTEvent();
            if (!Double.isNaN(value)) {
                Law law = this._cecFactory.getLawManager().createLaw(0);
                law.setParamAt(0, new ParamValue(TypeParam.RATE, value));
                ftEvent.setOccurrence(law);
            }
            if (!Double.isNaN(periodicity)) {
                ftEvent.setInspected(new ParamValue(TypeParam.DELAY, periodicity));
            } else if (!Double.isNaN(exposition)) {
                ftEvent.setInflightTested(new ParamValue(TypeParam.DELAY, exposition));
            }
            ftVar.setEvent(ftEvent);
        }
        return true;
    }

    private String getGeneratedName() {
        String name = null;
        while (this._autoGenName < Long.MAX_VALUE && this._mapDictionary.get(name = "AUTO_NOT_" + this._autoGenName++) != null) {
        }
        return name;
    }

    private FTVariable findOrCreateVariable(String name) {
        FTVariable ftVar = this._mapDictionary.get(name);
        if (ftVar == null) {
            ftVar = new FTVariable().setName(name);
            this._mapDictionary.put(name, ftVar);
        }
        return ftVar;
    }

    private boolean readHeader(BasicLexer lex) {
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!lex.readNextIdentify(false).equals("phase-vol")) {
            return false;
        }
        if (lex.readNextChar() != '.') {
            return false;
        }
        this._phaseName = this.readNextString(lex);
        if (this._phaseName == null) {
            return false;
        }
        if (lex.readNextChar() != ')') {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!lex.readNextIdentify(false).equals("duree-phase")) {
            return false;
        }
        if (lex.readNextChar() != '.') {
            return false;
        }
        this._phaseTime = lex.readNextNumber();
        if (Double.isNaN(this._phaseTime)) {
            return false;
        }
        if (lex.readNextChar() != ')') {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!lex.readNextIdentify(false).equals("coef")) {
            return false;
        }
        if (lex.readNextChar() != '.') {
            return false;
        }
        if (Double.isNaN(lex.readNextNumber())) {
            return false;
        }
        if (lex.readNextChar() != ')') {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!lex.readNextIdentify(false).equals("nom")) {
            return false;
        }
        if (lex.readNextChar() != '.') {
            return false;
        }
        this._treeName = this.readNextIdentify(lex);
        if (this._treeName == null) {
            return false;
        }
        if (lex.readNextChar() != ')') {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!lex.readNextIdentify(false).equals("projet")) {
            return false;
        }
        if (lex.readNextChar() != '.') {
            return false;
        }
        this._treeProject = this.readNextIdentify(lex);
        if (this._treeProject == null) {
            return false;
        }
        if (lex.readNextChar() != ')') {
            return false;
        }
        if (lex.readNextChar() != '(') {
            return false;
        }
        if (!lex.readNextIdentify(false).equals("systeme")) {
            return false;
        }
        if (lex.readNextChar() != '.') {
            return false;
        }
        this._treeSystem = this.readNextIdentify(lex);
        if (this._treeSystem == null) {
            return false;
        }
        if (lex.readNextChar() != ')') {
            return false;
        }
        if (lex.readLine().length() == 0) {
            return false;
        }
        return lex.readLine().length() != 0;
    }

    private boolean read(BasicLexer lex) {
        this._arborID = lex.readNextString();
        if (this._arborID == null || this._arborID.length() == 0) {
            return false;
        }
        if (!this.readHeader(lex)) {
            return false;
        }
        char nextCar = lex.readNextChar();
        while (nextCar != '\u0000') {
            lex.ungetChar();
            if (!this.readNode(lex)) {
                return false;
            }
            nextCar = lex.readNextChar();
        }
        return true;
    }
}

