/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees.cafta.gui;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.io.trees.cafta.AbstractCaftaReader;
import com.dassault.cecilia.io.trees.cafta.CaftaConstant;
import com.dassault.cecilia.io.trees.cafta.CaftaException;
import com.dassault.cecilia.io.trees.cafta.CaftaHandler;
import com.dassault.cecilia.io.trees.cafta.ResMsgCafta;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgCaftaFilesChooser
extends JDialogCecilia
implements CaftaConstant {
    private final CAppl _cAppl;
    private JTextField _basicEventsJTF;
    private JTextField _gatesReportJTF;
    private JTextField _gatesDescrJTF;
    private JLabel _nameTree;
    private JTextField _nameTreeJTF;
    private boolean _isMultiTree;

    public DlgCaftaFilesChooser(CAppl cAppl) {
        super(cAppl.getTopWindow(), ResMsgCafta.getString("DLG_IMPORT_CAFTA_TITLE"), true);
        this._cAppl = cAppl;
        JPanel panel = this.createFileInputsPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(true), "South");
        this.init();
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getParent()));
    }

    public final String getBasicEventsFilePath() {
        assert (this._basicEventsJTF != null);
        return this._basicEventsJTF.getText();
    }

    public final String getGatesFilePath() {
        assert (this._gatesReportJTF != null);
        return this._gatesReportJTF.getText();
    }

    public final String getGatesDescrFilesPath() {
        assert (this._gatesDescrJTF != null);
        return this._gatesDescrJTF.getText();
    }

    public final String getNameTree() {
        assert (this._nameTreeJTF != null || this._isMultiTree);
        return this._nameTreeJTF.getText();
    }

    private JPanel createFileInputsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JLabel basicEventsLbl = new JLabel(ResMsgCafta.getString("DLG_IMPORT_CAFTA_BASIC_EVENT_LABEL"));
        basicEventsLbl.setToolTipText(ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_FILES_TOOLTIP", "Basic Event and Type Code Data Report"));
        this._basicEventsJTF = new JTextField(22);
        JButton basicEventsBtn = new JButton("...");
        basicEventsBtn.setPreferredSize(new Dimension(26, 26));
        basicEventsBtn.addActionListener(this.actionOpenFileCafta((Window)this.getParent(), this._basicEventsJTF, 0));
        JLabel gatesReportLbl = new JLabel(ResMsgCafta.getString("DLG_IMPORT_CAFTA_GATES_LABEL"));
        gatesReportLbl.setToolTipText(ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_FILES_TOOLTIP", "Fault Tree List Report (Depth First)"));
        this._gatesReportJTF = new JTextField(22);
        JButton gatesReportBtn = new JButton("...");
        gatesReportBtn.setPreferredSize(new Dimension(26, 26));
        gatesReportBtn.addActionListener(this.actionOpenFileCafta((Window)this.getParent(), this._gatesReportJTF, 1));
        JLabel gatesDescrLbl = new JLabel(ResMsgCafta.getString("DLG_IMPORT_CAFTA_GATES_DESC_LABEL"));
        gatesDescrLbl.setToolTipText(ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_FILES_TOOLTIP", "Gate Description Report"));
        this._gatesDescrJTF = new JTextField(22);
        JButton gatesDescrBtn = new JButton("...");
        gatesDescrBtn.setPreferredSize(new Dimension(26, 26));
        gatesDescrBtn.addActionListener(this.actionOpenFileCafta((Window)this.getParent(), this._gatesDescrJTF, 2));
        this._nameTree = new JLabel(ResMsgCafta.getString("DLG_IMPORT_CAFTA_NAME_TREE_LABEL"));
        this._nameTreeJTF = new JTextField(22);
        this._nameTree.setToolTipText(ResMsgCafta.getString("DLG_IMPORT_CAFTA_NAME_TREE_TOOLTIP"));
        int x = 0;
        int y = 0;
        panel.add((Component)gatesReportLbl, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._gatesReportJTF, new GridBagConstraints(x++, y, 1, 1, 100.0, 100.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)gatesReportBtn, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        x = 0;
        panel.add((Component)basicEventsLbl, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._basicEventsJTF, new GridBagConstraints(x++, y, 1, 1, 100.0, 100.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)basicEventsBtn, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        x = 0;
        panel.add((Component)gatesDescrLbl, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._gatesDescrJTF, new GridBagConstraints(x++, y, 1, 1, 100.0, 100.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)gatesDescrBtn, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        x = 0;
        panel.add((Component)this._nameTree, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)this._nameTreeJTF, new GridBagConstraints(x++, y, 1, 1, 100.0, 100.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        return panel;
    }

    @Override
    protected boolean verifyParameters() {
        int value;
        boolean sameDirectory;
        int errorChar;
        assert (this._basicEventsJTF != null && this._gatesDescrJTF != null && this._gatesReportJTF != null);
        String gateInputsText = this._gatesReportJTF.getText();
        String basicEventText = this._basicEventsJTF.getText();
        if (gateInputsText.isEmpty() || basicEventText.isEmpty()) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_EMPTY_FIELD", gateInputsText.isEmpty() ? ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES") : ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_EVENTS")), "Import CAFTA", 0);
            return false;
        }
        File fBE = new File(this._basicEventsJTF.getText());
        File fG = new File(this._gatesReportJTF.getText());
        if (!fBE.exists() || !fG.exists()) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_NOT_EXISTS", !fG.exists() ? ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES") : ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_EVENTS"), !fG.exists() ? fG.getAbsolutePath() : fBE.getAbsolutePath()), "Import CAFTA", 0);
            return false;
        }
        if (fBE.isDirectory() || fG.isDirectory()) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_IS_DIRECTORY", fG.isDirectory() ? ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES") : ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_EVENTS"), fG.isDirectory() ? fG.getAbsolutePath() : fBE.getAbsolutePath()), "Import CAFTA", 0);
            return false;
        }
        if (!this.isCAFTAFile(fBE, 0)) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT", ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_EVENTS"), "Basic Event and Type Code Data Report", this.getFirstLine(fBE, 0)), "Import CAFTA", 0);
            return false;
        }
        if (!this.isCAFTAFile(fG, 1)) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT", ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES"), "Fault Tree List Report (Depth First)", this.getFirstLine(fG, 1)), "Import CAFTA", 0);
            return false;
        }
        String treeName = this._nameTreeJTF.getText();
        if (treeName != null && !treeName.isEmpty() && !this._isMultiTree && (errorChar = DBFactory.verifyName(treeName)) != 0) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_NAME_TREE", Character.valueOf((char)errorChar)), "Import CAFTA", 0);
            return false;
        }
        String gateDescrFilePath = this._gatesDescrJTF.getText();
        if (gateDescrFilePath == null || gateDescrFilePath.isEmpty()) {
            return true;
        }
        File fDG = new File(gateDescrFilePath);
        if (!fDG.exists()) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_NOT_EXISTS", ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES_DESC")), "Import CAFTA", 0);
            return false;
        }
        if (fDG.isDirectory()) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_IS_DIRECTORY", ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES_DESC")), "Import CAFTA", 0);
        }
        if (!this.isCAFTAFile(fDG, 2)) {
            JOptionPane.showMessageDialog(this, ResMsgCafta.msgFormat("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT", ResMsgCafta.getString("DLG_IMPORT_CAFTA_ERROR_WRONG_FORMAT_GATES_DESC"), "Fault Tree List Report (Depth First)", this.getFirstLine(fDG, 2)), "Import CAFTA", 0);
            return false;
        }
        boolean bl = sameDirectory = fBE.getParentFile().equals(fG.getParentFile()) && fBE.getParentFile().equals(fG.getParentFile());
        return sameDirectory || (value = JOptionPane.showConfirmDialog(this, ResMsgCafta.getString("DLG_IMPORT_CAFTA_WARNING_DIFFERENT_DIRECTORY"), "Import CAFTA", 2)) != 2 && value != -1 && value != 1;
    }

    private final ActionListener actionOpenFileCafta(final Window applWindow, final JTextField currentJTF, final int ID) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String rootName;
                JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
                fileChooser.setFileFilter(new FileFilterExtention(ResMsgCafta.getString("DLG_IMPORT_CAFTA_TITLE"), "txt"));
                fileChooser.setCurrentDirectory(new File(PlugableUtility.getStrOpt(((CeciliaAppl)DlgCaftaFilesChooser.this._cAppl).getPlugable(), "plugable.option.path", ".")));
                fileChooser.showOpenDialog(applWindow);
                File f = fileChooser.getSelectedFile();
                if (f == null) {
                    return;
                }
                ((CeciliaAppl)DlgCaftaFilesChooser.this._cAppl).getPlugable().setOption("plugable.option.path", f.getAbsolutePath());
                currentJTF.setText(f.getAbsolutePath());
                if (!DlgCaftaFilesChooser.this.isCAFTAFile(f, ID)) {
                    return;
                }
                if (ID == 1 && (rootName = DlgCaftaFilesChooser.this.getRootFromGatesFile(f.getAbsolutePath())) != null) {
                    DlgCaftaFilesChooser.this._nameTreeJTF.setText(rootName);
                }
                if (DlgCaftaFilesChooser.this._gatesReportJTF.getText() != null && !DlgCaftaFilesChooser.this._gatesReportJTF.getText().isEmpty()) {
                    DlgCaftaFilesChooser.this._isMultiTree = DlgCaftaFilesChooser.this.isGatesMultipleRoots(DlgCaftaFilesChooser.this._gatesReportJTF.getText());
                    DlgCaftaFilesChooser.this._nameTreeJTF.setEnabled(!DlgCaftaFilesChooser.this._isMultiTree);
                    DlgCaftaFilesChooser.this._nameTree.setEnabled(!DlgCaftaFilesChooser.this._isMultiTree);
                    if (DlgCaftaFilesChooser.this._isMultiTree) {
                        DlgCaftaFilesChooser.this._nameTreeJTF.setText(ResMsgCafta.getString("DLG_IMPORT_CAFTA_MULTI_ROOT"));
                    }
                }
                if (!((ID != 0 || DlgCaftaFilesChooser.this._gatesDescrJTF.getText().isEmpty() && DlgCaftaFilesChooser.this._gatesReportJTF.getText().isEmpty()) && (ID != 1 || DlgCaftaFilesChooser.this._gatesDescrJTF.getText().isEmpty() && DlgCaftaFilesChooser.this._basicEventsJTF.getText().isEmpty()) && (ID != 2 || DlgCaftaFilesChooser.this._basicEventsJTF.getText().isEmpty() && DlgCaftaFilesChooser.this._gatesReportJTF.getText().isEmpty()))) {
                    return;
                }
                File parentFile = f.getParentFile();
                if (parentFile == null) {
                    return;
                }
                assert (parentFile.isDirectory());
                int ID1 = ID == 0 ? 2 : 0;
                int ID2 = ID == 1 ? 2 : 1;
                for (File child : parentFile.listFiles()) {
                    if (ID1 != -1 && DlgCaftaFilesChooser.this.isCAFTAFile(child, ID1)) {
                        if (ID1 == 0) {
                            DlgCaftaFilesChooser.this._basicEventsJTF.setText(child.getAbsolutePath());
                        } else {
                            DlgCaftaFilesChooser.this._gatesDescrJTF.setText(child.getAbsolutePath());
                        }
                        ID1 = -1;
                        continue;
                    }
                    if (ID2 == -1 || !DlgCaftaFilesChooser.this.isCAFTAFile(child, ID2)) continue;
                    if (ID2 == 1) {
                        DlgCaftaFilesChooser.this._gatesReportJTF.setText(child.getAbsolutePath());
                        String rootName2 = DlgCaftaFilesChooser.this.getRootFromGatesFile(child.getAbsolutePath());
                        if (rootName2 != null) {
                            DlgCaftaFilesChooser.this._nameTreeJTF.setText(rootName2);
                        }
                    } else {
                        DlgCaftaFilesChooser.this._gatesDescrJTF.setText(child.getAbsolutePath());
                    }
                    ID2 = -1;
                }
            }
        };
    }

    private final boolean isCAFTAFile(File f, int ID) {
        assert (ID != -1);
        if (f == null || f.isDirectory() || !f.getAbsolutePath().toLowerCase().endsWith(".txt")) {
            return false;
        }
        String firstLine = this.getFirstLine(f, ID);
        if (ID == 0) {
            return firstLine.equals("Basic Event and Type Code Data Report");
        }
        if (ID == 1) {
            return firstLine.equals("Fault Tree List Report (Depth First)");
        }
        if (ID == 2) {
            return firstLine.equals("Gate Description Report");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFirstLine(File f, int ID) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f));
            String firstLine = reader.readLine();
            if (ID == 0) {
                String string = firstLine;
                return string;
            }
            if (ID == 1) {
                String string = firstLine;
                return string;
            }
            if (ID == 2) {
                String string = firstLine;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException err) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException err2) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getRootFromGatesFile(String gatesFilePath) {
        File gateFile = new File(gatesFilePath);
        if (gateFile == null || !gateFile.exists() || !gateFile.isFile()) {
            return null;
        }
        if (!this.isCAFTAFile(gateFile, 1)) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(gateFile));
            int i = 0;
            while (i++ < 5) {
                reader.readLine();
            }
            String firstLine = reader.readLine();
            String[] split = firstLine.split("\t");
            assert (split != null && split.length != 0);
            String gateName = split[0];
            if (DBFactory.verifyName(gateName) == 0) {
                String string = gateName;
                return string;
            }
            String string = DBFactory.convertName(gateName);
            return string;
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public boolean isGatesMultipleRoots(String gateFilePath) {
        File gateFile = new File(gateFilePath);
        if (gateFile == null || !gateFile.isFile() || !this.isCAFTAFile(gateFile, 1)) {
            return false;
        }
        GateFileParser gateParser = new GateFileParser(gateFile);
        try {
            gateParser.treatFile();
        }
        catch (CaftaException err) {
            return false;
        }
        return gateParser.isMultipleRoots();
    }

    private static final class GateFileParser
    extends AbstractCaftaReader {
        private final Set<String> _roots = new HashSet<String>();

        public GateFileParser(File gateFile) {
            super(gateFile);
        }

        public final boolean isMultipleRoots() {
            return this._roots.size() > 1;
        }

        @Override
        protected void readFile(List<String> headers, LineNumberReader reader) throws IOException, CaftaException {
            String line;
            HashSet<String> children = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) {
                    CaftaHandler._LOG.log(Level.FINEST, ResMsgCafta.getString("CAFTA_IMPORT_END_GATES_INPUT"));
                    break;
                }
                String[] splitLine = line.split("\t");
                if (splitLine == null || splitLine.length == 0) continue;
                int lineIdx = reader.getLineNumber();
                String gateName = this.getStrFromArray(null, splitLine, headers.indexOf("Gate"), lineIdx, headers, true);
                if (gateName == null || gateName.isEmpty()) continue;
                this._roots.add(gateName);
                int indexInputs = this.getIdxHeader(headers, "Inputs", "Inputs...");
                while (indexInputs != splitLine.length) {
                    children.add(splitLine[indexInputs++]);
                }
            }
            this._roots.removeAll(children);
        }

        @Override
        protected String getHeaderLine() {
            return "Fault Tree List Report (Depth First)";
        }

        @Override
        protected List<String> missingHeaders(List<String> headers) {
            return null;
        }

        @Override
        protected CaftaException.OriginTypeFile getOriginException() {
            return null;
        }
    }
}

