/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.io.xml6.PerformExportXML6;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasTranslate;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class AnonymizeExportXML6
extends PerformExportXML6 {
    private static Logger _LOG = Logger.getLogger(PerformExportXML6.class.getName());
    ConvertHelper _helperFolder = new ConvertHelper("path");
    ConvertHelper _helperFct = new ConvertHelper("fct");
    ConvertHelper _helperSub = new ConvertHelper("sub");
    ConvertHelper _helperVar = new ConvertHelper("var");
    ConvertHelper _helperEvent = new ConvertHelper("evt");
    ConvertHelper _helperField = new ConvertHelper("field");
    ConvertHelper _helperEnum = new ConvertHelper("enum");
    ConvertHelper _helperAttr = new ConvertHelper("attr");
    ConvertHelper _helperSheet = new ConvertHelper("sheet");
    Set<Long> _attributesEnumID = new HashSet<Long>();
    DAOFactory _daoFactory;
    DBObjModel _txtDBModel = null;
    String _txtElement = null;
    StringBuilder _txtBuffer = null;
    boolean _bReadSync = false;
    OcasAnonymize _parser = new OcasAnonymize();
    Set<String> _currentVariables = new HashSet<String>();
    String _currentFct = null;
    private Map<String, Pattern> _mapPattern = new HashMap<String, Pattern>();

    public AnonymizeExportXML6(DAOFactory daoFactory, Set<DBFolder> foldersToExport) {
        super(daoFactory, foldersToExport);
        this._daoFactory = daoFactory;
    }

    @Override
    protected Appendable exportFolder(Writer out, DBFolder dbFolder) throws IOException {
        if (dbFolder.isVersion()) {
            return super.exportFolder(out, dbFolder);
        }
        if (dbFolder.isModel() && dbFolder.getFamily() == DBFolder.Family.OPERATOR) {
            return DBObjectXmlUtility.appendXML(out, this._helperFct.findOrCreate(dbFolder.getName()));
        }
        return DBObjectXmlUtility.appendXML(out, this._helperFolder.findOrCreate(dbFolder.getName()));
    }

    @Override
    protected void exportLabel(Writer out, DBFolder dbCurr) throws IOException {
    }

    @Override
    protected void exportDate(Writer out, Date date, String attrDate) throws IOException {
        if (date != null) {
            out.append(" ").append(attrDate).append("='").append(Long.toString(new Date().getTime())).append("'");
        }
    }

    @Override
    protected void exportProperty(Writer out, DBObjProperty dbProp, String indent) throws IOException {
        if (dbProp.getName().equals("object.creator")) {
            return;
        }
        super.exportProperty(out, dbProp, indent);
    }

    @Override
    protected boolean canExportInBase64(DBObjModel dbModel) {
        return dbModel.getNature().equals("image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportModel_ZIP(Writer out, DBObjModel dbModel, String indent) throws IOException {
        if (!dbModel.getNature().equals("image")) {
            super.exportModel_ZIP(out, dbModel, indent);
            return;
        }
        File tmpFile = null;
        try {
            ImageIcon icon = DBIcon.readImage(dbModel.getObject().getFolder(), this._daoFactory);
            Graphics2D graph = null;
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage image = new BufferedImage(width, height, 1);
            graph = image.createGraphics();
            graph.setClip(0, 0, width, height);
            graph.setColor(Color.white);
            graph.fillRect(0, 0, width, height);
            graph.setColor(Color.black);
            graph.drawRect(0, 0, width - 1, height - 1);
            String ext = dbModel.getFormat().toLowerCase();
            tmpFile = File.createTempFile("Anonymise", "." + ext);
            ImageIO.write((RenderedImage)image, ext, tmpFile);
            long length = tmpFile.length();
            byte[] bytes = new byte[(int)length];
            try (InputStream in = null;){
                in = new BufferedInputStream(new FileInputStream(tmpFile));
                in.read(bytes);
            }
            this.exportModel_ZIP(out, new ByteArrayInputStream(bytes));
        }
        catch (Throwable th) {
            _LOG.log(Level.INFO, "Probleme lors de la sauvegarde de l'image : " + dbModel.getObject().getFolder().getRefPath(), th);
        }
        finally {
            if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    @Override
    protected void exportCRCModel(Writer out, DBObjModel dbModel) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportModel_ZML(Writer out, DBObjModel dbModel, String indent, boolean inflater) throws IOException {
        InputStream istream = this._daoObjModel.getBinaryStream(dbModel);
        BufferedReader input = null;
        try {
            String line;
            if (inflater) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            input = new BufferedReader(new InputStreamReader(istream, StandardCharsets.UTF_8));
            this._bReadSync = false;
            indent = indent + "  ";
            while ((line = input.readLine()) != null) {
                this.exportLine_ZML(out, line, dbModel, indent);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    _LOG.log(Level.FINE, "Exception during close binary stream : " + dbModel);
                }
            }
        }
    }

    private boolean txtStart(String line, String code, int trimLen, Writer out, String indent) throws IOException {
        this._txtElement = code;
        this._txtBuffer = new StringBuilder();
        out.append(indent).append("<").append(this._txtElement).append(">");
        int startTxt = line.length() - trimLen + code.length() + 2;
        int pos = line.indexOf("</" + this._txtElement + ">");
        if (pos == -1) {
            this._txtBuffer.append(line.substring(startTxt)).append("\n");
        } else {
            this._txtBuffer.append(line.substring(startTxt, pos));
            this.exportTxt_ZML(out, this._txtElement, this._txtBuffer.toString());
            out.append("</").append(this._txtElement).append(">\n");
            this._txtElement = null;
            this._txtBuffer = null;
            this._txtDBModel = null;
        }
        return true;
    }

    private boolean txtTreatLine(String line, Writer out, String indent) throws IOException {
        int pos = line.indexOf("</" + this._txtElement + ">");
        if (pos == -1) {
            this._txtBuffer.append(line).append("\n");
        } else {
            this._txtBuffer.append(line.substring(0, pos));
            this.exportTxt_ZML(out, this._txtElement, this._txtBuffer.toString());
            out.append("</").append(this._txtElement).append(">\n");
            this._txtElement = null;
            this._txtBuffer = null;
            this._txtDBModel = null;
        }
        return true;
    }

    private void exportTxt_ZML(Writer out, String code, String txt) throws IOException {
        DBFolder dbFolder;
        if (code.equals("label")) {
            out.append("...");
            return;
        }
        if (code.equals("alta.code") && this._txtDBModel != null && this._txtDBModel.getObject() != null && (dbFolder = this._txtDBModel.getObject().getFolder()) != null) {
            switch (dbFolder.getFamily()) {
                case OPERATOR: {
                    txt = StringUtilities.convertFromXML((String)txt);
                    this._parser.restart(new StringReader(txt), 258);
                    this._parser.run();
                    out.append(StringUtilities.convertToXML((String)this._parser.getCode()));
                    return;
                }
                case PROJECT: {
                    if (dbFolder.getFamilyFlag() != 1) break;
                }
                case COMPONENT: 
                case EQUIPMENT: {
                    txt = StringUtilities.convertFromXML((String)txt);
                    this._parser.restart(new StringReader(txt), 257);
                    this._parser.run();
                    out.append(StringUtilities.convertToXML((String)this._parser.getCode()));
                    return;
                }
            }
        }
        out.append(txt);
        txt = StringUtilities.convertFromXML((String)txt);
        this._parser.restart(new StringReader(txt), 257);
        this._parser.run();
        out.append(StringUtilities.convertToXML((String)this._parser.getCode()));
    }

    private boolean exportLine_ZML(Writer out, String line, DBObjModel dbModel, String indent) throws IOException {
        if (this._txtElement != null) {
            return this.txtTreatLine(line, out, indent);
        }
        String trim = line.trim();
        if (trim.startsWith("<?")) {
            return true;
        }
        if (trim.startsWith("<alta.code>")) {
            this._txtDBModel = dbModel;
            return this.txtStart(line, "alta.code", trim.length(), out, indent + line.substring(0, line.length() - trim.length()));
        }
        if (trim.startsWith("<label>")) {
            return this.txtStart(line, "label", trim.length(), out, indent + line.substring(0, line.length() - trim.length()));
        }
        if (trim.startsWith("<cec.attribute ") && trim.contains("type='enum'")) {
            this._attributesEnumID.add(dbModel.getObject().getFolder().getID());
        } else if (trim.startsWith("<attribute.enum ")) {
            line = this.extractAndReplace(line, "name", this._helperAttr);
        } else if (trim.startsWith("<attribute ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
            line = this.extractAndReplaceAttrEnum(line);
        } else if (trim.startsWith("<enum.field ")) {
            line = this.extractAndReplace(line, "value", this._helperEnum);
        } else if (trim.startsWith("<link.field ")) {
            line = this.extractAndReplace(line, "name", this._helperField);
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<cec.operator ")) {
            this._currentVariables.clear();
            this._currentFct = dbModel.getObject().getFolder().getParent().getName();
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("</cec.operator>")) {
            this._currentFct = null;
        } else if (trim.startsWith("<cec.component ")) {
            this._currentVariables.clear();
        } else if (trim.startsWith("<cec.equipment ")) {
            this._currentVariables.clear();
            this._bReadSync = true;
        } else if (trim.startsWith("</cec.equipment>")) {
            this._bReadSync = false;
        } else if (trim.startsWith("<cec.mbsa")) {
            this._currentVariables.clear();
            this._bReadSync = true;
        } else if (trim.startsWith("</cec.mbsa>")) {
            this._bReadSync = false;
        } else if (trim.startsWith("<alta.icon ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.simul ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.flow ")) {
            this._currentVariables.add(this.extract(line, "name"));
            line = this.extractAndReplace(line, "name", this._helperVar);
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.state ")) {
            this._currentVariables.add(this.extract(line, "name"));
            line = this.extractAndReplace(line, "name", this._helperVar);
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
            line = this.extractAndReplaceEnumValue(line, "value", this._helperEnum);
        } else if (trim.startsWith("<alta.event ")) {
            line = this._bReadSync ? this.extractAndReplaceSubPath(line, "name", this._helperEvent) : this.extractAndReplace(line, "name", this._helperEvent);
        } else if (trim.startsWith("<parameter.ref ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<frb ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<attribute ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.operator.ref ")) {
            line = this.extractAndReplace(line, "name", this._helperFct);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder, this._helperFct);
        } else if (trim.startsWith("<alta.sub ")) {
            line = this.extractAndReplace(line, "name", this._helperSub);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.link ")) {
            line = this.extractAndReplaceLink(line, "from");
            line = this.extractAndReplaceLink(line, "to");
        } else if (trim.startsWith("<alta.sync ")) {
            line = this.extractAndReplace(line, "name", this._helperEvent);
        } else if (trim.startsWith("<alga.sheet ")) {
            line = this.extractAndReplace(line, "name", this._helperSheet);
        } else if (trim.startsWith("<alga.node ")) {
            line = this.extractAndReplace(line, "name", this._helperSub);
        } else if (trim.startsWith("<alga.port ")) {
            line = this.extractAndReplace(line, "name", this._helperVar);
        } else if (trim.startsWith("<alga.icon ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.colors.type ")) {
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
        } else if (trim.startsWith("<alta.colors.case ")) {
            line = this.extractAndReplaceEnumValue(line, "value", this._helperEnum);
        }
        if (trim.startsWith("<")) {
            out.append(indent);
        }
        out.append(line).append("\n");
        return true;
    }

    private Pattern createPattern(String name) {
        Pattern result = this._mapPattern.get(name);
        if (result == null) {
            result = Pattern.compile(" " + name + "='([^']*)'");
            this._mapPattern.put(name, result);
        }
        return result;
    }

    private String extract(String line, String name) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    private String extractAndReplace(String line, String name, ConvertHelper helper) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        line = matcher.replaceFirst(" " + name + "='" + helper.findOrCreate(value) + "'");
        return line;
    }

    private String extractAndReplaceTypeEnum(String line, String name, ConvertHelper helper) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        if (value.startsWith("{") && value.endsWith("}")) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("{");
            StringTokenizer token = new StringTokenizer(value, "{,}");
            while (token.hasMoreTokens()) {
                buffer.append(helper.findOrCreate(token.nextToken()));
                if (!token.hasMoreTokens()) continue;
                buffer.append(",");
            }
            buffer.append("}");
            line = matcher.replaceFirst(" " + name + "='" + buffer.toString() + "'");
        }
        return line;
    }

    private String extractAndReplaceEnumValue(String line, String name, ConvertHelper helper) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        if ((value = value.trim()).equals("true")) {
            return line;
        }
        if (value.equals("false")) {
            return line;
        }
        char first = value.charAt(0);
        if (Character.isDigit(first)) {
            return line;
        }
        if (first == '.') {
            return line;
        }
        return matcher.replaceFirst(" " + name + "='" + helper.findOrCreate(value) + "'");
    }

    private String extractAndReplaceAttrEnum(String line) {
        Pattern pattern = this.createPattern("refID");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        try {
            long refId = Long.parseLong(value);
            if (!this._attributesEnumID.contains(refId)) {
                return line;
            }
        }
        catch (Exception e) {
            _LOG.fine("Exception lors de la lecture d'un refID: " + e.getMessage());
            return line;
        }
        return this.extractAndReplace(line, "value", this._helperAttr);
    }

    private String extractAndReplaceRefPath(String line, String name, ConvertHelper helper) {
        return this.extractAndReplaceRefPath(line, name, helper, helper);
    }

    private String extractAndReplaceRefPath(String line, String name, ConvertHelper helper, ConvertHelper helperLast) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        int pos = value.lastIndexOf(";");
        if (pos == -1) {
            return line;
        }
        String version = value.substring(pos);
        value = value.substring(0, pos);
        StringBuilder buffer = new StringBuilder();
        StringTokenizer token = new StringTokenizer(value, "/;");
        while (token.hasMoreTokens()) {
            String path = token.nextToken();
            if (token.hasMoreTokens()) {
                buffer.append(helper.findOrCreate(path));
                buffer.append("/");
                continue;
            }
            buffer.append(helperLast.findOrCreate(path));
        }
        return matcher.replaceFirst(" " + name + "='" + buffer.append(version).toString() + "'");
    }

    private String extractAndReplaceSubPath(String line, String name, ConvertHelper helperEnd) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(value, ".");
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                buffer.append(this._helperSub.findOrCreate(element)).append(".");
                continue;
            }
            buffer.append(helperEnd.findOrCreate(element));
        }
        return matcher.replaceFirst(" " + name + "='" + buffer.toString() + "'");
    }

    private String extractAndReplaceLink(String line, String name) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        boolean bField = false;
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(value, ".^", true);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            String separator = null;
            if (tokenizer.hasMoreTokens()) {
                separator = tokenizer.nextToken();
            }
            int pos = element.lastIndexOf("[");
            String index = "";
            if (pos != -1) {
                index = element.substring(pos);
                element = element.substring(0, pos);
            }
            if (separator != null && separator.startsWith(".")) {
                buffer.append(this._helperSub.findOrCreate(element)).append(".");
                continue;
            }
            if (bField) {
                buffer.append(this._helperField.findOrCreate(element)).append(index);
            } else {
                buffer.append(this._helperVar.findOrCreate(element)).append(index);
            }
            if (separator == null || !separator.startsWith("^")) continue;
            buffer.append("^");
            bField = true;
        }
        return matcher.replaceFirst(" " + name + "='" + buffer.toString() + "'");
    }

    class OcasAnonymize
    extends OcasTranslate {
        protected void appendComment(String str) {
            if (str.startsWith("//")) {
                this.appendTxt("// ...");
            } else if (str.startsWith("/*")) {
                this.appendTxt("/* ...");
            } else if (str.startsWith("*/")) {
                this.appendTxt("*/");
            }
        }

        protected void appendOperator(String name) {
            this.replaceID(name, AnonymizeExportXML6.this._helperFct.findOrCreate(name));
        }

        protected void appendVariable(String name) {
            String code;
            int pos = name.lastIndexOf(94);
            if (pos != -1) {
                code = name.substring(pos + 1);
                name = name.substring(0, pos);
                this.replaceID(code, AnonymizeExportXML6.this._helperField.findOrCreate(code));
            }
            if ((pos = name.lastIndexOf(46)) != -1) {
                code = name.substring(pos + 1);
                name = name.substring(0, pos);
                if (code.equals("icone")) {
                    this.replaceID(code, code);
                } else {
                    this.replaceID(code, AnonymizeExportXML6.this._helperVar.findOrCreate(code));
                }
                pos = name.lastIndexOf(46);
                while (pos != -1) {
                    code = name.substring(pos + 1);
                    name = name.substring(0, pos);
                    this.replaceID(code, AnonymizeExportXML6.this._helperSub.findOrCreate(code));
                }
                if (name.length() > 0) {
                    this.replaceID(name, AnonymizeExportXML6.this._helperSub.findOrCreate(name));
                }
            } else if (name.equals("icone")) {
                this.replaceID(name, name);
            } else if (AnonymizeExportXML6.this._currentFct != null && AnonymizeExportXML6.this._currentFct.equals(name)) {
                this.replaceID(name, AnonymizeExportXML6.this._helperFct.findOrCreate(name));
            } else if (AnonymizeExportXML6.this._currentVariables.contains(name)) {
                this.replaceID(name, AnonymizeExportXML6.this._helperVar.findOrCreate(name));
            } else {
                this.replaceID(name, AnonymizeExportXML6.this._helperEnum.findOrCreate(name));
            }
        }

        protected void appendEvent(String name) {
            this.replaceID(name, AnonymizeExportXML6.this._helperEvent.findOrCreate(name));
        }

        protected void appendVariables(List<String> vars) {
            while (!vars.isEmpty()) {
                String var = vars.remove(vars.size() - 1);
                this.appendVariable(var);
            }
        }

        protected void appendEnums(List<String> IDs) {
            while (!IDs.isEmpty()) {
                String id = IDs.remove(IDs.size() - 1);
                this.replaceID(id, AnonymizeExportXML6.this._helperEnum.findOrCreate(id));
            }
        }
    }

    class ConvertHelper {
        int _idx = 1;
        Map<String, String> _map = new LinkedHashMap<String, String>();
        String _base;

        ConvertHelper(String base) {
            this._base = base;
        }

        String findOrCreate(String input) {
            String output = this._map.get(input);
            if (output == null) {
                output = this._base + this._idx++;
                this._map.put(input, output);
            }
            return output;
        }
    }
}

