/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.io.AbstractCmdExport;
import com.dassault.cecilia.io.xml6.AnonymizeExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class CmdAnonymizeXML
extends AbstractCmdExport {
    public CmdAnonymizeXML(CeciliaAppl appl, Component owner, Collection<DBFolder> selFolders, DBUser user) {
        super(appl, owner, selFolders, user);
    }

    @Override
    protected boolean recupForExport(DBFolder dbFolder) {
        if (!dbFolder.isVersion()) {
            return true;
        }
        switch (dbFolder.getFamily()) {
            case CCF_MODEL: 
            case FMEA_MODEL: {
                this.addError(dbFolder, MsgType.WARNING, "Ce type de donnee ne peut pas etre anonymise");
                return false;
            }
            case PROJECT: {
                switch (dbFolder.getFamilyFlag()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.addError(dbFolder, MsgType.WARNING, "Ce type de donnee ne peut pas etre anonymise");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected void doExport(Set<DBFolder> foldersToExport, File file) {
        AnonymizeExportXML6 doExport = new AnonymizeExportXML6(this.getAppl().getDAOFactory(), foldersToExport);
        doExport.setExportLogs(false);
        doExport.setExportAccess(false);
        doExport.setZipLimit(0L);
        try {
            doExport.exportTo(file);
        }
        catch (IOException ioe) {
            this.addError(this._srcFolder, ResMsgCore.msgFormat("MSG_EXC_IOE", file.getAbsolutePath(), ioe.getMessage()));
        }
    }
}

