/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import com.dassault.cecilia.io.xml6.DBFolderXmlConstant;
import com.dassault.cecilia.io.xml6.DBObjModelHandlerXml;
import com.dassault.cecilia.lib.util.io.Base64;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBFolderHandlerXml
extends SAXWrapHandler
implements DBFolderXmlConstant {
    protected DAOFactory _daoFactory;
    private static long ID = 0L;
    DBFolder _dbFolder = null;
    DBFolderHandlerXml _childHandler = null;
    DBObjModelHandlerXml _modelHandler = null;

    public DBFolderHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, DAOFactory daoFactory) {
        super(logMng, locator);
        this._daoFactory = daoFactory;
    }

    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._childHandler != null) {
            this._childHandler.startAction(key, attrs, startAction);
        } else if (this._modelHandler != null) {
            this._modelHandler.startAction(key, attrs, startAction);
        } else if (startAction) {
            if (!"cec.folder".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.folder"), this.getLocator()));
            }
            long id = this.readID(key, "id", attrs);
            DBFolder dbFolder = (DBFolder)this._daoFactory.createFolderDAO().find(id);
            if (dbFolder != null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_EXCLUSIF", key, "id", Long.toString(id)), this.getLocator()));
            }
            DBFolder.Family family = null;
            String attrValue = this.readName(key, "family", attrs);
            family = (DBFolder.Family)DBFolderHandlerXml.valueOfEnum(DBFolder.Family.class, (String)attrValue.toUpperCase());
            if (family == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "family", attrValue), this.getLocator()));
            }
            DBFolderXmlConstant.AttrFamilyFlag familyFlag = DBFolderXmlConstant.AttrFamilyFlag.NONE;
            String attrValue2 = attrs.get("familyFlag");
            if (attrValue2 != null && (familyFlag = (DBFolderXmlConstant.AttrFamilyFlag)DBFolderHandlerXml.valueOfEnum(DBFolderXmlConstant.AttrFamilyFlag.class, (String)attrValue2.toUpperCase())) == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "familyFlag", attrValue2), this.getLocator()));
            }
            DBFolderXmlConstant.AttrFolderType type = null;
            String attrValue3 = this.readName(key, "type", attrs);
            type = (DBFolderXmlConstant.AttrFolderType)DBFolderHandlerXml.valueOfEnum(DBFolderXmlConstant.AttrFolderType.class, (String)attrValue3.toUpperCase());
            if (family == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "type", attrValue3), this.getLocator()));
            }
            String name = this.readName(key, "name", attrs);
            if (type == DBFolderXmlConstant.AttrFolderType.VERSION) {
                if (!DBFactory.verifyVersion(name, family, familyFlag.getCode())) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "name", name), this.getLocator()));
                }
            } else if (!DBFactory.verifyName(name, family)) {
                if (Boolean.getBoolean("cecilia.import.Xml6AutoCorrectName")) {
                    name = DBFactory.convertName(name, family);
                }
                if (!DBFactory.verifyName(name, family)) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "name", name), this.getLocator()));
                }
            }
            ArrayList<DBFolderXmlConstant.AttrObjectFlag> objectFlags = null;
            String attrValue4 = attrs.get("objectFlag");
            if (attrValue4 != null) {
                StringTokenizer st = new StringTokenizer(attrValue4, ",");
                if (st.hasMoreTokens()) {
                    objectFlags = new ArrayList<DBFolderXmlConstant.AttrObjectFlag>();
                }
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken().trim();
                    DBFolderXmlConstant.AttrObjectFlag flag = (DBFolderXmlConstant.AttrObjectFlag)DBFolderHandlerXml.valueOfEnum(DBFolderXmlConstant.AttrObjectFlag.class, (String)tok.toUpperCase());
                    if (flag == null) {
                        this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "objectFlag", attrValue4), this.getLocator()));
                    }
                    objectFlags.add(flag);
                }
            }
            Date dateCreate = null;
            String attrValue5 = attrs.get("dateCreate");
            if (attrValue5 != null) {
                try {
                    dateCreate = new Date(Long.parseLong(attrValue5));
                }
                catch (NumberFormatException nfe) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "dateCreate", attrValue5), this.getLocator()));
                }
            }
            if (dateCreate == null) {
                dateCreate = new Date();
            }
            Date dateModify = null;
            String attrValue6 = attrs.get("dateModify");
            if (attrValue6 != null) {
                try {
                    dateModify = new Date(Long.parseLong(attrValue6));
                }
                catch (NumberFormatException nfe) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "dateModify", attrValue6), this.getLocator()));
                }
            }
            if (dateModify == null) {
                dateModify = dateCreate;
            }
            this._dbFolder = new DBFolder(id).setName(name);
            this._dbFolder.setDateCreate(dateCreate);
            this._dbFolder.setDateModify(dateModify);
            short code = 0;
            if (familyFlag != null) {
                code = familyFlag.getCode();
            }
            switch (type) {
                case FOLDER: {
                    this._dbFolder.setFlags(DBFolder.createFlagsFolder(family, code, (short)0));
                    break;
                }
                case MODEL: {
                    this._dbFolder.setFlags(DBFolder.createFlagsModel(family, code, (short)0));
                    break;
                }
                case VERSION: {
                    this._dbFolder.setFlags(DBFolder.createFlagsVersion(family, code, (short)0));
                }
            }
            if (objectFlags != null && !objectFlags.isEmpty()) {
                DBObject dbObject = new DBObject(this._dbFolder.getID());
                for (DBFolderXmlConstant.AttrObjectFlag attrObjectFlag : objectFlags) {
                    dbObject.setBinFlag(attrObjectFlag.getCode());
                }
                this._dbFolder.setObject(dbObject);
            }
            this._dbFolder.setAccesses(new ArrayList<DBAccess>());
            this._daoFactory.createFolderDAO().create(this._dbFolder);
        } else if (!"label".equals(key)) {
            if ("cec.property".equals(key)) {
                String type;
                String name = this.readName(key, "name", attrs);
                if (DBFactory.verifyName(name) != 0) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "name", name), this.getLocator()));
                }
                if ((type = attrs.get("type")) == null) {
                    type = "";
                }
                String value = this.readName(key, "value", attrs);
                DBObject dbObject = this._dbFolder.getObject();
                if (dbObject == null) {
                    dbObject = new DBObject(this._dbFolder.getID());
                    this._dbFolder.setObject(dbObject);
                }
                dbObject.addProperty(new DBObjProperty().setName(name).setType(type).setValue(value));
            } else if ("cec.access".equals(key)) {
                this.readAccess(key, attrs);
            } else if ("cec.model".equals(key)) {
                DBObject dbObject = this._dbFolder.getObject();
                if (dbObject == null) {
                    dbObject = new DBObject(this._dbFolder.getID());
                    this._dbFolder.setObject(dbObject);
                }
                this._modelHandler = new DBObjModelHandlerXml(this.getLogManager(), this.getLocator());
                this._modelHandler.startAction(key, attrs, true);
            } else if ("cec.folder".equals(key)) {
                if (this._dbFolder.isVersion()) {
                    this.error(new SAXParseException("Un dossier de type version ne peut contenir de sous-dossier : " + this._dbFolder.getRefPath(), this.getLocator()));
                }
                this._childHandler = new DBFolderHandlerXml(this.getLogManager(), this.getLocator(), this._daoFactory);
                this._childHandler.startAction(key, attrs, true);
                DBFolder dbChild = this._childHandler.getDBFolder();
                if (dbChild != null) {
                    dbChild.setParent(this._dbFolder);
                }
            } else {
                this.errorElementUnknown(key);
            }
        }
    }

    private void readAccess(String key, Map<String, String> attrs) throws SAXException {
        DBAccess.Right right;
        String attrValue = this.readName(key, "group", attrs);
        DBGroup dbGroup = this._daoFactory.createGroupDAO().findByName(attrValue);
        if (dbGroup == null) {
            dbGroup = new DBGroup().setName(attrValue);
            dbGroup = this._daoFactory.createGroupDAO().create(dbGroup);
        }
        this._dbFolder.setGroupOwner(dbGroup);
        attrValue = this.readName(key, "user", attrs);
        DBUser dbUser = this._daoFactory.createUserDAO().findByLogin(attrValue);
        if (dbUser == null) {
            dbUser = new DBUser().setLogin(attrValue).setName(attrValue).setPassword("");
            dbUser.setDefaultGroup(dbGroup);
            dbUser.addGroup(dbGroup);
            dbGroup.addUser(dbUser);
            dbUser = this._daoFactory.createUserDAO().create(dbUser);
        } else if (dbUser.addGroup(dbGroup)) {
            dbGroup.addUser(dbUser);
        }
        this._dbFolder.setUserOwner(dbUser);
        attrValue = attrs.get("accessGroup");
        if (attrValue != null) {
            right = DBAccess.Right.fromXML(attrValue);
            if (right == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "accessGroup", attrValue), this.getLocator()));
            } else {
                this._dbFolder.setRightGroup(right);
            }
        }
        if ((attrValue = attrs.get("accessOther")) != null) {
            right = DBAccess.Right.fromXML(attrValue);
            if (right == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "accessOther", attrValue), this.getLocator()));
            } else {
                this._dbFolder.setRightOther(right);
            }
        }
        if ((attrValue = attrs.get("lastModifier")) != null) {
            DBUser dbLast = this._daoFactory.createUserDAO().findByLogin(attrValue);
            if (dbLast == null) {
                dbLast = new DBUser().setLogin(attrValue).setName(attrValue).setPassword("");
                dbLast.setDefaultGroup(dbGroup);
                dbLast.addGroup(dbGroup);
                dbGroup.addUser(dbLast);
                dbLast = this._daoFactory.createUserDAO().create(dbLast);
            } else if (dbLast.addGroup(dbGroup)) {
                dbGroup.addUser(dbLast);
            }
            this._dbFolder.setUserModify(dbLast);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childHandler != null) {
            boolean result = this._childHandler.endAction(key, attrs, txt);
            if (result) {
                List<DBFolder> children = this._dbFolder.getChildren();
                if (children == null) {
                    children = new ArrayList<DBFolder>();
                    this._dbFolder.setChildren(children);
                }
                DBFolder dbChild = this._childHandler.getDBFolder();
                dbChild.setParent(this._dbFolder);
                children.add(dbChild);
                this._childHandler = null;
            }
            return false;
        }
        if (this._modelHandler != null) {
            boolean result = this._modelHandler.endAction(key, attrs, txt);
            if (result) {
                DBObjModelBytes dbModel = null;
                if (this._modelHandler.getFormat().equals("XML")) {
                    byte[] data = this._modelHandler.getBuffer().getBytes(StandardCharsets.UTF_8);
                    dbModel = new DBObjModelBytes(data);
                } else {
                    String buffer = this._modelHandler.getBuffer();
                    byte[] data = null;
                    try {
                        data = Base64.decode((String)buffer, (int)4);
                        dbModel = new DBObjModelBytes(data);
                    }
                    catch (IOException ioe) {
                        throw new SAXException("Probleme de decodage du flux '" + this._modelHandler.getNature() + "' du dossier '" + this._dbFolder.getRefPath() + "'", ioe);
                    }
                }
                if (dbModel != null) {
                    dbModel.setNature(this._modelHandler.getNature());
                    dbModel.setFormat(this._modelHandler.getFormat());
                    dbModel.setEncoding(this._modelHandler.getEncoding());
                    dbModel.setCRC(this._modelHandler.getCRC());
                    dbModel.setID(++ID);
                    this._dbFolder.getObject().addModel(dbModel);
                }
                this._modelHandler = null;
            }
            return false;
        }
        if ("label".equals(key)) {
            String label = txt.replaceAll("\\r*\\n\\r*", "\n");
            if (!DBFactory.verifyDescription(label)) {
                this.error(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DB_FOL_DESCRIPTION", this._dbFolder.getPathUntilSystem(new StringBuilder()).toString(), label.length(), (short)1023), this.getLocator()));
            }
            this._dbFolder.setDescription(label);
        }
        if ("cec.folder".equals(key)) {
            if (this._dbFolder.getUserOwner() == null) {
                this._dbFolder.setUserOwner(this._daoFactory.createUserDAO().getMasterUser());
                this._dbFolder.setGroupOwner(this._daoFactory.createGroupDAO().getMasterGroup());
                this._dbFolder.setRightGroup(DBAccess.Right.WRITE).setRightOther(DBAccess.Right.WRITE);
            }
            if (this._dbFolder.getUserModify() == null) {
                this._dbFolder.setUserModify(this._dbFolder.getUserOwner());
            }
            return true;
        }
        return false;
    }
}

