/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.action.DelegateAction;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PluginManagerPanel;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.SplashScreenGui;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.io.ExportChooseDialog;
import com.dassault.cecilia.io.imports.CmdImportPrepareARBOR51;
import com.dassault.cecilia.io.imports.CmdImportPrepareFtp;
import com.dassault.cecilia.io.imports.CmdImportPrepareOcas51;
import com.dassault.cecilia.io.imports.CmdImportPrepareXML6;
import com.dassault.cecilia.io.imports.DAOToolsWithDependencies;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;

public class GeneralsActions {
    CeciliaAppl _appl;
    CeciliaGUI _gui;

    public GeneralsActions(CeciliaAppl appl, CeciliaGUI gui) {
        this._appl = appl;
        this._gui = gui;
    }

    public void make(DeclareActions actions) {
        this.makeFileActions(actions);
        this.makeEditActions(actions);
        this.makeGlobalActions(actions);
        this.makeHelpActions(actions);
        this.makeZoomActions(actions);
    }

    private void makeFileActions(DeclareActions actions) {
        actions.putAction("CLOSE", new DelegateAction(ResMsgVoc.getString("VOC_CLOSE")).setIcon(ResIcoCore.getImageIcon("BUT_CLOSE")).setKey(KeyStroke.getKeyStroke("ctrl W")));
        actions.putAction("PRINT", new CeciliaAction(ResMsgVoc.getString("VOC_PRINT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame iframe = GeneralsActions.this._gui.getDesktop().getDesktop().getSelectedFrame();
                if (!(iframe instanceof CInternalFrame)) {
                    OpenFolder folder = GeneralsActions.this._appl.getOpenFolders().getSelectedFolder();
                    if (folder == null) {
                        return;
                    }
                    iframe = folder.getMasterFrame();
                }
                if (iframe instanceof CInternalFrame) {
                    ((CInternalFrame)iframe).print();
                }
            }
        }.setIcon(ResIcoCore.getImageIcon("BUT_PRINT")).setKey(KeyStroke.getKeyStroke("ctrl P")));
        actions.putAction("PRINT_PREVIEW", new CeciliaAction(ResMsgVoc.getString("VOC_PREVIEW")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame iframe = GeneralsActions.this._gui.getDesktop().getDesktop().getSelectedFrame();
                if (!(iframe instanceof CInternalFrame)) {
                    OpenFolder folder = GeneralsActions.this._appl.getOpenFolders().getSelectedFolder();
                    if (folder == null) {
                        return;
                    }
                    iframe = folder.getMasterFrame();
                }
                if (iframe instanceof CInternalFrame) {
                    ((CInternalFrame)iframe).preview();
                }
            }
        }.setIcon(ResIcoCore.getImageIcon("BUT_PREVIEW")).setKey(KeyStroke.getKeyStroke("ctrl shift P")));
        actions.putAction("PAGE_FORMAT", new CeciliaAction(ResIcoCore.getImageIcon("VIDE_PI"), ResMsgCecilia.getString("PRINT_PAGE_SETUP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat format = GeneralsActions.this._appl.getPageFormat();
                if ((format = job.pageDialog(format)) != null) {
                    GeneralsActions.this._appl.setPageFormat(format);
                }
            }
        });
        actions.putAction("SAVE", new DelegateAction(ResMsgVoc.getString("VOC_SAVE")).setIcon(ResIcoCore.getImageIcon("BUT_SAVE")).setKey(KeyStroke.getKeyStroke("ctrl S")));
        actions.putAction("EXPORT", new CeciliaAction(ResIcoCore.getImageIcon("IE_EXPORT"), ResMsgVoc.getString("VOC_EXPORT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeActivable projectTree = GeneralsActions.this._gui.getFolders().getTree(DBFolder.Family.PROJECT);
                if (projectTree == null) {
                    return;
                }
                ExportChooseDialog dlg = new ExportChooseDialog(GeneralsActions.this._appl);
                dlg.setVisible(true);
            }
        });
        actions.putAction("EXPORT_ADD", new CeciliaAction(ResMsgCecilia.getString("MENU_ADD_TO_EXPORT")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        actions.putAction("IMPORT_XML6", new CeciliaAction(ResMsgCecilia.getString("MENU_IMPORT_XML6")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CmdImportPrepareXML6 cmd = new CmdImportPrepareXML6(GeneralsActions.this._appl, GeneralsActions.this._gui);
                cmd.realiseDo();
            }
        });
        actions.putAction("IMPORT_ARBOR51", new CeciliaAction(ResMsgCecilia.getString("MENU_IMPORT_ARBOR51")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CmdImportPrepareARBOR51 cmd = new CmdImportPrepareARBOR51(GeneralsActions.this._appl, GeneralsActions.this._gui);
                cmd.realiseDo();
            }
        });
        actions.putAction("IMPORT_OCAS51", new CeciliaAction(ResMsgCecilia.getString("MENU_IMPORT_OCAS51")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CmdImportPrepareOcas51 cmd = new CmdImportPrepareOcas51(GeneralsActions.this._appl, GeneralsActions.this._gui);
                cmd.realiseDo();
            }
        });
        actions.putAction("IMPORT_DAGDEF", new DelegateAction(ResMsgCecilia.getString("MENU_IMPORT_DAG")));
        actions.putAction("IMPORT_ARB", new DelegateAction(ResMsgCecilia.getString("MENU_IMPORT_ARB")));
        actions.putAction("IMPORT_FTPLUS", new CeciliaAction(ResMsgCecilia.getString("MENU_IMPORT_FTP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CmdImportPrepareFtp cmd = new CmdImportPrepareFtp(GeneralsActions.this._appl, GeneralsActions.this._gui);
                cmd.realiseDo();
            }
        });
        actions.putAction("IMPORT_CAFTA", new DelegateAction(ResMsgCecilia.getString("MENU_IMPORT_CAFTA")));
        actions.putAction("QUIT", new CeciliaAction(ResIcoCore.getImageIcon("BUT_QUIT"), ResMsgVoc.getString("VOC_QUIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralsActions.this._gui.confirmQuitAndClose();
            }
        }.setKey(KeyStroke.getKeyStroke("ctrl Q")));
    }

    private void makeHelpActions(DeclareActions actions) {
        actions.putAction("ABOUT", new CeciliaAction(ResMsgCecilia.getString("ACTION_ABOUT_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashScreenGui win = new SplashScreenGui(GeneralsActions.this._gui, 3000L){

                    @Override
                    protected ImageIcon getImageIcon() {
                        return GeneralsActions.this._appl.getSplashIcon();
                    }

                    @Override
                    protected String getCopyright() {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(new Date());
                        return "Copyright \u00a9 1984-" + calendar.get(1) + " DASSAULT AVIATION. All Rights Reserved.";
                    }

                    @Override
                    protected String getVersion() {
                        return ConfigManager.getVersionLabel();
                    }
                };
                win.setVisible(true);
            }
        });
        actions.putAction("HELP", new CeciliaAction(ResMsgCecilia.getString("MENU_HELP")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        actions.putAction("REFRESH", new CeciliaAction(ResIcoCore.getImageIcon("BUT_REFRESH"), ResMsgVoc.getString("VOC_REFRESH"), ResMsgObj.getString("ACTION_REFRESH_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        actions.putAction("DB_VERIFY", new CeciliaAction(ResMsgVoc.getString("VOC_VERIFICATION")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CThread th = new CThread(GeneralsActions.this._gui){

                    @Override
                    protected void firstDo() {
                        DAOToolsWithDependencies daoTools = new DAOToolsWithDependencies(GeneralsActions.this._appl.getDAOFactory());
                        if (daoTools.verify()) {
                            JOptionPane.showMessageDialog(GeneralsActions.this._gui, "Aucune erreur de rencontrer", ResMsgVoc.getString("VOC_VERIFICATION") + " - " + GeneralsActions.this._gui.getTitle(), 1);
                        } else {
                            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(GeneralsActions.this._gui){

                                @Override
                                protected TableCellRenderer getSourceRenderer() {
                                    return new FolderRenderer().setDisplayPath(true);
                                }
                            };
                            dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgVoc.getString("VOC_VERIFICATION") + " - " + GeneralsActions.this._gui.getTitle());
                            dlg.setErrors(daoTools.getErrors());
                            dlg.setModal(true);
                            dlg.setLocationRelativeTo(GeneralsActions.this._gui);
                            dlg.setVisible(true);
                        }
                    }
                };
                th.realiseDo();
            }
        });
        actions.putAction("REORGANIZE_CASCADE", new CeciliaAction(ResMsgCecilia.getString("MENU_CASCADE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralsActions.this._gui.getDesktop().getDesktop().getDesktopManager().reorganizeWindowsCascade();
            }
        });
        actions.putAction("REORGANIZE_MOSAICs", new CeciliaAction(ResMsgCecilia.getString("MENU_MOSAIC")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralsActions.this._gui.getDesktop().getDesktop().getDesktopManager().reorganizeWindowsMosaic();
            }
        });
    }

    private void makeGlobalActions(DeclareActions actions) {
        actions.putAction("PREFERENCIES", new CeciliaAction(ResIcoCore.getImageIcon("PREF_OPTIONS"), ResMsgCecilia.getString("MENU_PREFERENCE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralsActions.this._gui.displayPreferencies();
            }
        });
        actions.putAction("ICON_LIBRARY", new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_IMAG"), ResMsgCecilia.getString("MENU_IMAGE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralsActions.this._gui.displayIconManager();
            }
        });
        actions.putAction("PLUGIN_MANAGER", new CeciliaAction(ResIcoCore.getImageIcon("PLUGIN_MANAGER"), ResMsgCecilia.getString("MENU_PLUGIN_MANAGER")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerPanel plugMngPanel = GeneralsActions.this._gui.getPlugable().getPluginManagerPanel();
                if (plugMngPanel == null) {
                    return;
                }
                File file = new File(PluginManager.PLUGIN_PATH, PluginManager.PLUGIN_FILE);
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(GeneralsActions.this._gui), ResMsgCecilia.getString("PLUGIN_ERROR_WRITE"), ResMsgCecilia.getString("PLUGIN_MANAGER"), 0);
                } else {
                    plugMngPanel.updateItemTree();
                    JDialogCecilia dialog = new JDialogCecilia((Window)GeneralsActions.this._gui, ResMsgCecilia.getString("PLUGIN_MANAGER"), true);
                    dialog.getContentPane().add(plugMngPanel);
                    dialog.setDefaultCloseOperation(2);
                    dialog.pack();
                    dialog.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(GeneralsActions.this._gui));
                    dialog.setVisible(true);
                    GeneralsActions.this._gui.buildPluginPreferencies();
                }
            }
        });
        actions.putAction("TASK_MANAGER", new CeciliaAction(ResMsgCecilia.getString("MENU_TASK_MANAGER")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralsActions.this._gui.getPlugable().displayTaskManager();
            }
        }.setIcon(ResIcoCore.getImageIcon("TASK_ICON")));
        actions.putAction("DISTRIB_MANAGER", new CeciliaAction(ResIcoCore.getImageIcon("VIDE_PI"), ResMsgCecilia.getString("MENU_DISTRIB")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CECILIAClient.isActive()) {
                    CECILIAClient.getCECILIAClient().displayIHM(GeneralsActions.this._gui, false);
                }
            }
        });
    }

    private void makeEditActions(DeclareActions actions) {
        actions.putAction("UNDO", new DelegateAction(ResMsgVoc.getString("VOC_UNDO")).setIcon(ResIcoCore.getImageIcon("BUT_UNDO")).setKey(KeyStroke.getKeyStroke("ctrl Z")));
        actions.putAction("REDO", new DelegateAction(ResMsgVoc.getString("VOC_REDO")).setIcon(ResIcoCore.getImageIcon("BUT_REDO")).setKey(KeyStroke.getKeyStroke("ctrl shift Z")));
        actions.putAction("DELETE", new DelegateAction(ResMsgVoc.getString("VOC_DELETE")).setKey(KeyStroke.getKeyStroke("DELETE")));
        actions.putAction("SELECTALL", new DelegateAction(ResMsgCecilia.getString("MENU_SELECT_ALL")).setIcon(ResIcoCore.getImageIcon("BUT_SELECT_ALL")).setKey(KeyStroke.getKeyStroke("ctrl A")));
        actions.putAction("PROPERTY", new DelegateAction(ResMsgVoc.getString("VOC_PROPERTIES")).setKey(KeyStroke.getKeyStroke("ctrl I")));
        actions.putAction("CUT", new DelegateAction(ResMsgVoc.getString("VOC_CUT")).setIcon(ResIcoCore.getImageIcon("BUT_CUT")).setKey(KeyStroke.getKeyStroke("ctrl X")));
        actions.putAction("COPY", new DelegateAction(ResMsgVoc.getString("VOC_COPY")).setIcon(ResIcoCore.getImageIcon("BUT_COPY")).setKey(KeyStroke.getKeyStroke("ctrl C")));
        actions.putAction("PASTE", new DelegateAction(ResMsgVoc.getString("VOC_PASTE")).setIcon(ResIcoCore.getImageIcon("BUT_PASTE")).setKey(KeyStroke.getKeyStroke("ctrl V")));
        actions.putAction("SEARCH", new SearchAction(this._appl, ResMsgVoc.getString("VOC_SEARCH"), ResIcoCore.getImageIcon("BUT_SEARCH"), ResMsgCecilia.getString("GUI_SEARCH_MODEL_OR_COMPONENT"), 0, KeyStroke.getKeyStroke("ctrl F")));
        actions.putAction("FREEZE", new DelegateAction(ResMsgVoc.getString("VOC_FREEZE")).setIcon(ResIcoCore.getImageIcon("BUT_FREEZE")));
    }

    private void makeZoomActions(DeclareActions actions) {
        actions.putAction("ZOOM_DEC", new DelegateAction(ResIcoCore.getImageIcon("BUT_ZOOM_MINUS"), ResMsgOcas.getString("VIEW_ZOOM_OUT")));
        actions.putAction("ZOOM_INC", new DelegateAction(ResIcoCore.getImageIcon("BUT_ZOOM_PLUS"), ResMsgOcas.getString("VIEW_ZOOM_IN")));
        actions.putAction("OCAS_DOWN", new DelegateAction(ResIcoCore.getImageIcon("BUT_DISPLAY_DOWN"), ResMsgCecilia.getString("MENU_DOWN")));
        actions.putAction("OCAS_DOWN_OTHER", new DelegateAction(ResIcoCore.getImageIcon("BUT_DISPLAY_ELSEWHERE"), ResMsgCecilia.getString("MENU_DOWN_IN_OTHER_VIEW")));
        actions.putAction("OCAS_UP", new DelegateAction(ResIcoCore.getImageIcon("BUT_DISPLAY_UP"), ResMsgCecilia.getString("MENU_UP")));
    }
}

