/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.dbobj.faulttree.config.gui.FTConfigPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.SelectionPackage;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FGContentPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEditPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListTable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.actions.search.SearchJListPanel;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;

public class SearchFTEquationPanel
extends SearchJListPanel {
    private List<FTVariableAbstract> _currentPath;

    public SearchFTEquationPanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(dlg, type);
    }

    @Override
    public void doOpenAction() {
        FTVariableListTable table;
        CInternalFrame frame = this._dlg.getFrame();
        if (frame == null) {
            return;
        }
        if (!(frame instanceof FTEquationFrame)) {
            return;
        }
        FTEditPanel panel = ((FTEquationFrame)frame).getCurrentEditPanel();
        if (panel instanceof FTConfigPanel) {
            return;
        }
        if (panel == null) {
            return;
        }
        FTVariableAbstract ftVarAbs = (FTVariableAbstract)this._listElements.getSelectedValue();
        if (ftVarAbs == null) {
            return;
        }
        if (panel instanceof FTVariableListPanel) {
            table = ((FTVariableListPanel)panel).getTable();
            table.clearSelection();
        }
        this.setSelectionEvent(ftVarAbs);
        if (panel instanceof FTVariableListPanel) {
            table = ((FTVariableListPanel)panel).getTable();
            int index = table.getSelectedRows()[0];
            table.scrollRectToVisible(new Rectangle(table.getCellRect(index, 0, true)));
        }
        panel.doEdit();
    }

    @Override
    public void doLocateAction() {
        FTVariableListTable table;
        CInternalFrame frame = this._dlg.getFrame();
        if (frame == null) {
            return;
        }
        FTEditPanel panel = ((FTEquationFrame)frame).getCurrentEditPanel();
        if (panel instanceof FTConfigPanel) {
            return;
        }
        FTVariableAbstract ftVarAbs = (FTVariableAbstract)this._listElements.getSelectedValue();
        if (ftVarAbs == null) {
            return;
        }
        if (panel instanceof FTVariableListPanel) {
            table = ((FTVariableListPanel)panel).getTable();
            table.clearSelection();
        }
        this.setSelectionEvent(ftVarAbs);
        if (panel instanceof FTVariableListPanel) {
            table = ((FTVariableListPanel)panel).getTable();
            int index = table.getSelectedRows()[0];
            table.scrollRectToVisible(new Rectangle(table.getCellRect(index, 0, true)));
        } else if (panel instanceof FGContentPanel) {
            ((FGContentPanel)panel).locateOnGraphs();
        }
    }

    @Override
    protected void doFillWithData() {
        CInternalFrame frame = this._dlg.getFrame();
        if (frame == null) {
            return;
        }
        DefaultListModel defListModel = (DefaultListModel)this._listElements.getModel();
        this.clearElements();
        Pattern pattern = this.createPattern();
        if (pattern == null) {
            return;
        }
        FTEquation equation = ((FTEquationFrame)frame).getDBWrap();
        List<FTVariableAbstract> varAbst = equation.getAllVariables();
        for (FTVariableAbstract ftVar : varAbst) {
            String varName = ftVar.getName();
            if (!pattern.matcher(varName).find()) continue;
            defListModel.add(this._listElements.getModel().getSize(), ftVar);
        }
    }

    protected final void setSelectionEvent(FTVariableAbstract ftVarAbs) {
        FTEquationFrame equationFrame = (FTEquationFrame)this._dlg.getFrame();
        FTEquation equation = equationFrame.getDBWrap();
        if (ftVarAbs == null) {
            return;
        }
        if ((ftVarAbs = equation.getVariable(ftVarAbs.getName())) == null) {
            return;
        }
        SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> unselectAllEvents = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(equation.getAllVariables().get(0), false, (Collection<FTVariableAbstract>)equation.getAllVariables());
        SelectionPackage.ChangeSelectionEvent<FTVariableAbstract> changeEvent = new SelectionPackage.ChangeSelectionEvent<FTVariableAbstract>(ftVarAbs, true);
        FTEditPanel currentEditPanel = equationFrame.getCurrentEditPanel();
        if (currentEditPanel instanceof FTVariableListPanel) {
            FTVariableListTable table = ((FTVariableListPanel)currentEditPanel).getTable();
            equation.fireChangeSelection(unselectAllEvents, table);
            equation.fireChangeSelection(changeEvent, table);
            int index = equation.getAllVariables().indexOf(ftVarAbs);
            table.setRowSelectionInterval(index, index);
            table.scrollRectToVisible(new Rectangle(table.getCellRect(index, 0, true)));
        } else if (currentEditPanel instanceof FGContentPanel) {
            int indexCurrentPath;
            List<List<FTVariableAbstract>> paths = equation.findPaths(null, ftVarAbs, true);
            assert (paths != null && !paths.isEmpty());
            FGContentPanel panel = equationFrame.getContentPanel();
            this._currentPath = paths.size() != 1 && this._currentPath != null && paths.contains(this._currentPath) ? ((indexCurrentPath = paths.indexOf(this._currentPath)) + 1 == paths.size() ? paths.get(0) : paths.get(indexCurrentPath + 1)) : paths.get(0);
            panel.getContentView().browseByPath(this._currentPath, ftVarAbs);
            for (FTVariableAbstract ftVar : equation.getAllVariables()) {
                ftVar.setSelected(false);
            }
            ftVarAbs.setSelected(true);
            equation.fireChangeSelection(unselectAllEvents, ((FGContentPanel)currentEditPanel).getContentView());
            equation.fireChangeSelection(changeEvent, ((FGContentPanel)currentEditPanel).getContentView());
        }
    }
}

