/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.actions.search.SearchPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class SearchJTreePanel
extends SearchPanel {
    protected JTree _treeElements;

    public SearchJTreePanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(dlg, type);
    }

    @Override
    protected JComponent createComponentForResult() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(null);
        this._treeElements = new JTree(rootNode);
        this._treeElements.setRootVisible(true);
        this._treeElements.expandRow(0);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(rootNode);
        this._treeElements.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus2) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus2);
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    Object obj = node.getUserObject();
                    if (obj instanceof DBFolder) {
                        DBFolder folder = (DBFolder)node.getUserObject();
                        ImageIcon icon = DBFolderResources.getIcon(folder, true, true, false, false);
                        label.setIcon(icon);
                        label.setText(folder.getRefPath());
                    } else if (obj instanceof AltaSub) {
                        AltaSub sub = (AltaSub)obj;
                        ImageIcon icon = sub.getNode() instanceof AltaEquipment ? ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_") : ResIcoCore.getImageIcon("FOLDER_COMPONENT_");
                        label.setIcon(icon);
                        label.setText(sub.getName());
                    } else {
                        if (SearchJTreePanel.this.getFrame() != null) {
                            this.setIcon(SearchJTreePanel.this.getFrame().getFrameIcon());
                        } else {
                            this.setIcon(null);
                        }
                        if (obj != null) {
                            label.setText("[" + obj.toString() + "]");
                        }
                    }
                } else if (value instanceof FTVariableAbstract) {
                    FTVariableAbstract ftVarAbs = (FTVariableAbstract)value;
                    label.setText(ftVarAbs.getName());
                } else if (SearchJTreePanel.this.getFrame() != null) {
                    this.setIcon(SearchJTreePanel.this.getFrame().getFrameIcon());
                } else {
                    this.setIcon(null);
                }
                return label;
            }
        });
        this._treeElements.setModel(defaultTreeModel);
        this._treeElements.setExpandsSelectedPaths(true);
        this._treeElements.addTreeSelectionListener(e -> {
            JTree tree = (JTree)e.getSource();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            if (node != null) {
                this.selectionTreeValueChanged(node);
            }
        });
        this._treeElements.setRowHeight(ResIcoAbstract.getIconSize());
        JScrollPane scrollPaneList = new JScrollPane(this._treeElements);
        scrollPaneList.setPreferredSize(new Dimension(400, 300));
        return scrollPaneList;
    }

    @Override
    protected JComponent getComponentForResult() {
        return this._treeElements;
    }

    protected abstract void selectionTreeValueChanged(DefaultMutableTreeNode var1);

    protected final DefaultMutableTreeNode getElementInSet(Set<DefaultMutableTreeNode> setTree, Object element) {
        for (DefaultMutableTreeNode node : setTree) {
            Object obj = node.getUserObject();
            if (!obj.equals(element)) continue;
            return node;
        }
        return null;
    }

    protected final void clearSelection() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._treeElements.getModel().getRoot();
        root.removeAllChildren();
        ((DefaultTreeModel)this._treeElements.getModel()).nodeStructureChanged(root);
    }

    @Override
    protected void doUpdateData(SearchAction.SearchContext context) {
        this._treeElements.setModel((DefaultTreeModel)context.getData());
        this._treeElements.setSelectionPath((TreePath)context.getSelectedData());
        this._treeElements.revalidate();
        this._treeElements.repaint();
    }

    @Override
    public void resetContext() {
        this._treeElements.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(null)));
    }

    @Override
    public void exit() {
        super.exit();
        this.resetContext();
    }

    @Override
    public void updateEnabled(boolean selectable) {
        super.updateEnabled(selectable);
        this._treeElements.setBackground(selectable ? Color.WHITE : new Color(230, 230, 230));
    }
}

