/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions.search;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentFrame;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulFrame;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaSystemFrame;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import com.dassault.cecilia.main.cecilia.actions.search.SearchJTreePanel;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SearchSystemPanel
extends SearchJTreePanel {
    private boolean _searchForModels = false;
    private JLabel _searchLbl;
    private JComboBox<String> _searchModelCB;

    public SearchSystemPanel(SearchDlg dlg, SearchDlg.SearchType type) {
        super(dlg, type);
    }

    @Override
    protected JPanel createPrincipalPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._searchLbl = new JLabel(ResMsgCecilia.getString("DLG_ACTION_SEARCH_SEARCH_IN"));
        this._searchModelCB = new JComboBox();
        this._searchModelCB.addItem(ResMsgCecilia.getString("DLG_ACTION_SEARCH_COMPONENTS"));
        this._searchModelCB.addItem(ResMsgCecilia.getString("DLG_ACTION_SEARCH_MODELS"));
        this._searchModelCB.addActionListener(e -> {
            String selectedItem = (String)this._searchModelCB.getSelectedItem();
            this._searchForModels = selectedItem.equals(ResMsgCecilia.getString("DLG_ACTION_SEARCH_MODELS"));
            this.resetContext();
        });
        JPanel originalSearchPanel = super.createPrincipalPanel();
        panel.add((Component)this._searchLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(this._searchModelCB, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)originalSearchPanel, new GridBagConstraints(0, 1, 2, 1, 100.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void doFillWithData() {
        DBInternalFrame codeFrame = (DBInternalFrame)this._dlg.getFrame();
        if (codeFrame == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._treeElements.getModel().getRoot();
        this.clearSelection();
        root.setUserObject(this._filtreJTF.getText());
        Pattern pattern = this.createPattern();
        if (pattern == null) {
            return;
        }
        AltaEquipment equi = (AltaEquipment)codeFrame.getDBWrap();
        if (this._searchForModels) {
            for (DefaultMutableTreeNode node : this.findModelsInLibrary(equi, pattern)) {
                root.add(node);
            }
        } else {
            for (DefaultMutableTreeNode node : this.findComponentsInMBSA(equi, pattern)) {
                root.add(node);
            }
        }
        ((DefaultTreeModel)this._treeElements.getModel()).nodeStructureChanged(root);
    }

    @Override
    public void doOpenAction() {
        CInternalFrame _frame = this._dlg.getFrame();
        if (_frame == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._treeElements.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        DBFolder folder = null;
        Object obj = node.getUserObject();
        folder = obj instanceof AltaSub ? ((AltaSub)obj).getNode().getDBFolder() : (DBFolder)obj;
        DBFolderTreeActivable tree = ((CeciliaAppl)this._dlg.getApplication()).getTopWindow().getFolders().getTree(folder.getFamily());
        if (tree != null) {
            tree.edit(folder, folder.isReadOnly());
        }
    }

    @Override
    public void doLocateAction() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this._treeElements.getLastSelectedPathComponent();
        CInternalFrame frame = this._dlg.getFrame();
        CAppl cAppl = this._dlg.getApplication();
        if (frame == null || selectedNode == null) {
            return;
        }
        Object selectedObject = selectedNode.getUserObject();
        if (!(selectedObject instanceof AltaSub)) {
            return;
        }
        DBInternalFrame codeFrame = (DBInternalFrame)frame;
        AltaEquipment equi = (AltaEquipment)codeFrame.getDBWrap();
        this.unselectComponentsContent(equi);
        AltaSub sub = (AltaSub)selectedNode.getUserObject();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectedNode.getParent();
        DBInternalFrame frameToUpdate = codeFrame;
        if (parent.getUserObject() instanceof AltaSub || parent.getParent() != null && !((DefaultMutableTreeNode)parent.getParent()).isRoot()) {
            JInternalFrame[] internalFrames;
            Object obj = parent.getUserObject();
            DBFolder folderToEdit = null;
            folderToEdit = obj instanceof AltaSub ? ((AltaSub)obj).getNode().getDBFolder() : (DBFolder)((DefaultMutableTreeNode)parent.getParent()).getUserObject();
            DBFolderTreeActivable tree = ((CeciliaAppl)cAppl).getTopWindow().getFolders().getTree(folderToEdit.getFamily());
            for (JInternalFrame internalFrame : internalFrames = ((CeciliaGUI)cAppl.getTopWindow()).getDesktop().getDesktop().getAllFrames()) {
                if (!(internalFrame instanceof AltaEquipmentFrame)) continue;
                DBFolder folderFrame = ((AltaEquipmentFrame)internalFrame).getDBFolder();
                if (!folderFrame.equals(folderToEdit)) break;
                frameToUpdate = (AltaEquipmentFrame)internalFrame;
                break;
            }
            if (tree != null && !frameToUpdate.getDBFolder().equals(folderToEdit)) {
                tree.edit(folderToEdit, folderToEdit.isReadOnly());
                frameToUpdate = (AltaEquipmentFrame)((CeciliaGUI)cAppl.getTopWindow()).getDesktop().getDesktop().getSelectedFrame();
            }
        } else {
            frameToUpdate = codeFrame;
        }
        AlgaNode node = this.getRealGraphic(frameToUpdate, sub.getGraphic());
        if (node == null) {
            return;
        }
        if (node.getParent() instanceof AlgaSheet && !((AlgaSheet)node.getParent()).isVisible()) {
            JOptionCecilia.showMessageDialog(frameToUpdate, ResMsgCecilia.getString("DLG_ACTION_SEARCH_COMPOSANT_ON_NOT_VISIBLE_CALC"), ResMsgCecilia.getString("DLG_ACTION_SEARCH_TITLE"), 2);
            return;
        }
        frameToUpdate.requestFocus();
        node.setSelected(true);
        AltaContentPanel panel = frameToUpdate instanceof AltaEquipmentFrame ? ((AltaEquipmentFrame)frameToUpdate).selectAndGetEditPanel() : (frameToUpdate instanceof AltaSystemFrame ? ((AltaSystemFrame)frameToUpdate).getEditPanel() : ((AltaSimulFrame)frameToUpdate).getSimulPanel());
        panel.locateOnGraphs();
        panel.getView().repaint();
    }

    @Override
    public void selectionTreeValueChanged(DefaultMutableTreeNode node) {
        Object object = node.getUserObject();
        if (!(object instanceof AltaSub)) {
            this._dlg.getButton(0).setEnabled(false);
            this._dlg.getButton(1).setEnabled(true);
        } else {
            this._dlg.getButton(0).setEnabled(true);
            this._dlg.getButton(1).setEnabled(true);
        }
    }

    public AlgaNode getRealGraphic(CInternalFrame frame, AlgaNode original) {
        AlgaContent content = null;
        content = frame instanceof AltaEquipmentFrame ? ((AltaEquipmentFrame)frame).selectAndGetEditPanel().getView().getContent() : (frame instanceof AltaSystemFrame ? ((AltaSystemFrame)frame).getEditPanel().getView().getContent() : ((AltaSimulFrame)frame).getSimulPanel().getView().getContent());
        HashSet<AlgaGraph> graphs = new HashSet<AlgaGraph>();
        for (AlgaSheet sheet : content.getSheets()) {
            graphs.addAll(sheet.getGraphs());
        }
        for (AlgaGraph graph : graphs) {
            if (!(graph instanceof AlgaNode)) continue;
            AlgaNode node = (AlgaNode)graph;
            String originalName = original.getLogical().getName();
            String nodeName = node.getLogical().getName();
            if (!nodeName.equals(originalName)) continue;
            return node;
        }
        return null;
    }

    private Set<DefaultMutableTreeNode> getComponentsFiltered(AltaEquipment equipment, Pattern pattern) {
        LinkedHashSet<DefaultMutableTreeNode> setNodes = new LinkedHashSet<DefaultMutableTreeNode>();
        for (AltaSub sub : equipment.getSubs()) {
            DefaultMutableTreeNode existingNode;
            AltaComponent node = sub.getNode();
            DBFolder folder = node.getDBFolder();
            String nameToCheck = this._searchForModels ? folder.getRefPath() : sub.getName();
            LinkedHashSet<DefaultMutableTreeNode> setNodeEquipment = new LinkedHashSet<DefaultMutableTreeNode>();
            if (node instanceof AltaEquipment) {
                setNodeEquipment.addAll(this.getComponentsFiltered((AltaEquipment)node, pattern));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = existingNode = this._searchForModels ? this.getElementInSet(setNodes, folder) : this.getElementInSet(setNodes, sub);
            if (!setNodeEquipment.isEmpty() && existingNode == null) {
                existingNode = this._searchForModels ? new DefaultMutableTreeNode(folder) : new DefaultMutableTreeNode(sub);
                setNodes.add(existingNode);
                for (DefaultMutableTreeNode nodeEquip : setNodeEquipment) {
                    existingNode.add(nodeEquip);
                }
            }
            if (!pattern.matcher(nameToCheck).find()) continue;
            if (this._searchForModels) {
                if (existingNode == null) {
                    existingNode = new DefaultMutableTreeNode(folder);
                    setNodes.add(existingNode);
                }
                existingNode.add(new DefaultMutableTreeNode(sub));
                continue;
            }
            if (existingNode != null) continue;
            setNodes.add(new DefaultMutableTreeNode(sub));
        }
        return setNodes;
    }

    private Set<DefaultMutableTreeNode> findComponentsInMBSA(AltaEquipment equipment, Pattern pattern) {
        LinkedHashSet<DefaultMutableTreeNode> setNodes = new LinkedHashSet<DefaultMutableTreeNode>();
        for (AltaSub sub : equipment.getSubs()) {
            AltaComponent node = sub.getNode();
            DefaultMutableTreeNode existingNode = this.getElementInSet(setNodes, sub);
            if (pattern.matcher(sub.getName()).find() && existingNode == null) {
                existingNode = new DefaultMutableTreeNode(sub);
                setNodes.add(existingNode);
            }
            if (!(node instanceof AltaEquipment)) continue;
            LinkedHashSet<DefaultMutableTreeNode> setNodeEquipment = new LinkedHashSet<DefaultMutableTreeNode>();
            setNodeEquipment.addAll(this.findComponentsInMBSA((AltaEquipment)node, pattern));
            if (setNodeEquipment.isEmpty()) continue;
            if (existingNode == null) {
                existingNode = new DefaultMutableTreeNode(sub);
                setNodes.add(existingNode);
            }
            for (DefaultMutableTreeNode nodeEquip : setNodeEquipment) {
                existingNode.add(nodeEquip);
            }
        }
        return setNodes;
    }

    private Set<DefaultMutableTreeNode> findModelsInLibrary(AltaEquipment equipment, Pattern pattern) {
        LinkedHashSet<DefaultMutableTreeNode> setNodes = new LinkedHashSet<DefaultMutableTreeNode>();
        for (AltaSub sub : equipment.getSubs()) {
            AltaComponent node = sub.getNode();
            DBFolder folder = node.getDBFolder();
            DefaultMutableTreeNode existingNode = this.getElementInSet(setNodes, folder);
            if (node instanceof AltaEquipment) {
                LinkedHashSet<DefaultMutableTreeNode> setNodeEquipment = new LinkedHashSet<DefaultMutableTreeNode>();
                setNodeEquipment.addAll(this.findModelsInLibrary((AltaEquipment)node, pattern));
                if (!setNodeEquipment.isEmpty() && existingNode == null) {
                    existingNode = new DefaultMutableTreeNode(folder);
                    setNodes.add(existingNode);
                    for (DefaultMutableTreeNode nodeEquip : setNodeEquipment) {
                        existingNode.add(nodeEquip);
                    }
                }
            }
            if (!pattern.matcher(folder.getRefPath()).find()) continue;
            if (existingNode == null) {
                existingNode = new DefaultMutableTreeNode(folder);
                setNodes.add(existingNode);
            }
            existingNode.add(new DefaultMutableTreeNode(sub));
        }
        return setNodes;
    }

    private void unselectComponentsContent(AltaEquipment equipment) {
        for (AltaSub sub : equipment.getSubs()) {
            sub.getGraphic().setSelected(false);
            if (!(sub.getNode() instanceof AltaEquipment)) continue;
            this.unselectComponentsContent((AltaEquipment)sub.getNode());
        }
        equipment.getContent().changeSelectGraphs(null, false);
    }

    @Override
    public SearchAction.SearchContext getContext() {
        TreePath path = this._treeElements.getSelectionPath();
        return new SearchAction.SearchContext(this._filtreJTF.getText(), this._treeElements.getModel(), path, this._searchForModels);
    }

    @Override
    protected void doUpdateData(SearchAction.SearchContext context) {
        if (context.isForModels()) {
            this._searchModelCB.setSelectedItem(ResMsgCecilia.getString("DLG_ACTION_SEARCH_MODELS"));
        } else {
            this._searchModelCB.setSelectedItem(ResMsgCecilia.getString("DLG_ACTION_SEARCH_COMPONENTS"));
        }
        super.doUpdateData(context);
    }

    @Override
    public void updateEnabled(boolean selectable) {
        super.updateEnabled(selectable);
        this._searchLbl.setEnabled(selectable);
        this._searchModelCB.setEnabled(selectable);
    }
}

