/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.folders;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.fmea.DBModelFMEA;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdProperty;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.BTPFolderPropertiesSubstPanel;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class BTPFolderCmdProperty
extends DBFolderCmdProperty {
    private static final Logger _LOG = Logger.getLogger(BTPFolderCmdProperty.class.getPackage().getName());
    private static String[] _BTP_FOLDER_TITLE_ID = new String[]{"TITLE_GEN_CREATE_FAMILY", "TITLE_GEN_CREATE_FAMILY_EQUIPMENT", "TITLE_GEN_CREATE_FAMILY_FUNCTION", "TITLE_GEN_CREATE_FAMILY_DEFECT"};

    public BTPFolderCmdProperty(CeciliaAppl appl, DBFolderTreeEditable ctrlTree, boolean edit) {
        super(appl, ctrlTree, edit);
    }

    @Override
    protected CeciliaAppl getAppl() {
        return (CeciliaAppl)super.getAppl();
    }

    @Override
    protected DBFolderPropertiesPanel constructDialog() {
        if (this.isEditProperties()) {
            return this.constructDialogForModify();
        }
        return this.constructDialogForCreate();
    }

    protected DBFolderPropertiesPanel constructDialogForCreate() {
        PluginWithOptions opts;
        DBFolderPropertiesPanel panel = new DBFolderPropertiesPanel();
        panel.setDAOFactory(this._application.getDAOFactory());
        panel.setUserIsAdmin(this._dbUser.isAdmin());
        Preferencies prefs = this._application.getPreferencies();
        if (prefs != null && (opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY)) != null && opts instanceof GeneralTextPreferencies) {
            panel.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
        DBFolder create = new DBFolder(this._dbFolder, this._dbUser);
        panel.setFolder(create);
        DBFolder.Family familyFolder = this._dbFolder.getFamily();
        int depth = this._dbFolder.getDepthUntilSystem();
        boolean createFamily = depth < familyFolder.getDepthFolder();
        panel.setFamilyTarget(createFamily);
        if (createFamily) {
            switch (familyFolder) {
                default: {
                    _LOG.warning("Type de famille non autoris\u00e9 pour cette arborescence : " + (Object)((Object)familyFolder));
                }
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    _LOG.severe("Pas d'arboresence pour ce type de donn\u00e9es : " + (Object)((Object)familyFolder));
                    return null;
                }
                case BTP_MODEL: {
                    panel.setTitle(ResMsgObj.getString(_BTP_FOLDER_TITLE_ID[depth]));
                    break;
                }
                case ATTRIBUTE: 
                case PARAMETER: {
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_FAMILY"));
                }
            }
            panel.setVisiblePath(depth > 0);
            panel.setQuestion(DBFolderResources.getTypeFolder(familyFolder, depth));
            create.setFlags(DBFolder.createFlagsFolder(familyFolder, (short)0, (short)0));
        } else {
            if (!this.verifyCreateNewModel()) {
                return null;
            }
            switch (familyFolder) {
                case BTP_MODEL: 
                case ATTRIBUTE: 
                case PARAMETER: 
                case CCF_MODEL: 
                case FMEA_MODEL: {
                    if (this._dbFolder.isModel()) {
                        List<DBFolder> refChildren = this.getUnlockChildren(SwingUtilities.getWindowAncestor(panel));
                        if (refChildren.isEmpty()) {
                            return null;
                        }
                        panel.setQuestion(DBFolderResources.getTypeVersion(familyFolder));
                        panel.setVersionsReferencies(refChildren, this._dbFolder.getChildren());
                        create.setFlags(DBFolder.createFlagsVersion(familyFolder, (short)0, (short)0));
                    } else {
                        panel.setQuestion(DBFolderResources.getTypeModel(familyFolder, (short)0));
                        create.setFlags(DBFolder.createFlagsModel(familyFolder, (short)0, (short)0));
                    }
                    switch (familyFolder) {
                        case BTP_MODEL: {
                            panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_EVENTS_MODEL"));
                            break;
                        }
                        case CCF_MODEL: {
                            panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_CCF_MODEL"));
                            break;
                        }
                        case PARAMETER: {
                            panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_PARAMETER"));
                            break;
                        }
                        case ATTRIBUTE: {
                            panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_ATTRIBUTE"));
                            break;
                        }
                        case FMEA_MODEL: {
                            panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_FMEA"));
                        }
                    }
                    break;
                }
                case BTP_APPLICATION: {
                    create.setRightGroup(DBAccess.Right.WRITE).setRightOther(DBAccess.Right.READ);
                    panel.setDAOFactory(null).setVisiblePath(false);
                    panel.setQuestion(ResMsgVoc.getString("VOC_APPLICATION"));
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_APPLICATION"));
                    create.setFlags(DBFolder.createFlagsVersion(familyFolder, (short)0, (short)0));
                    break;
                }
                case BTP_AUTHOR: {
                    create.setRightGroup(DBAccess.Right.WRITE).setRightOther(DBAccess.Right.READ);
                    panel.setDAOFactory(null).setVisiblePath(false);
                    panel.setQuestion(ResMsgVoc.getString("VOC_AUTHOR"));
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_AUTHOR"));
                    create.setFlags(DBFolder.createFlagsVersion(familyFolder, (short)0, (short)0));
                    break;
                }
                case BTP_SUBSTANTIATION: {
                    panel = new BTPFolderPropertiesSubstPanel();
                    panel.setFolder(create);
                    create.setRightGroup(DBAccess.Right.WRITE).setRightOther(DBAccess.Right.READ);
                    create.setFlags(DBFolder.createFlagsVersion(familyFolder, (short)0, (short)0));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return panel;
    }

    protected DBFolderPropertiesPanel constructDialogForModify() {
        PluginWithOptions opts;
        DBFolderPropertiesPanel dlg = new DBFolderPropertiesPanel();
        Preferencies prefs = this._application.getPreferencies();
        if (prefs != null && (opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY)) != null && opts instanceof GeneralTextPreferencies) {
            dlg.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
        dlg.setDAOFactory(this._application.getDAOFactory());
        dlg.setUserIsAdmin(this._dbUser.isAdmin());
        DBFolder modify = new DBFolder(this._dbFolder);
        dlg.setFolder(modify);
        dlg.setReadOnly(this.propertiesHasReadOnly());
        dlg.setAccessReadOnly(this.accessHasReadOnly());
        DBFolder.Family familyFolder = modify.getFamily();
        int depth = modify.getDepthUntilSystem();
        boolean isFamilyTarget = depth <= familyFolder.getDepthFolder();
        dlg.setFamilyTarget(isFamilyTarget);
        dlg.setQuestion(ResMsgVoc.getString("VOC_NAME"));
        dlg.setVisiblePath(depth > 0);
        dlg.setEditProperties(true);
        if (isFamilyTarget) {
            switch (familyFolder) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    _LOG.severe("Pas d'arboresence pour ce type de donn\u00e9es : " + (Object)((Object)familyFolder));
                    return null;
                }
            }
        } else {
            switch (familyFolder) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: {
                    dlg.setWithDepends(true);
                    dlg.setVisiblePath(false);
                    dlg.setWithAccess(false);
                    break;
                }
                case BTP_SUBSTANTIATION: {
                    DBObject obj;
                    DBObjProperty prop;
                    dlg = new BTPFolderPropertiesSubstPanel();
                    dlg.setDAOFactory(this._application.getDAOFactory());
                    dlg.setWithDepends(true);
                    dlg.setFolder(modify);
                    dlg.setEditProperties(true);
                    dlg.setWithAccess(false);
                    dlg.setReadOnly(this._application.getDAOFactory().createFolderDAO().getAccessRight(this._dbFolder, this._dbUser) != DBAccess.Right.WRITE);
                    if (modify.getObject() == null || (prop = (obj = modify.getObject()).getProperty("btp.substantiation.date")) == null) break;
                    ((BTPFolderPropertiesSubstPanel)dlg).setDate(prop.getValue());
                    break;
                }
                default: {
                    dlg.setNameEditable(!this.nameHasReadOnly());
                    dlg.setWithDepends(true);
                }
            }
        }
        dlg.setTitle(ResMsgVoc.getString("VOC_PROPERTIES") + " - " + DBFolderResources.getTypeName(modify));
        return dlg;
    }

    @Override
    protected void createModelFolder(DBFolderPropertiesPanel dlg) {
        DBFolder create = dlg.getDBFolder();
        switch (create.getFamily()) {
            case BTP_SUBSTANTIATION: {
                if (dlg instanceof BTPFolderPropertiesSubstPanel) {
                    DBObject obj = new DBObject();
                    DBObjProperty prop = new DBObjProperty().setName("btp.substantiation.date");
                    prop.setType("Date");
                    prop.setValue(((BTPFolderPropertiesSubstPanel)dlg).getDate());
                    obj.addProperty(prop);
                    create.setObject(obj);
                    this.createDBFolder(create);
                    break;
                }
                _LOG.severe("Mauvaise fenetre de dialogue : impossibilite de recuperer la date d'instantiation");
                break;
            }
            case BTP_APPLICATION: 
            case BTP_AUTHOR: {
                this.createDBFolder(create);
                break;
            }
            default: {
                super.createModelFolder(dlg);
            }
        }
    }

    @Override
    protected DBObject createObject(DBFolder dbFolderVersion) {
        DBObject dbObject = super.createObject(dbFolderVersion);
        switch (dbFolderVersion.getFamily()) {
            case PARAMETER: {
                DBParam dbParam = new DBParam(dbFolderVersion);
                dbParam.configureModels(dbObject);
                break;
            }
            case ATTRIBUTE: {
                DBAttrib dbAttrib = new DBAttrib(dbFolderVersion);
                dbAttrib.configureModels(dbObject);
                break;
            }
            case BTP_MODEL: {
                DBModelLaw dbModelLaw = new DBModelLaw(dbFolderVersion);
                Law law = this.getAppl().getDAOFactory().getLawManager().createLaw(1);
                law.setParamAt(0, new ParamValue(law.getParamAt(0).getType(), 1.0));
                dbModelLaw.setLaw(law);
                dbModelLaw.getLogs().addLog(new Date(), this.getAppl().getDBUser().getLogin(), DBLogs.DBLevel.INIT, ResMsgObj.getString("MSG_ERR_OBJ_NOT_INITIALIZED")).setPrivate(true);
                dbModelLaw.configureModels(dbObject);
                break;
            }
            case CCF_MODEL: {
                CCF dbCCF = new CCF(dbFolderVersion);
                dbCCF.setType(CCF.CCFType.BETA);
                dbCCF.setFactors(new double[]{0.02});
                dbCCF.setLaw(this.getAppl().getDAOFactory().getLawManager().createLaw(0));
                dbCCF.configureModels(dbObject);
                break;
            }
            case FMEA_MODEL: {
                DBModelFMEA dbCCF = new DBModelFMEA(dbFolderVersion);
                dbCCF.configureModels(dbObject);
                break;
            }
            default: {
                _LOG.severe("Pas de modele de donnee pour l'object '" + dbFolderVersion.toString());
            }
        }
        return dbObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateModelFolder(DBFolderPropertiesPanel dlg) {
        DBFolder modify = dlg.getDBFolder();
        if (modify.getFamily() == DBFolder.Family.BTP_SUBSTANTIATION) {
            DBFolder cancelFolder = new DBFolder(this._dbFolder);
            DBObjProperty propSubst = this._dbFolder.getObject().getProperty("btp.substantiation.date");
            String cancelSubst = propSubst.getValue();
            boolean update = false;
            try {
                this._dbFolder.copyFrom(modify);
                propSubst.setValue(((BTPFolderPropertiesSubstPanel)dlg).getDate());
                update = this.updateDBFolder(this._dbFolder);
            }
            finally {
                if (!update) {
                    this._dbFolder.copyFrom(cancelFolder);
                    propSubst.setValue(cancelSubst);
                }
            }
        } else {
            super.updateModelFolder(dlg);
        }
    }
}

