/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.folders;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BTPFolderPropertiesSubstPanel
extends DBFolderPropertiesPanel {
    private static final Logger _LOG = Logger.getLogger(BTPFolderPropertiesSubstPanel.class.getPackage().getName());
    public static final SimpleDateFormat SUBSTANTIATION_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    JTextField _ctrlTxtDate;

    public BTPFolderPropertiesSubstPanel() {
        this.setDAOFactory(null).setVisiblePath(false).setFamilyTarget(false);
        this.setQuestion(ResMsgVoc.getString("VOC_SUBSTANTIATION"));
        this.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_SUBSTANTIATION"));
        this._ctrlTxtDate = new JTextField(10);
        this._ctrlTxtDate.setText(SUBSTANTIATION_DATE_FORMAT.format(new Date()));
    }

    @Override
    protected Container createCenterPane() {
        JPanel result = new JPanel(new GridBagLayout());
        Container previous = super.createCenterPane();
        result.add((Component)previous, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JLabel lbl = new JLabel(ResMsgObj.getString("DLG_SUBSTANTIATION_DATE"));
        result.add((Component)lbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 5, 5), 0, 0));
        result.add((Component)this._ctrlTxtDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 12), 0, 0));
        if (this.isReadOnly()) {
            this._ctrlTxtDate.setEditable(false);
            this._ctrlTxtDate.setEnabled(false);
        }
        return result;
    }

    public void setDate(String date) {
        if (!this.checkDate(date)) {
            _LOG.info("Date de substantiation invalide : " + date);
        }
        this._ctrlTxtDate.setText(date);
    }

    public String getDate() {
        return this._ctrlTxtDate.getText().trim();
    }

    @Override
    public boolean verifyParameters() {
        if (!this.checkDate(this._ctrlTxtDate.getText().trim())) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgObj.msgFormat("DLG_SUBSTANTIATION_DATE_ERR", this.getDateFormat()), this._title, 2);
            this._ctrlTxtDate.requestFocus();
            return false;
        }
        return super.verifyParameters();
    }

    protected boolean checkDate(String oneDate) {
        try {
            Date date = SUBSTANTIATION_DATE_FORMAT.parse(oneDate);
            String dateString = SUBSTANTIATION_DATE_FORMAT.format(date);
            if (!dateString.equals(oneDate)) {
                return false;
            }
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    private String getDateFormat() {
        return SUBSTANTIATION_DATE_FORMAT.toLocalizedPattern().toLowerCase();
    }
}

