/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.swing.other.CeciliaMetalTheme;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import com.dassault.cecilia.main.cecilia.gui.AltaDesktopPane;
import com.dassault.cecilia.main.cecilia.gui.CHorizontalScrollBox;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CDesktopPane
extends JPanel {
    DeclareActions _actions;
    AltaDesktopPane _ctrlDeskTop;
    CHorizontalScrollBox _ctrlIcones;

    public CDesktopPane() {
        super(new GridBagLayout());
        this.make();
    }

    public CDesktopPane(DeclareActions actions) {
        super(new GridBagLayout());
        this._actions = actions;
        this.make();
    }

    private void make() {
        this._ctrlDeskTop = new AltaDesktopPane(this, true);
        this._ctrlDeskTop.setOpaque(true);
        this._ctrlIcones = new CHorizontalScrollBox();
        this.addReorganizeActions(this._ctrlIcones);
        this.add((Component)this._ctrlDeskTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._ctrlIcones, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public AltaDesktopPane getDesktop() {
        return this._ctrlDeskTop;
    }

    public CHorizontalScrollBox getIconesBox() {
        return this._ctrlIcones;
    }

    private void addReorganizeActions(CHorizontalScrollBox scrollBox) {
        if (this._actions == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        popup.add(this._actions.getAction("REORGANIZE_CASCADE").createMenuItem());
        popup.add(this._actions.getAction("REORGANIZE_MOSAICs").createMenuItem());
        scrollBox._ctrlIcones.setComponentPopupMenu(popup);
        this.getDesktop().setComponentPopupMenu(popup);
    }

    public void updateActions(int sizeWindows) {
        this._actions.getAction("REORGANIZE_CASCADE").setEnabled(sizeWindows > 1);
        this._actions.getAction("REORGANIZE_MOSAICs").setEnabled(sizeWindows > 1 && sizeWindows < 5);
    }

    public static void main(String[] args) {
        try {
            String classUI = UIManager.getSystemLookAndFeelClassName();
            String lookAndFeel = System.getProperty("cecilia.gui.lookandfeel");
            if (lookAndFeel != null) {
                if (lookAndFeel.equalsIgnoreCase("Windows")) {
                    classUI = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                } else if (lookAndFeel.equalsIgnoreCase("Motif")) {
                    classUI = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                } else if (lookAndFeel.equalsIgnoreCase("Cecilia")) {
                    MetalLookAndFeel.setCurrentTheme(new CeciliaMetalTheme());
                } else {
                    classUI = "";
                }
            }
            UIManager.setLookAndFeel(classUI);
            Class<?> classGTKLnF = null;
            try {
                classGTKLnF = CDesktopPane.class.getClassLoader().loadClass("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (classGTKLnF != null && classGTKLnF.isInstance(UIManager.getLookAndFeel())) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception classUI) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        final CDesktopPane ceciliaPane = new CDesktopPane();
        frame.getContentPane().add((Component)ceciliaPane, "Center");
        frame.setTitle("CDesktopPane Example");
        frame.setSize(300, 350);
        frame.setDefaultCloseOperation(2);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    CInternalFrame jframe = new CInternalFrame("C.Internal Frame " + i);
                    jframe.getContentPane().setLayout(new BorderLayout());
                    jframe.getContentPane().add((Component)new JLabel("I love my country"), "Center");
                    jframe.getContentPane().add(jframe.createClosePanel(), "South");
                    jframe.pack();
                    jframe.setSize(250, 85);
                    jframe.showView(ceciliaPane);
                }
            }
        });
        frame.setVisible(true);
    }
}

