/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.reader;

import com.dassault.cecilia.core.ResIcoCore;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ResIcoReader {
    public static Logger _LOG = Logger.getLogger(ResIcoReader.class.getPackage().getName());
    public static final String RESOURCES = ResIcoReader.class.getPackage().getName() + ".Icons";
    public static final String SPLASH_READER = "SPLASH_READER";
    public static final String FRAME_READER = "FRAME_READER";
    protected static Locale _lgg = null;
    protected static ResourceBundle _resBundle = null;

    public static void updateLocale(Locale lgg) {
        if (lgg == null) {
            lgg = Locale.getDefault();
        }
        if (_lgg == null || !_lgg.equals(lgg)) {
            _lgg = lgg;
            _resBundle = ResourceBundle.getBundle(RESOURCES, _lgg);
        }
    }

    static String getResourceString(String key) {
        if (_resBundle == null) {
            ResIcoReader.updateLocale(null);
        }
        try {
            return _resBundle.getString(key);
        }
        catch (MissingResourceException expt) {
            _LOG.warning("Missing resources : " + key);
            return null;
        }
    }

    static URL getResource(String key) {
        String name = ResIcoReader.getResourceString(key);
        if (name != null) {
            URL url = ResIcoCore.class.getClassLoader().getResource(name);
            return url;
        }
        return null;
    }

    public static ImageIcon getImageIcon(String key) {
        URL iconFileName = ResIcoReader.getResource(key);
        if (iconFileName != null) {
            return new ImageIcon(iconFileName);
        }
        _LOG.warning("Missing image : " + key + " : " + iconFileName);
        return null;
    }
}

