/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaOptions;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaParameters;
import com.dassault.cecilia.plugin.mbsa.aralia.PluginCmdAralia;
import com.dassault.cecilia.plugin.mbsa.aralia.ResAralia;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;

public class AraliaTreatment
extends AbstractPluginModel
implements PluginMTreatment {
    public boolean withOption(Plugable plugable) {
        return false;
    }

    public boolean withParameters() {
        return true;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return new AraliaParameters();
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        AraliaParameters clone = new AraliaParameters((AraliaParameters)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    public IOParameters getIOParameters() {
        return AraliaParameters.getIOParameters();
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResAralia.getString("PLUG_TREAT_ARALIA_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResAralia.getString("PLUG_TREAT_ARALIA_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "aralia-treatment";
        }
        if (key.equals("type")) {
            return "PluginTreatment";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-05.svg"));
        }
        return super.getIcon(key);
    }

    public String writeDefine(Plugable launcher, Object parameters) {
        if (parameters == null || !(parameters instanceof AraliaParameters)) {
            return null;
        }
        AraliaParameters params = (AraliaParameters)parameters;
        AraliaOptions options = params.getAraliaOptions();
        File file = PluginCmdAralia.getAraliaFileExecutable(launcher);
        if (file == null) {
            file = new File(FileUtility.getBasePath(((Object)((Object)this)).getClass()), "aralia");
        }
        String pathAralia = file.getAbsolutePath().replace('\\', '/');
        StringBuffer sb = new StringBuffer(512);
        sb.append("      <araliacompute failOnError='false'");
        sb.append(" executable='").append(pathAralia).append("'\n");
        sb.append("         srcfile='").append(params.getInput()).append("'");
        sb.append(" destfile='").append(params.getOutput()).append("'");
        sb.append("    \t    time='").append(options._cutsProductsTime).append("'");
        sb.append(" format='").append(options._format.getCode()).append("'>\n");
        sb.append(options.writeAraliaCompute("    \t  "));
        sb.append("        <destination file='%{log.path}'>\n");
        sb.append("          <param name='Append' value='true'/>\n");
        sb.append("          <layout name='%{log.format}'>\n");
        sb.append("            <param name='Info' value='true'/>\n");
        sb.append("          </layout>\n");
        sb.append("        </destination>\n");
        sb.append("      </araliacompute>\n");
        return sb.toString();
    }

    public String writeCommand(Plugable launcher, Object parameters) {
        return null;
    }
}

