/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.aralia;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.mbsa.abc.PluginCmdABCTree;
import com.dassault.cecilia.plugin.mbsa.abc.UtilityPluginTargetsABC;
import com.dassault.cecilia.plugin.mbsa.aralia.AraliaOptions;
import com.dassault.cecilia.plugin.mbsa.aralia.DlgTargetsAralia;
import com.dassault.cecilia.plugin.mbsa.aralia.ResAralia;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.DlgTargetsSelection;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.UtilityPluginTargetsDB;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PluginCmdAralia
extends PluginCmdABCTree {
    public static final String OPT_ARALIA_EXEC = PluginCmdAralia.class.getName() + "#Execute";
    public static final String OPT_ARALIA_FORMAT = PluginCmdAralia.class.getName() + "#Format";
    public static final String OPT_PROBA = PluginCmdAralia.class.getName() + "#Proba";
    public static final String OPT_PROBA_TIME = PluginCmdAralia.class.getName() + "#ProbaTime";
    public static final String OPT_PROBA_LEAVES = PluginCmdAralia.class.getName() + "#ProbaLeaves";
    public static final String OPT_CUTS = PluginCmdAralia.class.getName() + "#Cuts";
    public static final String OPT_CUTS_ALGO = PluginCmdAralia.class.getName() + "#CutsAlgo";
    public static final String OPT_CUTS_TRUNC = PluginCmdAralia.class.getName() + "#CutsTrunc";
    public static final String OPT_CUTS_TRUNC_ORDER = PluginCmdAralia.class.getName() + "#CutsTruncOrder";
    public static final String OPT_CUTS_ORDERS = PluginCmdAralia.class.getName() + "#CutsOrders";
    public static final String OPT_CUTS_DISPLAY = PluginCmdAralia.class.getName() + "#CutsDisplay";
    public static final String OPT_CUTS_DISPLAY_ORDER = PluginCmdAralia.class.getName() + "#CutsDisplayOrder";
    public static final String OPT_CUTS_DISPLAY_PROBA = PluginCmdAralia.class.getName() + "#CutsDisplayProba";
    public static final String OPT_CUTS_DISPLAY_PROBA_TIME = PluginCmdAralia.class.getName() + "#CutsDisplayProbaTime";
    AraliaOptsPanel _opts = null;
    protected static final String DEFINE_ARALIA_COMPUTE = "<!-- DEFINE ARALIA COMPUTE -->";
    protected static final String CALL_ARALIA_COMPUTE = "<!-- CALL ARALIA COMPUTE -->";

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResAralia.getString("PLUG_CMD_ARALIA_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResAralia.getString("PLUG_CMD_ARALIA_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "alt A";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-02.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new AraliaOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    @Override
    protected boolean verifyConfigPlugin(Plugable launcher) {
        if (!super.verifyConfigPlugin(launcher)) {
            return false;
        }
        File file = PluginCmdAralia.getAraliaFileExecutable(launcher);
        if (file == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResAralia.getString("ERR_ARALIA_LAUNCH"), ResAralia.getString("DEF_TITLE"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected DlgTargetsSelection createComputeOpts(Plugable launcher, Stepper stepper) {
        ViewStepper viewStepper = new ViewStepper();
        try {
            viewStepper.open(stepper);
        }
        catch (StepperException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResAralia.getString("ERR_STEPPER_EXC") + "\n" + e.getMessage(), this.getInfo("plugin.name"), 0);
            return null;
        }
        viewStepper.getRoot().setWithDomain(true);
        TargetModel defTgt = new TargetModel();
        defTgt.defineDefault(launcher, viewStepper, new DefaultFileFilter(){

            public boolean accept(File f) {
                String fname = f.getName().toLowerCase();
                return fname.endsWith(".ara") || f.isDirectory();
            }

            public String getDescription() {
                return "Aralia File(*.ara)";
            }

            public String getDefaultExtension() {
                return ".ara";
            }
        });
        DlgTargetsAralia dlg = new DlgTargetsAralia(launcher.getWindow());
        dlg.create(defTgt);
        if (!dlg.doModal(launcher)) {
            dlg = null;
        }
        viewStepper.close();
        return dlg;
    }

    @Override
    protected UtilityPluginTargetsDB createUtilityPluginTargets(List<TargetModel> targets, String dbConflictOption) {
        return new UtilityPluginTargetsAralia(this, targets);
    }

    @Override
    protected String getID() {
        return "Aralia";
    }

    protected static File getAraliaFileExecutable(Plugable launch) {
        File result = FileUtility.findExecute((String)PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_ARALIA_EXEC, null), (boolean)true, (String)"aralia", PluginCmdAralia.class);
        return result;
    }

    @Override
    protected InputStream getBaseScript() {
        InputStream baseScript = ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptAralia.xml");
        if (baseScript == null) {
            Logger.getLogger(PluginCmdAralia.class.getPackage().getName()).severe("Resource script not found : BanScriptAralia.xml");
            return null;
        }
        return baseScript;
    }

    @Override
    protected AbstractPlugTaskBanWithLog createPlugTask(Plugable launcher, IModel model, BanEntry entry, BanInputStream script, File logFile) {
        return new AbstractPlugTaskBanWithLog(model.getUID(), launcher, entry, script, logFile){

            protected String getDesc() {
                return ResAralia.getString("PLUG_CMD_ARALIA_NAME");
            }

            protected String getName() {
                return "Aralia";
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-02.svg"));
                }
                return super.getIcon(key);
            }
        };
    }

    class UtilityPluginTargetsAralia
    extends UtilityPluginTargetsABC {
        UtilityPluginTargetsAralia(PluginCmdABCTree owner, List<TargetModel> targets) {
            super(owner, targets, null);
            this.addKeyFragment(PluginCmdAralia.DEFINE_ARALIA_COMPUTE);
            this.addKeyFragment(PluginCmdAralia.CALL_ARALIA_COMPUTE);
        }

        @Override
        protected void defineUserProperties(Plugable launch, BanEntry entry) {
            super.defineUserProperties(launch, entry);
            File file = PluginCmdAralia.getAraliaFileExecutable(launch);
            if (file == null) {
                entry.setUserProperty("aralia.exec", FileUtility.getBasePath(((Object)((Object)this)).getClass()) + File.separator + "aralia");
            } else {
                entry.setUserProperty("aralia.exec", file.getAbsolutePath());
            }
            entry.setUserProperty("aralia.format", PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_ARALIA_FORMAT, (String)"XML"));
            try {
                String time = PlugableUtility.getStrOpt((Plugable)launch, (String)OPT_CUTS_DISPLAY_PROBA_TIME, (String)"1").trim();
                Double.parseDouble(time);
                entry.setUserProperty("aralia.time", time);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected String getTargetFilePathToABC(TargetModel tgt) {
            return tgt.getFilePath() + ".ara";
        }

        protected void writeFragment(Plugable launcher, Writer writer, String keyFragment, File logFile) throws IOException {
            if (PluginCmdAralia.DEFINE_ARALIA_COMPUTE.equals(keyFragment)) {
                AraliaOptions options = new AraliaOptions();
                options.loadPreferences(launcher);
                writer.write(options.writeAraliaCompute("       "));
            } else if (PluginCmdAralia.CALL_ARALIA_COMPUTE.equals(keyFragment)) {
                for (TargetModel tgt : this._targets) {
                    writer.write("  <callfunct ref=\"aralia-launch\">\n");
                    writer.write("    <value valuable=\"false\" value=\"");
                    writer.write(XMLWriter.toXML((String)this.getTargetFilePathToABC(tgt)));
                    writer.write("\"/>\n");
                    writer.write("    <value valuable=\"false\" value=\"");
                    writer.write(XMLWriter.toXML((String)tgt.getFilePath()));
                    writer.write("\"/>\n");
                    writer.write("  </callfunct>\n");
                }
            } else if (!"<!-- CALL DATABASE IMPORT -->".equals(keyFragment)) {
                super.writeFragment(launcher, writer, keyFragment, logFile);
            }
        }
    }

    class AraliaOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JLabel _lblExec;
        JTextField _ctrlExec;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlExec.setText(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)OPT_ARALIA_EXEC, (String)""));
        }

        public AraliaOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            this._lblExec = new JLabel(ResAralia.getString("DLG_CMD_ARALIA_EXEC"));
            this._ctrlExec = new JTextField(40);
            this._ctrlExec.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    AraliaOptsPanel.this._launcher.setOption(OPT_ARALIA_EXEC, AraliaOptsPanel.this._ctrlExec.getText());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.add((Component)this._lblExec, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._ctrlExec, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdAralia.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

