/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.ban;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.mbsa.stepper.ban.BanTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.ban.SeqManagerUnit;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFilter;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SeqGen
extends SeqManagerUnit
implements UnitValued {
    protected int _result;
    private String _id;
    private String _start;
    String _stepperId;
    String _modelId;
    protected List<BanTarget> _targets = new ArrayList<BanTarget>();
    protected List<Param> _options = new ArrayList<Param>();
    Filters _filter;
    Filters _invisible;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setId(String value) {
        this._id = value;
    }

    public void setStart(String value) {
        this._start = value;
    }

    public void setStepper(String value) {
        this._stepperId = value;
    }

    protected BanStepper getStepper() {
        String id = this.expanse(this._stepperId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("stepper", id, this._stepperId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + this._stepperId + "' unknow");
        }
        if (!(obj instanceof BanStepper)) {
            throw new BanProcessException("Object with id '" + this._stepperId + "' is not stepper valid (BanStepper)");
        }
        return (BanStepper)obj;
    }

    public void setModel(String value) {
        this._modelId = value;
    }

    protected Model getModel() {
        String id = this.expanse(this._modelId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("model", id, this._modelId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Model '" + this._modelId + "' unknow");
        }
        if (!(obj instanceof Model)) {
            throw new BanProcessException("Object with id '" + this._modelId + "' is not model");
        }
        return (Model)obj;
    }

    public void endValid() {
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
        if (this._targets.size() < 0) {
            throw new BanProcessException("No target define");
        }
        if (this._modelId == null) {
            throw new BanProcessException("No attribut 'model' define");
        }
        if (this._stepperId == null) {
            throw new BanProcessException("No attribut 'stepper' define");
        }
    }

    public BanTarget createTarget() {
        BanTarget tgt = new BanTarget();
        this._targets.add(tgt);
        return tgt;
    }

    public CollectionTargets createTargets() {
        return new CollectionTargets();
    }

    public Param createParam() {
        Param param = new Param();
        this._options.add(param);
        return param;
    }

    public Filters createFilter() {
        if (this._filter != null) {
            throw new BanProcessException("Only one element 'filter' must be exist");
        }
        this._filter = new Filters();
        return this._filter;
    }

    public Filters createInvisible() {
        if (this._invisible != null) {
            throw new BanProcessException("Only one element 'invisible' must be exist");
        }
        this._invisible = new Filters();
        return this._invisible;
    }

    @Override
    public Class configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return LogGenLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return LogGenLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for stepgen unit : " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this._result = -1;
        String id = null;
        if (this._id != null && !this.isSimpleID(id = this.expanse(this._id))) {
            throw this.errorComplexId("id", id, this._id);
        }
        boolean start = true;
        if (this._start != null) {
            start = this.castBool(this.expanse(this._start), "start");
        }
        BanStepper stepper = this.getStepper();
        Model model = this.getModel();
        SeqGenManager seqManager = null;
        try {
            seqManager = new SeqGenManager(stepper, model);
            seqManager.setParams(Param.mapParams(this._options));
            if (this._filter != null && this._filter.apply()) {
                seqManager.setEventFilter(this._filter.convertToSeqFilter());
            }
            if (this._invisible != null && this._invisible.apply()) {
                seqManager.setEventInvisible(this._invisible.convertToSeqFilter());
            }
            for (BanTarget tgt : this._targets) {
                seqManager.addGenTarget(tgt.getName(), tgt.getValue(), tgt.getDstFile(), tgt.getParams());
            }
            for (destination dest : this._destinations) {
                seqManager.addDestination(dest.constructDestination(this));
            }
            if (id != null) {
                this.getProcess().setIdObject(id, seqManager, 1);
            }
            if (start) {
                boolean failOnError = this.getFailOnError();
                this.defineCtrlProcess(seqManager);
                try {
                    this._result = seqManager.run();
                }
                catch (Exception e) {
                    if (failOnError) {
                        throw new BanProcessException(e);
                    }
                    this.log(e.getMessage(), 0);
                }
            }
        }
        finally {
            this.defineCtrlProcess(null);
        }
    }

    public class Filters
    extends BanProcessComponent {
        protected List<FilterEvent> _includes = new ArrayList<FilterEvent>();
        protected List<FilterEvent> _excludes = new ArrayList<FilterEvent>();
        String _apply;

        public void setApply(String value) {
            this._apply = value;
        }

        boolean apply() {
            boolean apply = true;
            if (this._apply != null) {
                apply = this.castBool(this.expanse(this._apply), "apply");
            }
            return apply;
        }

        public FilterEvent createInclude() {
            FilterEvent include = new FilterEvent();
            this._includes.add(include);
            return include;
        }

        public FilterEvent createExclude() {
            FilterEvent include = new FilterEvent();
            this._excludes.add(include);
            return include;
        }

        SeqFilter<Event> convertToSeqFilter() {
            SeqFilter<Event> filter;
            SeqFilter.SeqFilterContainer<Event> result = SeqFilter.createFilterContainerEvent();
            for (FilterEvent fEvt : this._includes) {
                filter = fEvt.convertToSeqFilter();
                if (filter == null) continue;
                result.addInclude(filter);
            }
            for (FilterEvent fEvt : this._excludes) {
                filter = fEvt.convertToSeqFilter();
                if (filter == null) continue;
                result.addExclude(filter);
            }
            return result;
        }
    }

    public class FilterEvent
    extends BanProcessComponent {
        FilterType _type = FilterType.undef;
        String _key;
        String _value;

        public void setName(String value) {
            if (this._type != FilterType.undef) {
                throw new BanProcessException("Exclusive attribute between '" + (Object)((Object)this._type) + "' and 'name'.");
            }
            this._key = value;
            this._type = FilterType.name;
        }

        public void setDepend(String value) {
            if (this._type != FilterType.undef) {
                throw new BanProcessException("Exclusive attribute between '" + (Object)((Object)this._type) + "' and 'depend'.");
            }
            this._key = value;
            this._type = FilterType.depend;
        }

        public void setDependtargets(String value) {
            if (this._type != FilterType.undef) {
                throw new BanProcessException("Exclusive attribute between '" + (Object)((Object)this._type) + "' and 'dependtargets'.");
            }
            this._key = value;
            this._type = FilterType.dependtargets;
        }

        public void setInstantaneous(String value) {
            if (this._type != FilterType.undef) {
                throw new BanProcessException("Exclusive attribute between '" + (Object)((Object)this._type) + "' and 'instantaneous'.");
            }
            this._key = value;
            this._type = FilterType.instantaneous;
        }

        public void setAttribute(String value) {
            if (this._type != FilterType.undef) {
                throw new BanProcessException("Exclusive attribute between '" + (Object)((Object)this._type) + "' and 'attribute'.");
            }
            this._key = value;
            this._type = FilterType.attribute;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public void endValid() {
            if (this._type == FilterType.undef) {
                throw new BanProcessException("Not typed filter");
            }
            if (this._value != null && this._type != FilterType.attribute) {
                throw new BanProcessException("Attribut 'value' must be used only with attribute 'attribute'");
            }
        }

        public SeqFilter<Event> convertToSeqFilter() {
            String rKey = this.expanse(this._key);
            switch (this._type) {
                case name: {
                    return SeqFilter.createFilterEventNames(rKey);
                }
                case depend: {
                    return SeqFilter.createFilterEventDepends(rKey);
                }
                case dependtargets: {
                    if (this.castBool(rKey, "dependtargets")) {
                        return SeqFilter.createFilterEventDependTargets();
                    }
                    return null;
                }
                case instantaneous: {
                    if (this.castBool(rKey, "instantaneous")) {
                        return SeqFilter.createFilterEventInstantaneous();
                    }
                    return null;
                }
                case attribute: {
                    return SeqFilter.createFilterEventAttributes(rKey, this.expanse(this._value));
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static enum FilterType {
        undef,
        name,
        depend,
        dependtargets,
        attribute,
        instantaneous;

    }

    public class CollectionTargets
    extends BanProcessComponent {
        public BanTarget createTarget() {
            BanTarget tgt = new BanTarget();
            SeqGen.this._targets.add(tgt);
            return tgt;
        }
    }
}

