/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetAbstract;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class ResultSetMinSeqs
extends ResultSetAbstract {
    int _maxAddArray;
    Comparator _comparator = null;
    ArrayList<Set> _setArray = new ArrayList(6);
    boolean _bSetIsTrue = false;
    ArrayList<Set> _addArray = new ArrayList(6);
    int _sizeAddArray = 0;

    public ResultSetMinSeqs() {
        this(true, -1);
    }

    public ResultSetMinSeqs(boolean idxEvt, int max) {
        this.createComparator();
        this._getIdxEvt = idxEvt;
        if (max == -1) {
            max = 1000;
        }
        this._maxAddArray = max;
    }

    protected void createComparator() {
        this._comparator = new Comparator(){

            public int compare(Object O1, Object O2) {
                ModelTrans[] o1 = (ModelTrans[])O1;
                ModelTrans[] o2 = (ModelTrans[])O2;
                int res = o1.length - o2.length;
                if (res != 0) {
                    return res;
                }
                for (int i = 0; i < o1.length; ++i) {
                    res = ResultSetMinSeqs.this._getIdxEvt ? o1[i].getIdxEvt() - o2[i].getIdxEvt() : o1[i].getIdx() - o2[i].getIdx();
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        };
    }

    private void setSetAsTrue() {
        this.clearAddArray();
        TreeSet<ModelTrans[]> set = new TreeSet<ModelTrans[]>(this._comparator);
        set.add(new ModelTrans[0]);
        this._setArray = new ArrayList(1);
        this._setArray.add(set);
        this._bSetIsTrue = true;
    }

    private void clearAddArray() {
        for (int i = 0; i < this._addArray.size(); ++i) {
            Set set = this._addArray.get(i);
            if (set == null) continue;
            set.clear();
        }
        this._addArray.clear();
        this._sizeAddArray = 0;
    }

    @Override
    protected boolean includedSet(ModelTrans[] ref, ModelTrans[] oth) {
        int idx = 0;
        for (int i = 0; i < oth.length; ++i) {
            boolean find = false;
            while (!find && idx < ref.length) {
                if (this._getIdxEvt) {
                    if (oth[i].getIdxEvt() == ref[idx].getIdxEvt()) {
                        find = true;
                    }
                } else if (oth[i].getIdx() == ref[idx].getIdx()) {
                    find = true;
                }
                ++idx;
            }
            if (find) continue;
            return false;
        }
        return true;
    }

    protected void suppressResult(Set ref, Set oth) {
        Iterator iRef = ref.iterator();
        block0: while (iRef.hasNext()) {
            ModelTrans[] trRef = (ModelTrans[])iRef.next();
            Iterator iOth = oth.iterator();
            while (iOth.hasNext()) {
                if (!this.includedSet(trRef, (ModelTrans[])iOth.next())) continue;
                iRef.remove();
                continue block0;
            }
        }
    }

    protected void mergeResult() {
        int setSize = this._setArray.size();
        int addSize = this._addArray.size();
        this._setArray.ensureCapacity(addSize + 1);
        while (this._setArray.size() <= addSize) {
            this._setArray.add(null);
        }
        for (int i = 0; i < addSize; ++i) {
            Set set;
            int j;
            Set add = this._addArray.get(i);
            if (add == null) continue;
            for (j = 1; j < i; ++j) {
                set = this._setArray.get(j);
                if (set == null) continue;
                this.suppressResult(add, set);
            }
            for (j = i; j < setSize; ++j) {
                set = this._setArray.get(j);
                if (set == null) continue;
                this.suppressResult(set, add);
            }
            TreeSet set2 = this._setArray.get(i);
            if (set2 == null) {
                set2 = new TreeSet(this._comparator);
                this._setArray.set(i, set2);
            }
            set2.addAll(add);
        }
        this.clearAddArray();
    }

    private void addRealSeq(ModelTrans[] add) {
        if (this._bSetIsTrue) {
            return;
        }
        int order = add.length;
        if (order == 0) {
            this.setSetAsTrue();
            return;
        }
        this._addArray.ensureCapacity(order + 1);
        while (this._addArray.size() <= order) {
            this._addArray.add(null);
        }
        TreeSet<ModelTrans[]> set = this._addArray.get(order);
        if (set == null) {
            set = new TreeSet<ModelTrans[]>(this._comparator);
            this._addArray.set(order, set);
        }
        set.add(add);
        ++this._sizeAddArray;
        if (this._sizeAddArray >= this._maxAddArray) {
            this.mergeResult();
        }
    }

    @Override
    public void addSeq(ModelTrans[] trs, int order) {
        ModelTrans[] add = this.clone(trs, order);
        this.addRealSeq(add);
    }

    @Override
    public void addSeq(List<ModelTrans> trs, boolean error) {
        ModelTrans[] add = this.convert(trs);
        this.addRealSeq(add);
    }

    @Override
    public void addSeq(ModelTrans[] trs) {
        this.addRealSeq(trs);
    }

    @Override
    public void flush() {
        if (this._sizeAddArray > 0) {
            this.mergeResult();
        }
    }

    @Override
    public Iterator getSeqIterator() {
        class SeqIterator
        implements Iterator {
            Iterator<Set> iSet;
            Iterator iObj;

            SeqIterator() {
                this.iSet = ResultSetMinSeqs.this._setArray.iterator();
                this.findNext();
            }

            void findNext() {
                this.iObj = null;
                while (this.iSet.hasNext()) {
                    Set cSet = this.iSet.next();
                    if (cSet == null) continue;
                    this.iObj = cSet.iterator();
                    if (!this.iObj.hasNext()) continue;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.iObj == null) {
                    return false;
                }
                if (this.iObj.hasNext()) {
                    return true;
                }
                this.findNext();
                if (this.iObj == null) {
                    return false;
                }
                return this.iObj.hasNext();
            }

            public Object next() {
                if (this.iObj == null || !this.iObj.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.iObj.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new SeqIterator();
    }

    @Override
    public String getSeqAbstract() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("/* Order of products :\n");
        for (int i = 0; i < this._setArray.size(); ++i) {
            Set set = this._setArray.get(i);
            if (set == null || set.size() == 0) continue;
            sb.append("\t");
            sb.append(Integer.toString(i));
            sb.append("\t");
            sb.append(Integer.toString(set.size()));
            sb.append("\n");
        }
        sb.append(" */\n");
        return sb.toString();
    }

    @Override
    public Map<Integer, Integer> getOrders() {
        LinkedHashMap<Integer, Integer> orders = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < this._setArray.size(); ++i) {
            Set set = this._setArray.get(i);
            if (set == null || set.size() == 0) continue;
            orders.put(i, set.size());
        }
        return orders;
    }

    @Override
    public String getShortName() {
        return "MSS";
    }
}

