/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.translator.model.ABool;
import com.dassault.cecilia.lib.mbsa.translator.model.AFloat;
import com.dassault.cecilia.lib.mbsa.translator.model.AInteger;
import com.dassault.cecilia.lib.mbsa.translator.model.ANumber;
import com.dassault.cecilia.lib.mbsa.translator.model.AString;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class SeqFilter<E> {
    public void prepare(Node owner, List<SeqGenTarget> targets) {
    }

    public abstract boolean accept(E var1);

    public void clean() {
    }

    public SeqFilterContainer<E> createFilterContainer() {
        return new SeqFilterContainer();
    }

    public static SeqFilterContainer<Event> createFilterContainerEvent() {
        return new SeqFilterContainer<Event>();
    }

    public static SeqFilter<Event> createFilterEventDepends(String patternVars) {
        return new SeqFilterDepend(patternVars);
    }

    public static SeqFilter<Event> createFilterEventDependTargets() {
        return new SeqFilterDependTargets();
    }

    public static SeqFilter<Event> createFilterEventNames(String patternName) {
        return new SeqFilterString<Event>(patternName){

            @Override
            public String getString(Event evt) {
                return evt.getName();
            }
        };
    }

    public static SeqFilter<Event> createFilterEventInstantaneous() {
        return new SeqFilterInstantaneous();
    }

    public static SeqFilter<Event> createFilterEventAttributes(String nameAttribute, String operation) {
        return new SeqFilterAttribute(nameAttribute, operation);
    }

    static class SeqFilterInstantaneous
    extends SeqFilter<Event> {
        Node _owner;
        Tree _treeEvt;

        SeqFilterInstantaneous() {
        }

        @Override
        public void prepare(Node owner, List<SeqGenTarget> targets) {
            this._owner = owner;
            this._treeEvt = new Tree(268, 0L, 0.0, "", null, null);
        }

        @Override
        public boolean accept(Event evt) {
            this._treeEvt._son = evt;
            Extern xLaw = this._owner.findExtern("law", this._treeEvt);
            if (xLaw == null) {
                return false;
            }
            return xLaw.delayOfLaw(this._owner) == 0.0;
        }
    }

    static class SeqFilterAttribute
    extends SeqFilter<Event> {
        String _name;
        String _compare;

        SeqFilterAttribute(String name, String compare) {
            this._name = name;
            this._compare = compare;
        }

        private int compare(ANumber value, String toCompare) {
            if (value instanceof ABool) {
                int val = value.getBool() ? 1 : 0;
                return val -= toCompare.equalsIgnoreCase("true") ? 1 : 0;
            }
            if (value instanceof AString) {
                return toCompare.compareTo(value.getSymbol());
            }
            if (value instanceof AInteger) {
                long val = value.getInt();
                return (val -= Long.parseLong(toCompare)) == 0L ? 0 : (val > 0L ? 1 : -1);
            }
            if (value instanceof AFloat) {
                double val = value.getFloat();
                return (val -= Double.parseDouble(toCompare)) == 0.0 ? 0 : (val > 0.0 ? 1 : -1);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean accept(Event data) {
            ANumber value = data.getAttribute(this._name);
            if (value == null) {
                return false;
            }
            if (this._compare == null || this._compare.length() == 0) {
                return true;
            }
            if (this._compare.startsWith("==")) {
                return this.compare(value, this._compare.substring(2).trim()) == 0;
            }
            if (this._compare.startsWith("=")) {
                return this.compare(value, this._compare.substring(1).trim()) == 0;
            }
            if (this._compare.startsWith("!=")) {
                return this.compare(value, this._compare.substring(2).trim()) != 0;
            }
            if (this._compare.startsWith("#")) {
                return this.compare(value, this._compare.substring(1).trim()) != 0;
            }
            if (this._compare.startsWith(">=")) {
                return this.compare(value, this._compare.substring(2).trim()) >= 0;
            }
            if (this._compare.startsWith(">")) {
                return this.compare(value, this._compare.substring(1).trim()) > 0;
            }
            if (this._compare.startsWith("<=")) {
                return this.compare(value, this._compare.substring(2).trim()) <= 0;
            }
            if (this._compare.startsWith("<")) {
                return this.compare(value, this._compare.substring(1).trim()) < 0;
            }
            return false;
        }
    }

    static class SeqFilterDependTargets
    extends SeqFilter<Event> {
        Set<Event> _events;

        SeqFilterDependTargets() {
        }

        @Override
        public boolean accept(Event evt) {
            if (this._events == null) {
                return false;
            }
            return this._events.contains(evt);
        }

        @Override
        public void prepare(Node owner, List<SeqGenTarget> targets) {
            Var var;
            int i;
            HashSet<String> _nameTargets = new HashSet<String>();
            for (SeqGenTarget tgt : targets) {
                _nameTargets.add(tgt.getName());
            }
            owner.groupsDependConstruct();
            ArrayList<Var> vars = new ArrayList<Var>();
            int nbr = owner.getStateCount();
            for (i = 0; i < nbr; ++i) {
                var = owner.getState(i);
                if (!_nameTargets.contains(var.getName())) continue;
                vars.add(var);
            }
            nbr = owner.getFlowCount();
            for (i = 0; i < nbr; ++i) {
                var = owner.getFlow(i);
                if (!_nameTargets.contains(var.getName())) continue;
                vars.add(var);
            }
            this._events = new HashSet<Event>(owner.groupsDependVariables(vars));
        }

        @Override
        public void clean() {
            this._events = null;
        }
    }

    static class SeqFilterDepend
    extends SeqFilter<Event> {
        Pattern _patternVars;
        Set<Event> _events;

        SeqFilterDepend(String patternVars) {
            this._patternVars = Pattern.compile(patternVars);
        }

        @Override
        public boolean accept(Event evt) {
            if (this._events == null) {
                return false;
            }
            return this._events.contains(evt);
        }

        @Override
        public void prepare(Node owner, List<SeqGenTarget> targets) {
            Var var;
            int i;
            owner.groupsDependConstruct();
            ArrayList<Var> vars = new ArrayList<Var>();
            int nbr = owner.getStateCount();
            for (i = 0; i < nbr; ++i) {
                var = owner.getState(i);
                if (!this._patternVars.matcher(var.getName()).find()) continue;
                vars.add(var);
            }
            nbr = owner.getFlowCount();
            for (i = 0; i < nbr; ++i) {
                var = owner.getFlow(i);
                if (!this._patternVars.matcher(var.getName()).find()) continue;
                vars.add(var);
            }
            this._events = new HashSet<Event>(owner.groupsDependVariables(vars));
        }

        @Override
        public void clean() {
            this._events = null;
        }
    }

    static abstract class SeqFilterString<E>
    extends SeqFilter<E> {
        Pattern _pattern;

        SeqFilterString(String pattern) {
            this._pattern = Pattern.compile(pattern);
        }

        public abstract String getString(E var1);

        @Override
        public boolean accept(E data) {
            return this._pattern.matcher(this.getString(data)).find();
        }
    }

    public static class SeqFilterContainer<E>
    extends SeqFilter<E> {
        private Collection<SeqFilter<E>> _includes = new ArrayList<SeqFilter<E>>();
        private Collection<SeqFilter<E>> _excludes = new ArrayList<SeqFilter<E>>();

        SeqFilterContainer() {
        }

        public void addInclude(SeqFilter<E> include) {
            this._includes.add(include);
        }

        public void addExclude(SeqFilter<E> exclude) {
            this._excludes.add(exclude);
        }

        @Override
        public void prepare(Node owner, List<SeqGenTarget> targets) {
            super.prepare(owner, targets);
            for (SeqFilter<E> filter : this._includes) {
                filter.prepare(owner, targets);
            }
            for (SeqFilter<E> filter : this._excludes) {
                filter.prepare(owner, targets);
            }
        }

        @Override
        public boolean accept(E data) {
            boolean include = false;
            if (this._includes.size() > 0) {
                for (SeqFilter<E> filter : this._includes) {
                    if (!filter.accept(data)) continue;
                    include = true;
                    break;
                }
            } else {
                include = true;
            }
            if (!include) {
                return false;
            }
            boolean exclude = false;
            if (this._excludes.size() > 0) {
                for (SeqFilter<E> filter : this._excludes) {
                    if (!filter.accept(data)) continue;
                    exclude = true;
                    break;
                }
            }
            return !exclude;
        }

        @Override
        public void clean() {
            super.clean();
            for (SeqFilter<E> filter : this._includes) {
                filter.clean();
            }
            for (SeqFilter<E> filter : this._excludes) {
                filter.clean();
            }
        }
    }
}

