/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinderStd;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGameCombIterator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StatUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SeqFinderBasic
extends SeqFinderStd {
    public SeqFinderBasic(int order) {
        super(order);
    }

    @Override
    public double init(SeqGenerator simul) {
        super.init(simul);
        this._dspMaxTest = StatUtil.Combinaison(this._order, this._trList.size());
        return this._dspMaxTest;
    }

    private void findSequence(int boucle, int index, boolean next, List<ModelTrans> begin) throws StepperException {
        if (boucle == this._order) {
            int i;
            int cptStep = 0;
            boolean isMinimal = true;
            for (i = 0; isMinimal && i < this._order; ++i) {
                if (this._tgt.verifyTarget(this._simul, null)) {
                    isMinimal = false;
                }
                if (this._simul.isValidTransition(this._cut[i])) break;
                this._simul.goForward(this._cut[i]);
                ++this._stepNbr;
                ++cptStep;
            }
            if (isMinimal && this._tgt.addSequence(this._simul, this._cut, i)) {
                ++this._addCut;
            }
            this._simul.goBackward(cptStep);
            this._simul.changeProgress(this._dspNbrTest += 1.0, Double.NaN);
        } else {
            boolean playNext = next;
            for (int i = index; i < this._trList.size(); ++i) {
                this._cut[boucle] = (ModelTrans)this._trList.get(i);
                if (next) {
                    if (this._cut[boucle] != begin.get(boucle)) continue;
                    next = false;
                    if (boucle == begin.size() - 1) {
                        playNext = false;
                        this._cut[boucle] = null;
                        continue;
                    }
                }
                this.findSequence(boucle + 1, i + 1, playNext, begin);
                playNext = false;
            }
        }
    }

    @Override
    protected void playSimul(List<ModelTrans> currentSeq) throws StepperException {
        this.findSequence(0, 0, currentSeq != null, currentSeq);
    }

    @Override
    protected String getKeyHeader() {
        return "MSG_CMD_SEQ_FINDER_BASIC_TITLE";
    }

    @Override
    public void printFooter() {
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_ENDAT", new Date()));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRSEQ", this._dspNbrTest));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRSTEP", this._stepNbr));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_ADDCUT", this._addCut));
        this._simul.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_LN", new Object[0]));
        SeqFinderBasic.displayTime(this._timer, "MSG_CMD_SEQ_FINDER_DELAY", this._simul);
    }

    @Override
    public Iterator<SeqGame> getGames(int initSize) {
        return new SeqGameCombIterator(this._simul.getTransIndexes(), initSize);
    }

    @Override
    public int getNbGame(int size) {
        int nbTrans = this._simul.getTransIndexes().size();
        int factNsurFactNmoinsSize = 1;
        for (int i = 0; i < size; ++i) {
            factNsurFactNmoinsSize *= nbTrans - i;
        }
        return factNsurFactNmoinsSize;
    }
}

