/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.MsgStepUser;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetFlow;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetState;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTransStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqFinder;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenAbstract;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqParameters;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqTargetAbstract;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqTargetContainer;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StepperInterruptInternalException;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.util.destination.Destination;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;

public class SeqGenerator
extends SeqGenAbstract {
    private int _changeCheck;
    private int _changeCpt;
    protected int _errorCheck;
    private Stepper _stepper;
    private SeqParameters _parameters;
    private SeqTargetAbstract _target;
    private ArrayList<ModelTrans> _transLst;
    private ArrayList<Integer> _transIdxLst;
    private Map<Integer, ModelTrans> _transMap;
    private List<Integer> _initTransIdx;
    SeqFinder _seqFinder;
    private List<LogGenRecord> _errorList;
    private double _maxSeq;
    private double _curSeq;
    List<Destination> _destinations = new ArrayList<Destination>(2);

    public SeqGenerator(Stepper stepper) {
        this._stepper = stepper;
        this._changeCheck = 1000;
        this._changeCpt = 1000;
        this._errorCheck = 10;
        this._curSeq = -1.0;
        this._transMap = null;
    }

    protected Map<Integer, ModelTrans> getTransitionsMap() {
        if (this._transMap == null) {
            this._transMap = new TreeMap<Integer, ModelTrans>();
            int nbrTrans = this._stepper.getNbrTransition();
            HashMap<String, Integer> idxEvtMap = new HashMap<String, Integer>();
            int j = 0;
            for (int i = 1; i <= nbrTrans; ++i) {
                String name = this._stepper.getNameOfTransition(i);
                Integer idxEvt = (Integer)idxEvtMap.get(name);
                if (idxEvt == null) {
                    idxEvt = j++;
                    idxEvtMap.put(name, idxEvt);
                }
                String desc = this._stepper.getDescOfTransition(i);
                ModelTransStepper tr = new ModelTransStepper(i, name, desc, idxEvt);
                this._transMap.put(i, tr);
            }
        }
        return this._transMap;
    }

    public void setParams(SeqParameters params) {
        String strProgressStep;
        this._parameters = params;
        this._seqFinder = this._parameters.createFinder();
        this._errorList = new ArrayList<LogGenRecord>();
        String strErrorMax = this._parameters.getParam("error.max");
        if (strErrorMax != null && strErrorMax.length() > 0) {
            try {
                int iErrorMax = Integer.parseInt(strErrorMax);
                if (iErrorMax <= 0) {
                    iErrorMax = 10;
                }
                this._errorCheck = iErrorMax;
            }
            catch (NumberFormatException iErrorMax) {
                // empty catch block
            }
        }
        if ((strProgressStep = this._parameters.getParam("progress.step")) != null && strProgressStep.length() > 0) {
            try {
                int iProgressStep = Integer.parseInt(strProgressStep);
                if (iProgressStep <= 0) {
                    iProgressStep = 1000;
                }
                this._changeCpt = this._changeCheck = iProgressStep;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void addTarget(String name, String value, File resultFile, Map<String, String> params) throws StepperException {
        int i;
        ModelTargetVar tgt = null;
        for (i = this._stepper.getNbrFlow(); i > 0 && tgt == null; --i) {
            if (!this._stepper.getNameOfFlow(i).equals(name)) continue;
            tgt = new ModelTargetFlow(name, i);
        }
        for (i = this._stepper.getNbrState(); i > 0 && tgt == null; --i) {
            if (!this._stepper.getNameOfState(i).equals(name)) continue;
            tgt = new ModelTargetState(name, i);
        }
        if (tgt == null) {
            throw new StepperException(MessageFormat.format(MsgStepUser.getString("ERR_NO_VAR_FIND"), name));
        }
        tgt.setStrValue(value);
        tgt.verifyValue(this._stepper);
        ResultSet rset = null;
        SeqParameters seqParams = new SeqParameters(params);
        rset = seqParams.createResultSet();
        if (rset == null) {
            rset = this._parameters.createResultSet();
        }
        if (rset == null) {
            rset = this._parameters.defaultResultSet();
        }
        SeqGenTarget initTgt = null;
        HashMap<String, String> initParam = new HashMap<String, String>(this._parameters.getParams());
        initParam.putAll(params);
        initTgt = new SeqGenTarget(name, value, resultFile, initParam);
        if (this._target == null) {
            this._target = new SeqTarget(initTgt, tgt, resultFile, rset);
        } else {
            if (!(this._target instanceof SeqTargetContainer)) {
                SeqTargetAbstract tmpTgt = this._target;
                this._target = new SeqTargetContainer();
                ((SeqTargetContainer)this._target).addTarget(tmpTgt);
            }
            ((SeqTargetContainer)this._target).addTarget(new SeqTarget(initTgt, tgt, resultFile, rset));
        }
    }

    public void setTarget(SeqTargetAbstract cloneTarget) {
        assert (cloneTarget != null);
        this._target = cloneTarget;
    }

    public void setPlayTrans(Collection<Integer> transIdx) throws StepperException {
        this._transLst = new ArrayList();
        this._transIdxLst = new ArrayList();
        int nbrTrans = this._stepper.getNbrTransition();
        if (transIdx == null) {
            for (int idx = 1; idx <= nbrTrans; ++idx) {
                ModelTrans tr = this.getTransitionsMap().get(idx);
                this._transLst.add(tr);
                this._transIdxLst.add(idx);
            }
        } else {
            for (Integer idx : transIdx) {
                if (idx < 1 || idx > nbrTrans) {
                    throw new StepperException("BadIndice of transition : " + idx);
                }
                ModelTrans tr = this.getTransitionsMap().get(idx);
                if (tr == null) {
                    throw new StepperException("Unknow transition : " + idx);
                }
                this._transLst.add(tr);
                this._transIdxLst.add(idx);
            }
        }
    }

    public List<ModelTrans> setInitTrans(Collection<Integer> transIdx) throws StepperException {
        ArrayList<ModelTrans> result = new ArrayList<ModelTrans>();
        this._initTransIdx = new ArrayList<Integer>();
        if (transIdx == null) {
            return result;
        }
        int nbrTrans = this._stepper.getNbrTransition();
        for (Integer idx : transIdx) {
            if (idx < 1 || idx > nbrTrans) {
                throw new StepperException("BadIndice of transition : " + idx);
            }
            ModelTrans tr = this.getTransitionsMap().get(idx);
            if (tr == null) {
                throw new StepperException("Unknow transition : " + idx);
            }
            this._initTransIdx.add(idx);
            result.add(tr);
        }
        return result;
    }

    public double InitFinder() throws StepperException {
        if (this._stepper == null) {
            throw new StepperException("No Stepper");
        }
        if (this._target == null) {
            throw new StepperException("No Target");
        }
        if (this._seqFinder == null) {
            throw new StepperException("No Finder");
        }
        if (this._transLst == null) {
            this.setPlayTrans(null);
        }
        return this._seqFinder.init(this);
    }

    public int SeqFinder() throws StepperException {
        int result = -1;
        try {
            this.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE", new Object[0]));
            this.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_TARGET", this._target.toString()));
            this._seqFinder.printHeader();
            this.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
            this._seqFinder.playSimul();
            result = this.getNbrError();
            this._seqFinder.printFooter();
        }
        catch (StepperException sie) {
            throw sie;
        }
        catch (Exception exc) {
            throw new StepperException(exc.getClass().getName() + " : " + exc.getMessage());
        }
        return result;
    }

    public void saveResultSet() throws IOException {
        String header = "";
        if (this._initTransIdx != null) {
            StringBuffer sb = new StringBuffer(this._initTransIdx.size() * 4);
            for (int i = 0; i < this._initTransIdx.size(); ++i) {
                int idx = this._initTransIdx.get(i);
                sb.append(idx);
                sb.append(" ");
            }
            header = sb.toString();
        }
        this._target.saveResultSet(header);
    }

    public int loadResultSet(ZipInputStream zipStream) throws IOException {
        return this._target.loadResultSet(zipStream, this.getTransitionsMap(), 0);
    }

    @Override
    public int execute() throws StepperException {
        return this.SeqFinder();
    }

    public void printResultSet(Node node) throws IOException {
        FormatSeqs layout2 = this._parameters.createFormat(node);
        this.getTarget().printResultSet(layout2, this);
    }

    ArrayList<ModelTrans> getTranss() {
        return this._transLst;
    }

    List<Integer> getTransIndexes() {
        return this._transIdxLst;
    }

    public SeqTargetAbstract getTarget() {
        return this._target;
    }

    public List<LogGenRecord> getErrorList() {
        return this._errorList;
    }

    public SeqParameters getParams() {
        return this._parameters;
    }

    public void changeProgress(double cur, double max) throws StepperException {
        --this._changeCpt;
        if (this._changeCpt >= 0) {
            return;
        }
        this._changeCpt = this._changeCheck;
        this._curSeq = cur;
        if (!Double.isNaN(max)) {
            this._maxSeq = max;
        }
        if (this._maxSeq < this._curSeq) {
            this._maxSeq = this._curSeq;
        }
        this.requestStopOrResume();
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg.high")) {
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._curSeq >= this._maxSeq ? this._maxSeq : this._curSeq + 1.0);
            msg.append("/");
            msg.append(this._maxSeq);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString(this._curSeq < 0.0 ? 0 : (int)(this._curSeq / this._maxSeq * 1000.0));
        }
        return null;
    }

    void appendInitList(StringBuffer sb, int limit) {
        if (this._initTransIdx == null) {
            return;
        }
        for (int i = 0; i < this._initTransIdx.size(); ++i) {
            int idx = this._initTransIdx.get(i++);
            if (limit >= 0 && i > limit) break;
            sb.append("\t\t");
            sb.append(this._stepper.getNameOfTransition(idx));
            sb.append("\t");
            sb.append(idx);
            sb.append("\t:\t");
            sb.append(this._stepper.getDescOfTransition(idx));
            sb.append("\n");
        }
    }

    int goInitialState() throws StepperException {
        this._stepper.goInitialState();
        ArrayList<ModelTrans> initList = new ArrayList<ModelTrans>();
        if (this._initTransIdx != null && this._initTransIdx.size() > 0) {
            int i = 0;
            try {
                if (this._target.verifyTarget(this, initList)) {
                    return -1;
                }
                while (i < this._initTransIdx.size()) {
                    int n = i++;
                    int idx = this._initTransIdx.get(n);
                    if (this._stepper.isValidTransition(idx) < 0.0) {
                        return -1;
                    }
                    this._stepper.goForward(idx);
                    ModelTrans tr = this.getTransitionsMap().get(idx);
                    assert (tr != null);
                    initList.add(tr);
                    if (i >= this._initTransIdx.size() || !this._target.verifyTarget(this, initList)) continue;
                    return -1;
                }
            }
            catch (StepperException e) {
                StringBuffer sb = new StringBuffer(128);
                this.appendInitList(sb, i);
                this.addError(new LogGenRecord(e, "MSG_CMD_SEQ_ERROR", "1", e.getMessage(), sb.toString()));
                return 1;
            }
        }
        return 0;
    }

    void goForward(ModelTrans trans) throws StepperException {
        this._stepper.goForward(trans.getIdx());
    }

    void goBackward(int nbrTrans) throws StepperException {
        this._stepper.goBackward(nbrTrans);
    }

    boolean isValidTransition(ModelTrans trans) throws StepperException {
        return this._stepper.isValidTransition(trans.getIdx()) >= 0.0;
    }

    boolean isActiveTarget(ModelTarget tgt) {
        return tgt.isActive(this._stepper);
    }

    public void addDestination(Destination destination2) {
        if (destination2 != null) {
            this._destinations.add(destination2);
        }
    }

    public void removeDestination(Destination destination2) {
        if (destination2 != null) {
            this._destinations.remove(destination2);
        }
    }

    public void addRecord(LogGenRecord record) {
        for (int i = 0; i < this._destinations.size(); ++i) {
            this._destinations.get(i).publish(record);
        }
        Level level = Level.INFO;
        switch (record.getType()) {
            case EXC: {
                level = Level.WARNING;
                break;
            }
            case ERR: {
                level = Level.INFO;
                break;
            }
            case WARN: {
                level = Level.FINE;
                break;
            }
            case INFO: {
                level = Level.FINER;
            }
        }
        MsgStepUser.LOG.log(level, record.getMessage());
    }

    protected void addError(LogGenRecord record) throws StepperInterruptInternalException {
        if (this.getNbrError() >= this.getMaxError()) {
            throw new StepperInterruptInternalException();
        }
        this._errorList.add(record);
        this.addRecord(record);
        if (this.getNbrError() >= this.getMaxError()) {
            throw new StepperInterruptInternalException();
        }
    }

    protected void addError(Exception se, String currentSeq) throws StepperInterruptInternalException {
        this.addError(new LogGenRecord(se, "MSG_CMD_SEQ_ERROR", Integer.toString(this.getNbrError() + 1), se.getMessage(), currentSeq));
    }

    protected int getNbrError() {
        return this._errorList.size();
    }

    protected int getMaxError() {
        return this._errorCheck;
    }

    public void close() {
        for (int i = 0; i < this._destinations.size(); ++i) {
            this._destinations.get(i).close();
        }
    }

    void printNbrTransUsed() {
        for (ModelTrans tr : this._transLst) {
            tr._flag = false;
        }
        this._target.setTransitionsFlag(true);
        int nbrTransUsed = 0;
        for (ModelTrans tr : this._transLst) {
            if (!tr._flag) continue;
            ++nbrTransUsed;
        }
        this.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRTRANS", nbrTransUsed));
    }
}

