/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSet;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetFactory;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqTargetAbstract;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class SeqTarget
implements SeqTargetAbstract {
    SeqGenTarget _initTgt;
    ModelTarget _modelTgt;
    ResultSet _rset;
    File _rfile;
    List<ModelTrans> _initError;

    SeqTarget(SeqGenTarget initTgt, ModelTarget modelTgt, File file, ResultSet rset) {
        this._initTgt = initTgt;
        this._modelTgt = modelTgt;
        this._rfile = file;
        this._rset = rset;
    }

    @Override
    public SeqTargetAbstract cloneTarget(ResultSetFactory rsf) {
        SeqTarget tgt = new SeqTarget(new SeqGenTarget(this._initTgt), this._modelTgt.cloneTarget(), this._rfile, rsf == null ? this._rset : rsf.createResultSet(this._rset));
        return tgt;
    }

    @Override
    public void getTargets(Collection<SeqGenTarget> targets) {
        targets.add(this._initTgt);
    }

    public String toString() {
        return this._modelTgt.export();
    }

    @Override
    public boolean verifyTarget(SeqGenerator gen, List<ModelTrans> init) {
        boolean result = gen.isActiveTarget(this._modelTgt);
        if (result && init != null && this._initError == null) {
            this._initError = new ArrayList<ModelTrans>(init);
            this._rset.addSeq(init, true);
        }
        return result;
    }

    @Override
    public boolean addSequence(SeqGenerator gen, ModelTrans[] trs, int order) {
        if (this._initError != null) {
            return false;
        }
        if (gen.isActiveTarget(this._modelTgt)) {
            this._rset.addSeq(trs, order);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(SeqGenerator gen) {
        if (this._initError != null) {
            return false;
        }
        return gen.isActiveTarget(this._modelTgt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResultSet(String header) throws IOException {
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new FileWriter(this._rfile));
            if (this._initError != null) {
                StringBuffer sb = new StringBuffer(this._initError.size() * 4);
                for (int i = 0; i < this._initError.size(); ++i) {
                    ModelTrans tr = this._initError.get(i);
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append(tr.getIdx());
                }
                out.write(sb.toString());
                out.write("\n");
                return;
            }
            this._rset.flush();
            Iterator iCut = this._rset.getSeqIterator();
            while (iCut.hasNext()) {
                ModelTrans[] cut = (ModelTrans[])iCut.next();
                out.write(header);
                for (int i = 0; i < cut.length; ++i) {
                    out.write(Integer.toString(cut[i].getIdx()));
                    out.write(" ");
                }
                out.write("\n");
            }
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int loadResultSet(ZipInputStream zipStream, Map<Integer, ModelTrans> transMap, int curIdx) throws IOException {
        ZipEntry nextEntry = null;
        try {
            nextEntry = zipStream.getNextEntry();
            if (nextEntry == null) {
                throw new IOException("No other entry in SeqGen result file (Current index = " + curIdx + ")\n");
            }
            String name = "ResultTarget" + curIdx + ".res";
            if (!nextEntry.getName().equalsIgnoreCase(name)) {
                throw new IOException("The name of next ZipEntry is not '" + name + "'\n");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(zipStream));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.equals("0")) {
                    ModelTrans[] cut = new ModelTrans[]{};
                    this._rset.addSeq(cut, 0);
                    break;
                }
                StringTokenizer st = new StringTokenizer(line);
                ArrayList<ModelTrans> cut = new ArrayList<ModelTrans>(5);
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    int idx = Integer.parseInt(tok);
                    ModelTrans tr = transMap.get(idx);
                    if (tr == null) {
                        throw new NumberFormatException("Transition number [" + idx + "] unknow");
                    }
                    cut.add(tr);
                }
                this._rset.addSeq(cut, false);
            }
        }
        finally {
            if (nextEntry != null) {
                zipStream.closeEntry();
            }
        }
        return 1;
    }

    @Override
    public void printResultSet(FormatSeqs layout2, SeqGenerator generator) throws IOException {
        this._rset.flush();
        FileWriter out = new FileWriter(this._rfile);
        layout2.printResult(this._rset, out, this._initTgt, generator);
        out.close();
    }

    @Override
    public void setTransitionsFlag(boolean value) {
        this._rset.flush();
        Iterator iTrs = this._rset.getSeqIterator();
        while (iTrs.hasNext()) {
            ModelTrans[] cut = (ModelTrans[])iTrs.next();
            for (int j = 0; j < cut.length; ++j) {
                cut[j]._flag = value;
            }
        }
    }
}

