/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.FormatSeqs;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetFactory;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqTargetAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;

class SeqTargetContainer
implements SeqTargetAbstract {
    List<SeqTargetAbstract> _listTgt = new ArrayList<SeqTargetAbstract>();

    SeqTargetContainer() {
    }

    public void addTarget(SeqTargetAbstract tgt) {
        this._listTgt.add(tgt);
    }

    @Override
    public SeqTargetAbstract cloneTarget(ResultSetFactory rsf) {
        SeqTargetContainer cloneTgt = new SeqTargetContainer();
        for (SeqTargetAbstract childTgt : this._listTgt) {
            cloneTgt.addTarget(childTgt.cloneTarget(rsf));
        }
        return cloneTgt;
    }

    @Override
    public void getTargets(Collection<SeqGenTarget> targets) {
        for (SeqTargetAbstract childTgt : this._listTgt) {
            childTgt.getTargets(targets);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._listTgt.size() * 32);
        sb.append("[\n");
        for (SeqTargetAbstract childTgt : this._listTgt) {
            sb.append("  ").append(childTgt.toString()).append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean verifyTarget(SeqGenerator gen, List<ModelTrans> init) {
        boolean result = true;
        for (SeqTargetAbstract childTgt : this._listTgt) {
            result &= childTgt.verifyTarget(gen, init);
        }
        return result;
    }

    @Override
    public boolean addSequence(SeqGenerator gen, ModelTrans[] trs, int order) {
        boolean result = true;
        for (SeqTargetAbstract childTgt : this._listTgt) {
            result &= childTgt.addSequence(gen, trs, order);
        }
        return result;
    }

    @Override
    public boolean isValid(SeqGenerator gen) {
        boolean result = true;
        for (SeqTargetAbstract childTgt : this._listTgt) {
            result &= childTgt.isValid(gen);
        }
        return result;
    }

    @Override
    public int loadResultSet(ZipInputStream zipStream, Map<Integer, ModelTrans> transMap, int curIdx) throws IOException {
        for (SeqTargetAbstract childTgt : this._listTgt) {
            curIdx += childTgt.loadResultSet(zipStream, transMap, curIdx);
        }
        return curIdx;
    }

    @Override
    public void printResultSet(FormatSeqs layout2, SeqGenerator generator) throws IOException {
        for (SeqTargetAbstract childTgt : this._listTgt) {
            childTgt.printResultSet(layout2, generator);
        }
    }

    @Override
    public void saveResultSet(String header) throws IOException {
        for (SeqTargetAbstract childTgt : this._listTgt) {
            childTgt.saveResultSet(header);
        }
    }

    @Override
    public void setTransitionsFlag(boolean value) {
        for (SeqTargetAbstract childTgt : this._listTgt) {
            childTgt.setTransitionsFlag(value);
        }
    }
}

