/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqverif;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.HelperStepper;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetFlow;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetState;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqSetPlayer;
import com.dassault.cecilia.lib.mbsa.stepuser.seqverif.SeqVerifManager;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import com.dassault.cecilia.lib.util.xmlparser.SAXInterruptException;
import com.dassault.cecilia.lib.util.xmlparser.SAXProcessParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SeqGenFilePlayer
implements SeqSetPlayer {
    SeqVerifManager _owner;
    ModelTargetVar _target;
    Map<String, String> _inits = new TreeMap<String, String>();
    File _datafile;
    HelperStepper _stepper;

    public SeqGenFilePlayer(SeqVerifManager owner) {
        this._owner = owner;
    }

    public void prepareInfo(File file, HelperStepper stepper) throws SAXParseException {
        this._datafile = file;
        this._stepper = stepper;
        SeqGenSAXParserInfo parser = new SeqGenSAXParserInfo(this._datafile);
        parser.action();
    }

    @Override
    public Map<String, String> getInitState() {
        return this._inits;
    }

    @Override
    public boolean playSequences() throws StepperException {
        this._owner.goInitialState(this);
        SeqGenSAXParserPlayer parser = new SeqGenSAXParserPlayer(this._datafile);
        try {
            this._owner.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
            this._owner.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_FILE", this._datafile.getAbsolutePath()));
            this._owner.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_TARGET", this._target.export()));
            parser.action();
            this._owner.addRecord(new LogGenRecord("MSG_CMD_SEQ_FINDER_NBRSEQ", Integer.toString(parser._nbrSeq)));
            this._owner.addRecord(new LogGenRecord("MSG_CMD_COMPUTE_LINE2", new Object[0]));
            return true;
        }
        catch (SAXInterruptException e) {
            if (e.getException() instanceof StepperException) {
                throw (StepperException)e.getException();
            }
            this._owner.addRecord(new LogGenRecord(e));
            return false;
        }
        catch (SAXParseException e) {
            this._owner.addRecord(new LogGenRecord(e));
            return false;
        }
    }

    class SeqGenSAXParserPlayer
    extends SAXProcessParser {
        List<HelperStepper.Event> _curSeq;
        int _nbrSeq;

        public SeqGenSAXParserPlayer(File XMLFile) {
            super(XMLFile, null);
            this._nbrSeq = 0;
            this._curSeq = new ArrayList<HelperStepper.Event>(6);
        }

        @Override
        protected void trace(Exception e) throws SAXParseException {
            if (e instanceof SAXInterruptException) {
                return;
            }
            super.trace(e);
        }

        @Override
        protected SAXExtendedHandler createSAXHandler() {
            return new SeqGenPlayerHandler();
        }

        class SeqGenPlayerHandler
        extends SAXExtendedHandler {
            SeqGenPlayerHandler() {
            }

            @Override
            public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXParseException {
                if (name.equals("seq")) {
                    SeqGenSAXParserPlayer.this._curSeq.clear();
                } else if (name.equals("tr")) {
                    String evtName = attrs.get("evt");
                    HelperStepper.Event evt = SeqGenFilePlayer.this._stepper.getEvent(evtName);
                    SeqGenSAXParserPlayer.this._curSeq.add(evt);
                }
            }

            @Override
            public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
                if (name.equals("seq")) {
                    ++SeqGenSAXParserPlayer.this._nbrSeq;
                    try {
                        boolean playseq = true;
                        for (HelperStepper.Event event : SeqGenSAXParserPlayer.this._curSeq) {
                            if (SeqGenFilePlayer.this._owner.goForward(event)) continue;
                            playseq = false;
                            break;
                        }
                        if (playseq) {
                            SeqGenFilePlayer.this._owner.verifyTarget(SeqGenFilePlayer.this._target, false);
                        }
                        SeqGenFilePlayer.this._owner.goBeginState();
                    }
                    catch (StepperException e) {
                        throw new SAXInterruptException(e, this.getLocator());
                    }
                }
                return false;
            }
        }
    }

    class SeqGenSAXParserInfo
    extends SAXProcessParser {
        String _lastState;
        int _nbrSeq;

        public SeqGenSAXParserInfo(File XMLFile) {
            super(XMLFile, null);
            this._nbrSeq = 0;
        }

        @Override
        protected SAXExtendedHandler createSAXHandler() {
            return new SeqGenInfoHandler();
        }

        class SeqGenInfoHandler
        extends SAXExtendedHandler {
            SeqGenInfoHandler() {
            }

            @Override
            public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXParseException {
                if (name.equals("target") && this.findParent("define")) {
                    String tgtName = attrs.get("name");
                    if (tgtName == null) {
                        throw new SAXParseException("Attribute 'name' of element 'target' not define", this.getLocator());
                    }
                    String tgtValue = attrs.get("value");
                    if (tgtValue == null) {
                        throw new SAXParseException("Attribute 'value' of element 'target' not define", this.getLocator());
                    }
                    HelperStepper.Var var = SeqGenFilePlayer.this._stepper.getVar(tgtName);
                    if (var == null) {
                        throw new SAXParseException("Variable '" + tgtName + "' unknow for model", this.getLocator());
                    }
                    SeqGenFilePlayer.this._target = var.isState() ? new ModelTargetState(tgtName, var.getIdx()) : new ModelTargetFlow(tgtName, var.getIdx());
                    SeqGenFilePlayer.this._target.setStrValue(tgtValue);
                } else if (name.equals("state")) {
                    SeqGenSAXParserInfo.this._lastState = attrs.get("name");
                    if (SeqGenSAXParserInfo.this._lastState == null) {
                        throw new SAXParseException("Attribute 'name' of element 'state' not define", this.getLocator());
                    }
                } else if (name.equals("tr")) {
                    if (!this.findParent("seq")) {
                        throw new SAXParseException("Element 'tr' not in element 'seq'", this.getLocator());
                    }
                    String evtName = attrs.get("evt");
                    if (evtName == null) {
                        throw new SAXParseException("Attribute 'evt' of element 'tr' not define", this.getLocator());
                    }
                    HelperStepper.Event evt = SeqGenFilePlayer.this._stepper.getEvent(evtName);
                    if (evt == null) {
                        throw new SAXParseException("Event '" + evtName + "' unknow for model", this.getLocator());
                    }
                } else if (name.equals("init") && this.findParent("state")) {
                    String value = attrs.get("value");
                    if (value == null) {
                        throw new SAXParseException("Attribute 'value' of element 'init' not define", this.getLocator());
                    }
                    SeqGenFilePlayer.this._inits.put(SeqGenSAXParserInfo.this._lastState, value);
                }
            }

            @Override
            public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
                if (name.equals("define")) {
                    if (SeqGenFilePlayer.this._target == null) {
                        throw new SAXParseException("No element 'target' of element 'define'", this.getLocator());
                    }
                } else if (name.equals("state")) {
                    SeqGenSAXParserInfo.this._lastState = null;
                } else if (name.equals("seq")) {
                    ++SeqGenSAXParserInfo.this._nbrSeq;
                }
                return false;
            }

            @Override
            public void endDocument() throws SAXException {
                super.endDocument();
                if (SeqGenFilePlayer.this._target == null) {
                    throw new SAXParseException("No element 'target' of element 'define'", this.getLocator());
                }
                if (SeqGenSAXParserInfo.this._nbrSeq == 0) {
                    throw new SAXParseException("No sequences found", this.getLocator());
                }
            }
        }
    }
}

