/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class ExprParent
extends Data {
    private static Iterator<ExprParent> __emptyIter = new Iterator<ExprParent>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ExprParent next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    protected abstract boolean exchangeChild(Expr var1, Expr var2);

    public Iterator<ExprParent> getParents() {
        return __emptyIter;
    }

    public void setFlagParentPropage(char value) {
        if (this._flag == value) {
            return;
        }
        this._flag = value;
        Iterator<ExprParent> iParents = this.getParents();
        while (iParents.hasNext()) {
            iParents.next().setFlagParentPropage(value);
        }
    }

    private static void clearParentsCache(ExprParent current, Node owner) {
        current._flag = (char)(current._flag + '\u0001');
        if (current._flag > '\u0001') {
            return;
        }
        Iterator<ExprParent> iter = current.getParents();
        while (iter.hasNext()) {
            ExprParent.clearParentsCache(iter.next(), owner);
        }
        if (current instanceof Expr) {
            owner.delUniqueExpr((Expr)current);
        }
    }

    private static void exchangeChild_rec(ExprParent oldParent, Node owner, Expr oldChild, Expr newChild) {
        if (oldParent._flag == '\u0000') {
            return;
        }
        oldParent._flag = (char)(oldParent._flag - '\u0001');
        if (oldParent._flag > '\u0000') {
            return;
        }
        boolean exchange = false;
        if (oldChild != newChild && !(exchange = oldParent.exchangeChild(oldChild, newChild))) {
            MsgTrans.LOG.fine("NotExchangeChild:" + oldParent.toString() + ", " + oldChild.toString());
        }
        if (oldParent instanceof Expr) {
            Expr newParent = owner.addUniqueExpr((Expr)oldParent);
            if (exchange) {
                newChild.addParent(newParent);
                if (oldParent != newParent) {
                    for (int i = newParent.getArgCount() - 1; i >= 0; --i) {
                        newParent.getArg(i).removeParent(oldParent);
                    }
                }
            }
            Iterator<ExprParent> iter = oldParent.getParents();
            while (iter.hasNext()) {
                ExprParent.exchangeChild_rec(iter.next(), owner, (Expr)oldParent, newParent);
            }
        } else if (exchange) {
            newChild.addParent(oldParent);
        }
    }

    public static void debugVerifyParents(ExprParent child) {
        Iterator<ExprParent> iter = child.getParents();
        while (iter.hasNext()) {
            ExprParent parent = iter.next();
            if (parent instanceof Expr) {
                Expr exprParent = (Expr)parent;
                boolean find = false;
                for (int i = exprParent.getArgCount() - 1; !find && i >= 0; --i) {
                    if (exprParent.getArg(i) != child) continue;
                    find = true;
                }
                if (!find) {
                    MsgTrans.LOG.fine("ChildUnknown:" + child.toString() + ", " + exprParent.toString());
                }
            }
            ExprParent.debugVerifyParents(parent);
        }
    }

    public final void exchangeChild(Node owner, ExprVar oldChild, ExprVar newChild) {
        if (MsgTrans.LOG.isLoggable(Level.FINE)) {
            ExprParent.debugVerifyParents(this);
        }
        ExprParent.clearParentsCache(this, owner);
        ExprParent.exchangeChild_rec(this, owner, oldChild, newChild);
    }
}

