/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprUndef;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Link;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.util.ArrayList;
import java.util.List;

public class Fct
extends Node {
    private Flow _out = null;

    public Fct(Model parent, String name) {
        super(parent, name);
    }

    public Domain getDomain() {
        return this._out.getDomain();
    }

    public boolean isBoolean() {
        return this._out.getDomain().isBoolean();
    }

    public boolean isNumeric() {
        return this._out.getDomain().isNumeric();
    }

    public boolean isSymbolic() {
        return this._out.getDomain().isSymbolic();
    }

    public boolean isStructured() {
        return this._out.getDomain().isStructured();
    }

    @Override
    public void addFlow(Flow flow) throws TranslateException {
        this.verifyNamedObj(flow.getName(), flow, false);
        if (flow.getDomain().isStructured() && ((Link)flow.getDomain()).withInverse()) {
            throw new TranslateException(flow, "EXC_FUNC_STRUCT_INV", new Object[0]);
        }
        if (flow.getOrientation() == '\u0002') {
            if (this._out != null) {
                throw new TranslateException(flow, "EXC_FUNC_OUT_EXIST", new Object[0]);
            }
            this._out = flow;
        }
        this.addDomainToSymbolic(flow.getDomain());
        this.addPrivateFlow(flow);
    }

    @Override
    public void addAssert(Expr expr) throws TranslateException {
        if (expr == null) {
            return;
        }
        if (expr.withType(ExprUndef.class)) {
            throw new TranslateException(expr, "EXC_EXPR_UNDEF", new Object[0]);
        }
        expr = expr.convertVar(this);
        if ((expr = expr.verify(this, true)).isConstant() && expr.isBoolean()) {
            if (!expr.getBool()) {
                throw new TranslateException(expr, "EXC_ASSERT_FALSE", new Object[0]);
            }
        } else {
            this.addPrivateAssert(expr);
        }
    }

    public void verify(Node node, Expr expr, Expr[] args) throws TranslateException {
        int cpt = 0;
        for (int i = 0; i < this.getFlowCount(); ++i) {
            if (this.getFlow(i).getOrientation() != '\u0001') continue;
            if (cpt >= args.length) {
                throw new TranslateException(args.length > 0 ? args[0] : this, "EXC_FUNC_ARGS_NBR", new Object[0]);
            }
            Domain dm = this.getFlow(i).getDomain();
            if (dm.isBoolean()) {
                if (!args[cpt].isBoolean()) {
                    throw new TranslateException(expr, "EXC_EXPR_NOBOOL", args[cpt].toLL());
                }
            } else if (dm.isNumeric()) {
                if (!args[cpt].isNumeric()) {
                    throw new TranslateException(expr, "EXC_EXPR_NONUMERIC", args[cpt].toLL());
                }
            } else if (dm.isSymbolic()) {
                if (!args[cpt].isSymbolic()) {
                    throw new TranslateException(expr, "EXC_EXPR_NOSYMBOL", args[cpt].toLL());
                }
            } else if (dm.isStructured()) {
                if (!args[cpt].isStructured()) {
                    throw new TranslateException(expr, "EXC_EXPR_NOSTRUCT", args[cpt].toLL());
                }
                if (dm != args[cpt].getDomain()) {
                    throw new TranslateException(args[cpt], "EXC_EXPR_EQUALITY", new Object[0]);
                }
            }
            ++cpt;
        }
        if (cpt != args.length) {
            throw new TranslateException(args.length > 0 ? args[0] : this, "EXC_FUNC_ARGS_NBR", new Object[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Expr translate(Node node, Expr[] args) {
        out = null;
        name = this.getName() + "^" + node.getCpt();
        sign = new ArrayList<Expr>();
        cpt = 0;
        block9: for (i = 0; i < this.getFlowCount(); ++i) {
            switch (this.getFlow(i).getOrientation()) {
                case '\u0002': {
                    flow = new Flow(name, this.getFlow(i).getDomain(), '\u0003');
                    flow.setPosition(this, "Function result");
                    try {
                        node.addFlow(flow);
                    }
                    catch (TranslateException pe) {
                        pe.printStackTrace();
                        if (Fct.$assertionsDisabled) ** GOTO lbl17
                        throw new AssertionError();
                    }
lbl17:
                    // 2 sources

                    out = new ExprVar(flow);
                    out.setPosition(this, "Function result");
                    sign.add(out);
                    continue block9;
                }
                case '\u0003': {
                    flow = new Flow(name + '^' + this.getFlow(i).getName(), this.getFlow(i).getDomain(), '\u0003');
                    flow.setPosition(this, "Argument function");
                    try {
                        node.addFlow(flow);
                    }
                    catch (TranslateException pe) {
                        pe.printStackTrace();
                        if (Fct.$assertionsDisabled) ** GOTO lbl32
                        throw new AssertionError();
                    }
lbl32:
                    // 2 sources

                    local = new ExprVar(flow);
                    local.setPosition(this, "Function result");
                    sign.add(local);
                    continue block9;
                }
                case '\u0001': {
                    sign.add(args[cpt++]);
                }
            }
        }
        for (i = 0; i < this.getAssertCount(); ++i) {
            clone = (Expr)this.getAssert(i).clone();
            clone = this.instance(clone, sign);
            node.addTranslateAssert(clone);
        }
        return out;
    }

    public Expr instance(Expr cur, List<Expr> args) {
        if (cur instanceof ExprVar) {
            ExprVar var = (ExprVar)cur;
            String context = var.getContext();
            if (context.length() > 0 && context.charAt(context.length() - 1) == '^') {
                String name = context.substring(0, context.length() - 1);
                for (int i = 0; i < this.getFlowCount(); ++i) {
                    if (!this.getFlow(i).getName().equals(name)) continue;
                    Expr arg = args.get(i);
                    assert (arg instanceof ExprVar);
                    assert (arg.getDomain() == this.getFlow(i).getDomain());
                    var.setContext(arg.toString() + "^");
                    return null;
                }
            }
            for (int i = 0; i < this.getFlowCount(); ++i) {
                if (!this.getFlow(i).getName().equals(var.getVar().getName())) continue;
                return args.get(i);
            }
            assert (false) : cur.toString();
            return null;
        }
        for (int i = 0; i < cur.getArgCount(); ++i) {
            Expr expr = this.instance(cur.getArg(i), args);
            if (expr == null) continue;
            cur.setArg(i, expr);
        }
        return cur;
    }
}

