/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainDefine;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainEnum;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainRange;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCstEnum;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Recorder {
    protected static final boolean TRACE = false;
    protected static final boolean TRACE_DOMAIN = false;
    protected static final boolean TRACE_VARS = false;
    protected static final boolean TRACE_EXPR = false;
    protected static final boolean TRACE_EVENT = false;
    protected static final boolean TRACE_SIM = false;
    protected static final boolean TRACE_TRANS = false;
    protected boolean _askReload = false;
    protected static final int VERSION = 2;
    protected int _version = 2;
    private static final String PROP_FORCE_WRITE_VERSION = "cecilia.mbsa.translator.recorder.VersionWrite";
    protected static final int VERSION_WRITE = Integer.getInteger("cecilia.mbsa.translator.recorder.VersionWrite", 2);
    private Map<Domain, Integer> _Domain2ID;
    private List<Domain> _ID2Domain;
    private Map<Var, Integer> _Var2ID;
    private List<Var> _ID2Var;
    private Map<Expr, Integer> _Expr2ID;
    private Map<Expr, Integer> _secoursExpr2ID;
    private List<Expr> _ID2Expr;
    private Map<Event, Integer> _Evt2ID;
    private List<Event> _ID2Evt;

    public boolean getAskReload() {
        return this._askReload;
    }

    protected void writeVersion(DataOutput out) throws IOException {
        out.writeInt(-1);
        out.writeInt(VERSION_WRITE);
    }

    protected int readVersion(DataInput in) throws IOException {
        int firstInt = in.readInt();
        if (firstInt < 0) {
            this._version = in.readInt();
            if (this._version > 2) {
                throw new IOException(MsgTrans.msgFormat("EXC_RECORDER_VERSION", this._version));
            }
        } else {
            this._version = 0;
        }
        return firstInt;
    }

    protected final int getIDDomain(Domain domain) throws IOException {
        Integer ID = this._Domain2ID.get(domain);
        if (ID == null) {
            throw new IOException("ID null for domain " + domain.toString());
        }
        return ID;
    }

    protected void writeDomainDefine(DataOutput out, DomainDefine domains) throws IOException {
        int i;
        int ID = 0;
        this._Domain2ID = new IdentityHashMap<Domain, Integer>();
        this._Domain2ID.put(domains.getUndef(), ID++);
        this._Domain2ID.put(domains.getBool(), ID++);
        this._Domain2ID.put(domains.getInt(), ID++);
        this._Domain2ID.put(domains.getFloat(), ID++);
        int size = domains.getEnumSize();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeUTF(domains.getEnumStr(i));
        }
        size = domains._createDomains.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            Domain dom = domains.getDomainFromIndex(i);
            this._Domain2ID.put(dom, ID++);
            if (dom instanceof DomainRange) {
                DomainRange domRange = (DomainRange)dom;
                out.writeByte(1);
                out.writeInt(domRange._min);
                out.writeInt(domRange._max);
                continue;
            }
            if (!(dom instanceof DomainEnum)) continue;
            DomainEnum domEnum = (DomainEnum)dom;
            out.writeByte(2);
            int sizeEnum = domEnum._enums.size();
            out.writeInt(sizeEnum);
            for (int j = 0; j < sizeEnum; ++j) {
                out.writeInt(domEnum._enums.get(j));
            }
        }
    }

    protected final Domain getDomainFromID(int ID) throws IOException {
        if (ID < 0 || ID >= this._ID2Domain.size()) {
            throw new IOException("ID domain exception : " + ID);
        }
        return this._ID2Domain.get(ID);
    }

    protected void readDomainDefine(DataInput in, DomainDefine domainDefine, int firstInt) throws IOException {
        int i;
        int nbrEnum = firstInt;
        if (nbrEnum < 0) {
            nbrEnum = in.readInt();
        }
        for (i = 0; i < nbrEnum; ++i) {
            String str = in.readUTF();
            domainDefine.addEnumStr(str);
        }
        int nbrDomain = in.readInt();
        this._ID2Domain = new ArrayList<Domain>(nbrDomain + 4);
        this._ID2Domain.add(domainDefine.getUndef());
        this._ID2Domain.add(domainDefine.getBool());
        this._ID2Domain.add(domainDefine.getInt());
        this._ID2Domain.add(domainDefine.getFloat());
        for (i = 0; i < nbrDomain; ++i) {
            byte type = in.readByte();
            if (type == 1) {
                int min = in.readInt();
                int max = in.readInt();
                DomainRange dom = new DomainRange(min, max);
                domainDefine.addDomain(dom);
                this._ID2Domain.add(dom);
                continue;
            }
            if (type == 2) {
                DomainEnum dom = new DomainEnum();
                dom._define = domainDefine;
                int nbrEnum2 = in.readInt();
                dom._enums = new ArrayList(nbrEnum2);
                for (int j = 0; j < nbrEnum2; ++j) {
                    int idEnum = in.readInt();
                    dom._enums.add(idEnum);
                }
                domainDefine.addDomain(dom);
                this._ID2Domain.add(dom);
                continue;
            }
            throw new IOException("Type of domain unknow");
        }
        if (nbrDomain != domainDefine._createDomains.size()) {
            throw new IOException("Unconsistency during read domains");
        }
    }

    protected void writeNode(DataOutput out, Node node) throws IOException {
        node.setFlagPropage('\u0000');
        this.writeVariables(out, node);
        this.writeExpressions(out, node);
        this.writeEvents(out, node);
    }

    protected void readNode(DataInput in, Node node) throws IOException {
        this.readVariables(in, node);
        this.readExpressions(in, node);
        this.readEvents(in, node);
    }

    protected final int getIDVar(Var var) throws IOException {
        Integer ID = this._Var2ID.get(var);
        if (ID == null) {
            throw new IOException("ID null for variable " + var.toString());
        }
        return ID;
    }

    private void writeVariables(DataOutput out, Node node) throws IOException {
        int idDom;
        Var var;
        int nbrState = node.getStateCount();
        out.writeInt(nbrState);
        int nbrFlow = node.getFlowCount();
        out.writeInt(nbrFlow);
        int ID = 0;
        this._Var2ID = new IdentityHashMap<Var, Integer>();
        int i = 0;
        while (i < nbrState) {
            var = node.getState(i);
            this._Var2ID.put(var, ID);
            out.writeUTF(var.getName());
            idDom = this.getIDDomain(var.getDomain());
            out.writeInt(idDom);
            ++i;
            ++ID;
        }
        i = 0;
        while (i < nbrFlow) {
            var = node.getFlow(i);
            this._Var2ID.put(var, ID);
            out.writeUTF(var.getName());
            idDom = this.getIDDomain(var.getDomain());
            out.writeInt(idDom);
            ++i;
            ++ID;
        }
    }

    protected final Var getVarFromID(int ID) throws IOException {
        if (ID < 0 || ID >= this._ID2Var.size()) {
            throw new IOException("ID variable exception : " + ID);
        }
        return this._ID2Var.get(ID);
    }

    private void readVariables(DataInput in, Node node) throws IOException {
        Var var;
        int idDomain;
        String name;
        int i;
        int nbrState = in.readInt();
        int nbrFlow = in.readInt();
        this._ID2Var = new ArrayList<Var>(nbrState + nbrFlow);
        for (i = 0; i < nbrState; ++i) {
            name = in.readUTF();
            idDomain = in.readInt();
            var = new State(name, this.getDomainFromID(idDomain));
            node.addPrivateState((State)var);
            this._ID2Var.add(var);
        }
        for (i = 0; i < nbrFlow; ++i) {
            name = in.readUTF();
            idDomain = in.readInt();
            var = new Flow(name, this.getDomainFromID(idDomain));
            node.addPrivateFlow((Flow)var);
            this._ID2Var.add(var);
        }
    }

    protected final int getIDExpr(Expr expr) throws IOException {
        Integer ID = this._Expr2ID.get(expr);
        if (ID == null) {
            MsgTrans.LOG.fine("UseRescueMap: NoIDForExpr: " + expr.toLL());
            this._askReload = true;
            ID = this._secoursExpr2ID.get(expr);
            if (ID == null) {
                throw new IOException("ID null for expr " + expr.toLL());
            }
        }
        return ID;
    }

    private void writeExpressions(DataOutput out, Node node) throws IOException {
        int ID = 0;
        this._Expr2ID = new IdentityHashMap<Expr, Integer>();
        this._secoursExpr2ID = new HashMap<Expr, Integer>();
        Collection<? extends Expr> exprs = node.getStoreExpr().getExpressions();
        for (Expr expr : exprs) {
            int exprID = ID++;
            this._Expr2ID.put(expr, exprID);
            this._secoursExpr2ID.put(expr, exprID);
        }
        out.writeInt(exprs.size());
        for (Expr expr : exprs) {
            if (expr instanceof ExprCstEnum) {
                out.writeByte(99);
                String key = ((ExprCstEnum)expr).getString();
                out.writeUTF(key);
                out.writeInt((int)expr.getDouble());
                continue;
            }
            if (expr instanceof ExprCst) {
                out.writeByte(100);
                out.writeByte(expr.getScale().getIndex());
                out.writeDouble(expr.getDouble());
                continue;
            }
            if (expr instanceof ExprVar) {
                out.writeByte(101);
                Var var = ((ExprVar)expr).getVar();
                out.writeInt(this.getIDVar(var));
                continue;
            }
            if (!(expr instanceof ExprOp)) continue;
            ExprOp op = (ExprOp)expr;
            out.writeByte(op.getType().getIndex());
            int argNbr = op.getArgCount();
            out.writeInt(argNbr);
            for (int i = 0; i < argNbr; ++i) {
                Expr arg = op.getArg(i);
                out.writeInt(this.getIDExpr(arg));
            }
        }
    }

    protected final Expr getExprFromID(int ID) throws IOException {
        if (ID < 0 || ID >= this._ID2Expr.size()) {
            throw new IOException("ID expression exception : " + ID);
        }
        return this._ID2Expr.get(ID);
    }

    private void readExpressions(DataInput in, Node node) throws IOException {
        int i;
        int nbrExpr = in.readInt();
        this._ID2Expr = new ArrayList<Expr>(nbrExpr);
        ArrayList<int[]> expressionsArgs = new ArrayList<int[]>(nbrExpr);
        for (i = 0; i < nbrExpr; ++i) {
            byte type = in.readByte();
            if (type == 99) {
                String key = in.readUTF();
                int id = in.readInt();
                ExprCstEnum expr = new ExprCstEnum(id, key);
                this._ID2Expr.add(expr);
                expressionsArgs.add(null);
                continue;
            }
            if (type == 100) {
                byte scale = in.readByte();
                double value = in.readDouble();
                ExprCst expr = new ExprCst(value, Expr.Scale.valueOf(scale));
                this._ID2Expr.add(expr);
                expressionsArgs.add(null);
                continue;
            }
            if (type == 101) {
                int idVar = in.readInt();
                Var var = this.getVarFromID(idVar);
                ExprVar expr = new ExprVar(var);
                this._ID2Expr.add(expr);
                expressionsArgs.add(null);
                continue;
            }
            ExprOp.Type opType = ExprOp.Type.valueOf(type);
            ExprOp expr = new ExprOp(opType);
            this._ID2Expr.add(expr);
            int nbrArg = in.readInt();
            int[] argsID = new int[nbrArg];
            for (int j = 0; j < nbrArg; ++j) {
                argsID[j] = in.readInt();
            }
            expressionsArgs.add(argsID);
        }
        for (i = 0; i < nbrExpr; ++i) {
            Expr expr = this._ID2Expr.get(i);
            if (!(expr instanceof ExprOp)) continue;
            int[] argsID = (int[])expressionsArgs.get(i);
            if (argsID == null) {
                throw new IOException("None argument for expression : " + (Object)((Object)((ExprOp)expr).getType()));
            }
            Expr[] argsExpr = new Expr[argsID.length];
            for (int j = 0; j < argsID.length; ++j) {
                argsExpr[j] = this.getExprFromID(argsID[j]);
            }
            ((ExprOp)expr)._args = argsExpr;
        }
        for (i = 0; i < nbrExpr; ++i) {
            Expr expr = this._ID2Expr.get(i);
            Expr uniqueExpr = node.addUniqueExpr(expr);
            if (uniqueExpr == expr) continue;
            throw new IOException("Unconsistency during read expression : " + expr.toString());
        }
    }

    protected final int getIDEvent(Event evt) throws IOException {
        Integer ID = this._Evt2ID.get(evt);
        if (ID == null) {
            throw new IOException("ID null for event " + evt.toString());
        }
        return ID;
    }

    private void writeEvents(DataOutput out, Node node) throws IOException {
        int ID = 0;
        this._Evt2ID = new IdentityHashMap<Event, Integer>();
        int size = node.getEventCount();
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            Event evt = node.getEvent(i);
            this._Evt2ID.put(evt, ID);
            out.writeUTF(evt.getName());
            if (evt.isStochastic()) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                out.writeInt(evt.getPriority());
                out.writeDouble(evt.computeDelay(0.0));
            }
            ++i;
            ++ID;
        }
    }

    protected final Event getEventFromID(int ID) throws IOException {
        if (ID < 0 || ID >= this._ID2Evt.size()) {
            throw new IOException("ID event exception : " + ID);
        }
        return this._ID2Evt.get(ID);
    }

    private void readEvents(DataInput in, Node node) throws IOException {
        int size = in.readInt();
        this._ID2Evt = new ArrayList<Event>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            Event evt = new Event(name);
            boolean isStochastic = in.readBoolean();
            if (!isStochastic) {
                evt.putSimulTool("priority", in.readInt());
                evt.putSimulTool("simul-delay", in.readDouble());
            }
            this._ID2Evt.add(evt);
        }
    }

    protected void writeSimular(DataOutput out, Simular sim) throws IOException {
        int idVar = this.getIDVar(sim._var);
        out.writeInt(idVar);
        Collection<Var> alias = sim.getListAlias();
        int size = alias.size();
        out.writeInt(size);
        for (Var var : alias) {
            out.writeInt(this.getIDVar(var));
        }
        out.writeDouble(sim._initValue);
        if (sim._define == null) {
            out.writeInt(-1);
        } else {
            int idDefine = this.getIDExpr(sim._define);
            out.writeInt(idDefine);
        }
    }

    protected Simular readSimular(DataInput in, Node node) throws IOException {
        int idVar = in.readInt();
        Var ref = this.getVarFromID(idVar);
        Simular sim = new Simular(node, ref);
        Collection<Var> alias = sim.getListAlias();
        int nbrAlias = in.readInt();
        for (int i = 0; i < nbrAlias; ++i) {
            Var var = this.getVarFromID(in.readInt());
            alias.add(var);
            var.setSimular(sim);
        }
        sim.setInitValue(in.readDouble());
        int idDefine = in.readInt();
        if (idDefine != -1) {
            sim.setDefine(this.getExprFromID(idDefine));
        }
        ref.setSimular(sim);
        return sim;
    }

    protected void writeTransition(DataOutput out, Trans tr) throws IOException {
        int idGuard = this.getIDExpr(tr.getGuard());
        out.writeInt(idGuard);
        int idEvt = this.getIDEvent(tr.getEvent());
        out.writeInt(idEvt);
        List<Data> affects = tr.getAffects();
        int size = affects.size();
        out.writeInt(size);
        int i = 0;
        while (i < affects.size()) {
            int idVar = this.getIDVar((State)affects.get(i++));
            int idExpr = this.getIDExpr((Expr)affects.get(i++));
            out.writeInt(idVar);
            out.writeInt(idExpr);
        }
    }

    protected Trans readTransition(DataInput in) throws IOException {
        Trans tr = new Trans();
        try {
            int idGuard = in.readInt();
            tr.setGuard(this.getExprFromID(idGuard));
            int idEvt = in.readInt();
            tr.setEvent(this.getEventFromID(idEvt));
            int nbrAffect = in.readInt();
            for (int i = 0; i < nbrAffect; i += 2) {
                int idVar = in.readInt();
                int idExpr = in.readInt();
                Var var = this.getVarFromID(idVar);
                if (!(var instanceof State)) {
                    throw new IOException("Transition affection with no state variable");
                }
                Expr affect = this.getExprFromID(idExpr);
                tr.addPrivateAffect((State)var, affect);
            }
        }
        catch (TranslateException exc) {
            throw new IOException("Create transition error", exc);
        }
        return tr;
    }
}

